/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.console.command.AbstractCommand;
import org.apache.activemq.util.ConsumerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerCommand
extends AbstractCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerCommand.class);
    String brokerUrl = ActiveMQConnectionFactory.DEFAULT_BROKER_URL;
    String user = ActiveMQConnectionFactory.DEFAULT_USER;
    String password = ActiveMQConnectionFactory.DEFAULT_PASSWORD;
    String destination = "queue://TEST";
    int messageCount = 1000;
    int sleep;
    int transactionBatchSize;
    int parallelThreads = 1;

    @Override
    protected void runTask(List<String> tokens) throws Exception {
        LOG.info("Connecting to URL: " + this.brokerUrl + " (" + this.user + ":" + this.password + ")");
        LOG.info("Consuming " + this.destination);
        LOG.info("Sleeping between receives " + this.sleep + " ms");
        LOG.info("Running " + this.parallelThreads + " parallel threads");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerUrl);
        Connection conn = factory.createConnection(this.user, this.password);
        conn.start();
        Session sess = this.transactionBatchSize != 0 ? conn.createSession(true, 0) : conn.createSession(false, 1);
        CountDownLatch active = new CountDownLatch(this.parallelThreads);
        for (int i = 1; i <= this.parallelThreads; ++i) {
            ConsumerThread consumer = new ConsumerThread(sess, ActiveMQDestination.createDestination(this.destination, (byte)1));
            consumer.setName("consumer-" + i);
            consumer.setBreakOnNull(false);
            consumer.setMessageCount(this.messageCount);
            consumer.setSleep(this.sleep);
            consumer.setTransactionBatchSize(this.transactionBatchSize);
            consumer.setFinished(active);
            consumer.start();
        }
        active.await();
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public void setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
    }

    public int getParallelThreads() {
        return this.parallelThreads;
    }

    public void setParallelThreads(int parallelThreads) {
        this.parallelThreads = parallelThreads;
    }

    @Override
    protected void printHelp() {
        this.printHelpFromFile();
    }

    @Override
    public String getName() {
        return "consumer";
    }

    @Override
    public String getOneLineDescription() {
        return "Receives messages from the broker";
    }
}

