/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.gogo.api.CommandSessionListener;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandProcessorImpl
implements CommandProcessor {
    protected final Set<Converter> converters = new CopyOnWriteArraySet<Converter>();
    protected final Set<CommandSessionListener> listeners = new CopyOnWriteArraySet<CommandSessionListener>();
    protected final ConcurrentMap<String, Map<Object, Integer>> commands = new ConcurrentHashMap<String, Map<Object, Integer>>();
    protected final Map<String, Object> constants = new ConcurrentHashMap<String, Object>();
    protected final ThreadIO threadIO;
    protected final WeakHashMap<CommandSession, Object> sessions = new WeakHashMap();
    protected boolean stopped;

    public CommandProcessorImpl(ThreadIO tio) {
        this.threadIO = tio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandSession createSession(InputStream in, PrintStream out, PrintStream err) {
        WeakHashMap<CommandSession, Object> weakHashMap = this.sessions;
        synchronized (weakHashMap) {
            if (this.stopped) {
                throw new IllegalStateException("CommandProcessor has been stopped");
            }
            CommandSessionImpl session = new CommandSessionImpl(this, in, out, err);
            this.sessions.put(session, null);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        WeakHashMap<CommandSession, Object> weakHashMap = this.sessions;
        synchronized (weakHashMap) {
            this.stopped = true;
            for (CommandSession session : this.sessions.keySet()) {
                session.close();
            }
        }
    }

    public void addConverter(Converter c) {
        this.converters.add(c);
    }

    public void removeConverter(Converter c) {
        this.converters.remove(c);
    }

    public void addListener(CommandSessionListener l) {
        this.listeners.add(l);
    }

    public void removeListener(CommandSessionListener l) {
        this.listeners.remove(l);
    }

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Function getCommand(String name, Object path) {
        int colon = name.indexOf(58);
        if (colon < 0) {
            return null;
        }
        name = name.toLowerCase();
        String cfunction = name.substring(colon);
        boolean anyScope = colon == 1 && name.charAt(0) == '*';
        Map cmdMap = (Map)this.commands.get(name);
        if (null == cmdMap && anyScope) {
            String scopePath = null == path ? "*" : path.toString();
            block3: for (String scope : scopePath.split(":")) {
                if (scope.equals("*")) {
                    for (Map.Entry entry : this.commands.entrySet()) {
                        if (!((String)entry.getKey()).endsWith(cfunction)) continue;
                        cmdMap = (Map)entry.getValue();
                        continue block3;
                    }
                    continue;
                }
                cmdMap = (Map)this.commands.get(scope + cfunction);
                if (cmdMap != null) break;
            }
        }
        Object cmd = null;
        if (cmdMap != null && !cmdMap.isEmpty()) {
            Map map = cmdMap;
            synchronized (map) {
                for (Map.Entry e : cmdMap.entrySet()) {
                    if (cmd != null && (Integer)e.getValue() <= (Integer)cmdMap.get(cmd)) continue;
                    cmd = e.getKey();
                }
            }
        }
        if (null == cmd || cmd instanceof Function) {
            return cmd;
        }
        return new CommandProxy(cmd, cfunction.substring(1));
    }

    public void addCommand(String scope, Object target) {
        Class<?> tc = target instanceof Class ? (Class<?>)target : target.getClass();
        this.addCommand(scope, target, tc);
    }

    public void addCommand(String scope, Object target, Class<?> functions) {
        this.addCommand(scope, target, functions, 0);
    }

    public void addCommand(String scope, Object target, Class<?> functions, int ranking) {
        String[] names;
        if (target == null) {
            return;
        }
        for (String function : names = this.getFunctions(functions)) {
            this.addCommand(scope, target, function, ranking);
        }
    }

    public Object addConstant(String name, Object target) {
        return this.constants.put(name, target);
    }

    public Object removeConstant(String name) {
        return this.constants.remove(name);
    }

    public void addCommand(String scope, Object target, String function) {
        this.addCommand(scope, target, function, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(String scope, Object target, String function, int ranking) {
        String key = (scope + ":" + function).toLowerCase();
        Map cmdMap = (Map)this.commands.get(key);
        if (cmdMap == null) {
            this.commands.putIfAbsent(key, new LinkedHashMap());
            cmdMap = (Map)this.commands.get(key);
        }
        Map map = cmdMap;
        synchronized (map) {
            cmdMap.put(target, ranking);
        }
    }

    public void removeCommand(String scope, String function) {
        String key = (scope + ":" + function).toLowerCase();
        this.commands.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(String scope, String function, Object target) {
        String key = (scope + ":" + function).toLowerCase();
        Map cmdMap = (Map)this.commands.get(key);
        if (cmdMap != null) {
            Map map = cmdMap;
            synchronized (map) {
                cmdMap.remove(target);
            }
        }
    }

    public void removeCommand(Object target) {
        for (Map cmdMap : this.commands.values()) {
            cmdMap.remove(target);
        }
    }

    private String[] getFunctions(Class<?> target) {
        Method[] methods;
        TreeSet<String> list = new TreeSet<String>();
        for (Method m : methods = target.getMethods()) {
            String s;
            if (m.getDeclaringClass().equals(Object.class)) continue;
            list.add(m.getName());
            if (!m.getName().startsWith("get") || (s = m.getName().substring(3)).length() <= 0) continue;
            list.add(s.substring(0, 1).toLowerCase() + s.substring(1));
        }
        String[] functions = list.toArray(new String[list.size()]);
        return functions;
    }

    public Object convert(Class<?> desiredType, Object in) {
        for (Converter c : this.converters) {
            try {
                Object converted = c.convert(desiredType, in);
                if (converted == null) continue;
                return converted;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object eval(CommandSession session, Object[] argv) throws Exception {
        StringBuilder buf = new StringBuilder();
        for (Object arg : argv) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(arg);
        }
        return session.execute(buf);
    }

    void beforeExecute(CommandSession session, CharSequence commandline) {
        for (CommandSessionListener l : this.listeners) {
            try {
                l.beforeExecute(session, commandline);
            }
            catch (Throwable t) {}
        }
    }

    void afterExecute(CommandSession session, CharSequence commandline, Exception exception) {
        for (CommandSessionListener l : this.listeners) {
            try {
                l.afterExecute(session, commandline, exception);
            }
            catch (Throwable t) {}
        }
    }

    void afterExecute(CommandSession session, CharSequence commandline, Object result) {
        for (CommandSessionListener l : this.listeners) {
            try {
                l.afterExecute(session, commandline, result);
            }
            catch (Throwable t) {}
        }
    }
}

