/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.thread.SchedulerTimerTask;
import org.apache.activemq.transport.AbstractInactivityMonitor;
import org.apache.activemq.transport.InactivityIOException;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.amqp.AmqpProtocolConverter;
import org.apache.activemq.util.ThreadPoolUtils;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpInactivityMonitor
extends TransportFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpInactivityMonitor.class);
    private static ThreadPoolExecutor ASYNC_TASKS;
    private static int CHECKER_COUNTER;
    private static Timer ACTIVITY_CHECK_TIMER;
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private AmqpProtocolConverter protocolConverter;
    private long connectionTimeout = 30000L;
    private SchedulerTimerTask connectCheckerTask;
    private final Runnable connectChecker = new Runnable(){
        private final long startTime = System.currentTimeMillis();

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            if (now - this.startTime >= AmqpInactivityMonitor.this.connectionTimeout && AmqpInactivityMonitor.this.connectCheckerTask != null && !ASYNC_TASKS.isTerminating()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No connection attempt made in time for " + AmqpInactivityMonitor.this.toString() + "! Throwing InactivityIOException.");
                }
                ASYNC_TASKS.execute(new Runnable(){

                    @Override
                    public void run() {
                        AmqpInactivityMonitor.this.onException(new InactivityIOException("Channel was inactive for too (>" + AmqpInactivityMonitor.this.connectionTimeout + ") long: " + AmqpInactivityMonitor.this.next.getRemoteAddress()));
                    }
                });
            }
        }
    };
    private final ThreadFactory factory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "AmqpInactivityMonitor Async Task: " + runnable);
            thread.setDaemon(true);
            return thread;
        }
    };

    public AmqpInactivityMonitor(Transport next, WireFormat wireFormat) {
        super(next);
    }

    @Override
    public void start() throws Exception {
        this.next.start();
    }

    @Override
    public void stop() throws Exception {
        this.stopConnectChecker();
        this.next.stop();
    }

    @Override
    public void onException(IOException error) {
        if (this.failed.compareAndSet(false, true)) {
            this.stopConnectChecker();
            if (this.protocolConverter != null) {
                this.protocolConverter.onAMQPException(error);
            }
            this.transportListener.onException(error);
        }
    }

    public void setProtocolConverter(AmqpProtocolConverter protocolConverter) {
        this.protocolConverter = protocolConverter;
    }

    public AmqpProtocolConverter getProtocolConverter() {
        return this.protocolConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void startConnectChecker(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        if (connectionTimeout <= 0L || this.connectCheckerTask != null) return;
        this.connectCheckerTask = new SchedulerTimerTask(this.connectChecker);
        long connectionCheckInterval = Math.min(connectionTimeout, 1000L);
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            if (CHECKER_COUNTER == 0) {
                ASYNC_TASKS = this.createExecutor();
                ACTIVITY_CHECK_TIMER = new Timer("AMQP InactivityMonitor State Check", true);
            }
            ++CHECKER_COUNTER;
            ACTIVITY_CHECK_TIMER.schedule((TimerTask)this.connectCheckerTask, connectionCheckInterval, connectionCheckInterval);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void stopConnectChecker() {
        if (this.connectCheckerTask == null) return;
        this.connectCheckerTask.cancel();
        this.connectCheckerTask = null;
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            ACTIVITY_CHECK_TIMER.purge();
            if (--CHECKER_COUNTER != 0) return;
            ACTIVITY_CHECK_TIMER.cancel();
            ACTIVITY_CHECK_TIMER = null;
            ThreadPoolUtils.shutdown(ASYNC_TASKS);
            ASYNC_TASKS = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ThreadPoolExecutor createExecutor() {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.factory);
        exec.allowCoreThreadTimeOut(true);
        return exec;
    }
}

