/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.protocol;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.InvalidSelectorException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.transport.amqp.AmqpProtocolConverter;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.ResponseHandler;
import org.apache.activemq.transport.amqp.protocol.AmqpConnection;
import org.apache.activemq.transport.amqp.protocol.AmqpReceiver;
import org.apache.activemq.transport.amqp.protocol.AmqpResource;
import org.apache.activemq.transport.amqp.protocol.AmqpSender;
import org.apache.activemq.transport.amqp.protocol.AmqpTransactionCoordinator;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpSession
implements AmqpResource {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpSession.class);
    private final Map<ConsumerId, AmqpSender> consumers = new HashMap<ConsumerId, AmqpSender>();
    private final AmqpConnection connection;
    private final Session protonSession;
    private final SessionId sessionId;
    private long nextProducerId = 0L;
    private long nextConsumerId = 0L;

    public AmqpSession(AmqpConnection connection, SessionId sessionId, Session session) {
        this.connection = connection;
        this.sessionId = sessionId;
        this.protonSession = session;
    }

    @Override
    public void open() {
        LOG.debug("Session {} opened", (Object)this.getSessionId());
        this.getEndpoint().setContext(this);
        this.getEndpoint().setIncomingCapacity(Integer.MAX_VALUE);
        this.getEndpoint().open();
        this.connection.sendToActiveMQ(new SessionInfo(this.getSessionId()));
    }

    @Override
    public void close() {
        LOG.debug("Session {} closed", (Object)this.getSessionId());
        this.getEndpoint().setContext(null);
        this.getEndpoint().close();
        this.getEndpoint().free();
        this.connection.sendToActiveMQ(new RemoveInfo(this.getSessionId()));
    }

    public void commit() throws Exception {
        for (AmqpSender consumer : this.consumers.values()) {
            consumer.commit();
        }
    }

    public void rollback() throws Exception {
        for (AmqpSender consumer : this.consumers.values()) {
            consumer.rollback();
        }
    }

    public void flushPendingMessages() throws Exception {
        for (AmqpSender consumer : this.consumers.values()) {
            consumer.pumpOutbound();
        }
    }

    public void createCoordinator(Receiver protonReceiver) throws Exception {
        AmqpTransactionCoordinator txCoordinator = new AmqpTransactionCoordinator(this, protonReceiver);
        txCoordinator.flow(this.connection.getConfiguredReceiverCredit());
        txCoordinator.open();
    }

    public void createReceiver(Receiver protonReceiver) throws Exception {
        org.apache.qpid.proton.amqp.transport.Target remoteTarget = protonReceiver.getRemoteTarget();
        ProducerInfo producerInfo = new ProducerInfo(this.getNextProducerId());
        final AmqpReceiver receiver = new AmqpReceiver(this, protonReceiver, producerInfo);
        LOG.debug("opening new receiver {} on link: {}", (Object)producerInfo.getProducerId(), (Object)protonReceiver.getName());
        try {
            String connectionId;
            Target target = (Target)remoteTarget;
            ActiveMQDestination destination = null;
            String targetNodeName = target.getAddress();
            if (target.getDynamic()) {
                destination = this.connection.createTemporaryDestination(protonReceiver, target.getCapabilities());
                Target actualTarget = new Target();
                actualTarget.setAddress(destination.getQualifiedName());
                actualTarget.setDynamic(true);
                protonReceiver.setTarget(actualTarget);
                receiver.addCloseAction(new Runnable(){

                    @Override
                    public void run() {
                        AmqpSession.this.connection.deleteTemporaryDestination((ActiveMQTempDestination)receiver.getDestination());
                    }
                });
            } else if (targetNodeName != null && !targetNodeName.isEmpty() && (destination = AmqpSupport.createDestination(remoteTarget)).isTemporary() && (connectionId = ((ActiveMQTempDestination)destination).getConnectionId()) == null) {
                throw new AmqpProtocolException(AmqpError.PRECONDITION_FAILED.toString(), "Not a broker created temp destination");
            }
            receiver.setDestination(destination);
            this.connection.sendToActiveMQ(producerInfo, new ResponseHandler(){

                @Override
                public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        ErrorCondition error = null;
                        Throwable exception = ((ExceptionResponse)response).getException();
                        error = exception instanceof SecurityException ? new ErrorCondition(AmqpError.UNAUTHORIZED_ACCESS, exception.getMessage()) : new ErrorCondition(AmqpError.INTERNAL_ERROR, exception.getMessage());
                        receiver.close(error);
                    } else {
                        receiver.flow(AmqpSession.this.connection.getConfiguredReceiverCredit());
                        receiver.open();
                    }
                    AmqpSession.this.pumpProtonToSocket();
                }
            });
        }
        catch (AmqpProtocolException exception) {
            receiver.close(new ErrorCondition(Symbol.getSymbol(exception.getSymbolicName()), exception.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createSender(Sender protonSender) throws Exception {
        Source source = (Source)protonSender.getRemoteSource();
        ConsumerInfo consumerInfo = new ConsumerInfo(this.getNextConsumerId());
        final AmqpSender sender = new AmqpSender(this, protonSender, consumerInfo);
        LOG.debug("opening new sender {} on link: {}", (Object)consumerInfo.getConsumerId(), (Object)protonSender.getName());
        try {
            ActiveMQDestination destination;
            HashMap<Symbol, DescribedType> supportedFilters = new HashMap<Symbol, DescribedType>();
            protonSender.setContext(sender);
            boolean noLocal = false;
            String selector = null;
            if (source != null) {
                Map.Entry<Symbol, DescribedType> filter = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.JMS_SELECTOR_FILTER_IDS);
                if (filter != null) {
                    selector = filter.getValue().getDescribed().toString();
                    try {
                        SelectorParser.parse(selector);
                    }
                    catch (InvalidSelectorException e) {
                        sender.close(new ErrorCondition(AmqpError.INVALID_FIELD, e.getMessage()));
                        return;
                    }
                    supportedFilters.put(filter.getKey(), filter.getValue());
                }
                if ((filter = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.NO_LOCAL_FILTER_IDS)) != null) {
                    noLocal = true;
                    supportedFilters.put(filter.getKey(), filter.getValue());
                }
            }
            if (source == null) {
                destination = this.connection.lookupSubscription(protonSender.getName());
                if (destination == null) {
                    sender.close(new ErrorCondition(AmqpError.NOT_FOUND, "Unknown subscription link: " + protonSender.getName()));
                    return;
                }
                source = new Source();
                source.setAddress(destination.getQualifiedName());
                source.setDurable(TerminusDurability.UNSETTLED_STATE);
                source.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
                source.setDistributionMode(AmqpSupport.COPY);
            } else if (source.getDynamic()) {
                destination = this.connection.createTemporaryDestination(protonSender, source.getCapabilities());
                source = new Source();
                source.setAddress(destination.getQualifiedName());
                source.setDynamic(true);
                sender.addCloseAction(new Runnable(){

                    @Override
                    public void run() {
                        AmqpSession.this.connection.deleteTemporaryDestination((ActiveMQTempDestination)sender.getDestination());
                    }
                });
            } else {
                String connectionId;
                destination = AmqpSupport.createDestination(source);
                if (destination.isTemporary() && (connectionId = ((ActiveMQTempDestination)destination).getConnectionId()) == null) {
                    throw new AmqpProtocolException(AmqpError.INVALID_FIELD.toString(), "Not a broker created temp destination");
                }
            }
            source.setFilter(supportedFilters.isEmpty() ? null : supportedFilters);
            protonSender.setSource(source);
            int senderCredit = protonSender.getRemoteCredit();
            consumerInfo.setSelector(selector);
            consumerInfo.setNoRangeAcks(true);
            consumerInfo.setDestination(destination);
            consumerInfo.setPrefetchSize(senderCredit >= 0 ? senderCredit : 0);
            consumerInfo.setDispatchAsync(true);
            consumerInfo.setNoLocal(noLocal);
            if (source.getDistributionMode() == AmqpSupport.COPY && destination.isQueue()) {
                consumerInfo.setBrowser(true);
            }
            if ((TerminusDurability.UNSETTLED_STATE.equals((Object)source.getDurable()) || TerminusDurability.CONFIGURATION.equals((Object)source.getDurable())) && destination.isTopic()) {
                consumerInfo.setSubscriptionName(protonSender.getName());
            }
            this.connection.sendToActiveMQ(consumerInfo, new ResponseHandler(){

                @Override
                public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        ErrorCondition error = null;
                        Throwable exception = ((ExceptionResponse)response).getException();
                        error = exception instanceof SecurityException ? new ErrorCondition(AmqpError.UNAUTHORIZED_ACCESS, exception.getMessage()) : (exception instanceof InvalidSelectorException ? new ErrorCondition(AmqpError.INVALID_FIELD, exception.getMessage()) : new ErrorCondition(AmqpError.INTERNAL_ERROR, exception.getMessage()));
                        sender.close(error);
                    } else {
                        sender.open();
                    }
                    AmqpSession.this.pumpProtonToSocket();
                }
            });
            return;
        }
        catch (AmqpProtocolException e) {
            sender.close(new ErrorCondition(Symbol.getSymbol(e.getSymbolicName()), e.getMessage()));
        }
    }

    public void pumpProtonToSocket() {
        this.connection.pumpProtonToSocket();
    }

    public void registerSender(ConsumerId consumerId, AmqpSender sender) {
        this.consumers.put(consumerId, sender);
        this.connection.registerSender(consumerId, sender);
    }

    public void unregisterSender(ConsumerId consumerId) {
        this.consumers.remove(consumerId);
        this.connection.unregisterSender(consumerId);
    }

    public AmqpConnection getConnection() {
        return this.connection;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public Session getEndpoint() {
        return this.protonSession;
    }

    private ConsumerId getNextConsumerId() {
        return new ConsumerId(this.sessionId, this.nextConsumerId++);
    }

    private ProducerId getNextProducerId() {
        return new ProducerId(this.sessionId, this.nextProducerId++);
    }
}

