/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt.strategy;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.PersistenceAdapterSupport;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.apache.activemq.transport.mqtt.MQTTProtocolException;
import org.apache.activemq.transport.mqtt.MQTTProtocolSupport;
import org.apache.activemq.transport.mqtt.MQTTSubscription;
import org.apache.activemq.transport.mqtt.ResponseHandler;
import org.apache.activemq.transport.mqtt.strategy.AbstractMQTTSubscriptionStrategy;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.codec.CONNECT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTDefaultSubscriptionStrategy
extends AbstractMQTTSubscriptionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTDefaultSubscriptionStrategy.class);
    private final Set<String> restoredSubs = Collections.synchronizedSet(new HashSet());

    @Override
    public void onConnect(CONNECT connect) throws MQTTProtocolException {
        List<SubscriptionInfo> subs;
        try {
            subs = PersistenceAdapterSupport.listSubscriptions(this.brokerService.getPersistenceAdapter(), this.protocol.getClientId());
        }
        catch (IOException e) {
            throw new MQTTProtocolException("Error loading store subscriptions", true, e);
        }
        if (connect.cleanSession()) {
            this.deleteDurableSubs(subs);
        } else {
            this.restoreDurableSubs(subs);
        }
    }

    @Override
    public byte onSubscribe(String topicName, QoS requestedQoS) throws MQTTProtocolException {
        ActiveMQTopic destination = new ActiveMQTopic(MQTTProtocolSupport.convertMQTTToActiveMQ(topicName));
        ConsumerInfo consumerInfo = new ConsumerInfo(this.getNextConsumerId());
        consumerInfo.setDestination(destination);
        consumerInfo.setPrefetchSize(Short.MAX_VALUE);
        consumerInfo.setRetroactive(true);
        consumerInfo.setDispatchAsync(true);
        if (!this.protocol.isCleanSession() && this.protocol.getClientId() != null && requestedQoS.ordinal() >= QoS.AT_LEAST_ONCE.ordinal()) {
            consumerInfo.setSubscriptionName((Object)((Object)requestedQoS) + ":" + topicName);
            consumerInfo.setPrefetchSize(100);
        }
        if (this.protocol.getActiveMQSubscriptionPrefetch() > 0) {
            consumerInfo.setPrefetchSize(this.protocol.getActiveMQSubscriptionPrefetch());
        }
        return this.doSubscribe(consumerInfo, topicName, requestedQoS);
    }

    @Override
    public void onReSubscribe(MQTTSubscription mqttSubscription) throws MQTTProtocolException {
        ActiveMQDestination destination = mqttSubscription.getDestination();
        if (this.restoredSubs.remove(destination.getPhysicalName())) {
            return;
        }
        super.onReSubscribe(mqttSubscription);
    }

    @Override
    public void onUnSubscribe(String topicName) throws MQTTProtocolException {
        MQTTSubscription subscription = (MQTTSubscription)this.mqttSubscriptionByTopic.remove(topicName);
        if (subscription != null) {
            this.doUnSubscribe(subscription);
            if (subscription.getConsumerInfo().getSubscriptionName() != null) {
                this.restoredSubs.remove(MQTTProtocolSupport.convertMQTTToActiveMQ(subscription.getTopicName()));
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.protocol.getConnectionId());
                rsi.setSubscriptionName(subscription.getConsumerInfo().getSubscriptionName());
                rsi.setClientId(this.protocol.getClientId());
                this.protocol.sendToActiveMQ(rsi, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            }
        }
    }

    private void deleteDurableSubs(List<SubscriptionInfo> subs) {
        try {
            for (SubscriptionInfo sub : subs) {
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.protocol.getConnectionId());
                rsi.setSubscriptionName(sub.getSubcriptionName());
                rsi.setClientId(sub.getClientId());
                this.protocol.sendToActiveMQ(rsi, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not delete the MQTT durable subs.", e);
        }
    }

    private void restoreDurableSubs(List<SubscriptionInfo> subs) {
        try {
            for (SubscriptionInfo sub : subs) {
                String name = sub.getSubcriptionName();
                String[] split = name.split(":", 2);
                QoS qoS = QoS.valueOf(split[0]);
                this.onSubscribe(new Topic(split[1], qoS));
                this.restoredSubs.add(split[1]);
            }
        }
        catch (IOException e) {
            LOG.warn("Could not restore the MQTT durable subs.", (Throwable)e);
        }
    }
}

