/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.osgi;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.internal.FeaturesServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String FEATURES_SERVICE_CONFIG_FILE = "org.apache.karaf.features.cfg";
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private BundleContext bundleContext;
    private ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> configurationAdminServiceTracker;
    private ServiceTracker<FeaturesListener, FeaturesListener> featuresListenerTracker;
    private FeaturesServiceImpl featuresService;
    private ServiceRegistration<FeaturesService> featuresServiceRegistration;

    public void start(final BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        Properties configuration = new Properties();
        File configFile = new File(System.getProperty("karaf.etc"), FEATURES_SERVICE_CONFIG_FILE);
        if (configFile.isFile() && configFile.canRead()) {
            try {
                configuration.load(new FileReader(configFile));
            }
            catch (IOException e) {
                LOGGER.warn("Error reading configuration file " + configFile.toString(), (Throwable)e);
            }
        }
        this.featuresService = new FeaturesServiceImpl();
        this.featuresService.setUrls(Activator.getString(configuration, "featuresRepositories", ""));
        this.featuresService.setBoot(Activator.getString(configuration, "featuresBoot", ""));
        this.featuresService.setBootFeaturesAsynchronous(Activator.getBool(configuration, "bootFeaturesAsynchronous", false));
        this.featuresService.setRespectStartLvlDuringFeatureStartup(Activator.getBool(configuration, "respectStartLvlDuringFeatureStartup", false));
        this.featuresService.setResolverTimeout(Activator.getLong(configuration, "resolverTimeout", 5000L));
        this.featuresService.setBundleContext(bundleContext);
        this.featuresService.setBlackList(Activator.getString(configuration, "featuresBlackList", null));
        this.featuresListenerTracker = new ServiceTracker(bundleContext, FeaturesListener.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<FeaturesListener, FeaturesListener>(){

            public FeaturesListener addingService(ServiceReference<FeaturesListener> reference) {
                FeaturesListener service = (FeaturesListener)bundleContext.getService(reference);
                Activator.this.featuresService.registerListener(service);
                return service;
            }

            public void modifiedService(ServiceReference<FeaturesListener> reference, FeaturesListener service) {
            }

            public void removedService(ServiceReference<FeaturesListener> reference, FeaturesListener service) {
                Activator.this.featuresService.unregisterListener(service);
                bundleContext.ungetService(reference);
            }
        });
        this.configurationAdminServiceTracker = new ServiceTracker(bundleContext, ConfigurationAdmin.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ConfigurationAdmin, ConfigurationAdmin>(){

            public ConfigurationAdmin addingService(ServiceReference<ConfigurationAdmin> reference) {
                ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(reference);
                Activator.this.doStart(configurationAdmin);
                return configurationAdmin;
            }

            public void modifiedService(ServiceReference<ConfigurationAdmin> reference, ConfigurationAdmin service) {
            }

            public void removedService(ServiceReference<ConfigurationAdmin> reference, ConfigurationAdmin service) {
                Activator.this.doStop();
            }
        });
        this.featuresListenerTracker.open();
        this.configurationAdminServiceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.configurationAdminServiceTracker != null) {
            this.configurationAdminServiceTracker.close();
            this.configurationAdminServiceTracker = null;
        }
    }

    protected void doStart(ConfigurationAdmin configurationAdmin) {
        this.doStop();
        try {
            this.featuresService.setConfigAdmin(configurationAdmin);
            this.featuresListenerTracker.open();
            this.featuresService.start();
            this.featuresServiceRegistration = this.bundleContext.registerService(FeaturesService.class, (Object)this.featuresService, null);
        }
        catch (Exception e) {
            LOGGER.error("Error starting FeaturesService", (Throwable)e);
        }
    }

    protected void doStop() {
        if (this.featuresServiceRegistration != null) {
            try {
                this.featuresServiceRegistration.unregister();
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        this.featuresListenerTracker.close();
        try {
            this.featuresService.stop();
        }
        catch (Exception e) {
            LOGGER.warn("Error stopping FeaturesService", (Throwable)e);
        }
    }

    private static String getString(Properties configuration, String key, String def) {
        if (configuration.containsKey(key)) {
            return configuration.getProperty(key);
        }
        return def;
    }

    private static boolean getBool(Properties configuration, String key, boolean def) {
        if (configuration.containsKey(key)) {
            return Boolean.parseBoolean(configuration.getProperty(key));
        }
        return def;
    }

    private static long getLong(Properties configuration, String key, long def) {
        if (configuration.containsKey(key)) {
            return Long.parseLong(configuration.getProperty(key));
        }
        return def;
    }
}

