/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev.watch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.karaf.util.bundles.BundleUtils;
import org.ops4j.pax.url.maven.commons.MavenConfiguration;
import org.ops4j.pax.url.maven.commons.MavenConfigurationImpl;
import org.ops4j.pax.url.maven.commons.MavenRepositoryURL;
import org.ops4j.pax.url.mvn.internal.Parser;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.PropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWatcher
implements Runnable,
BundleListener {
    private final Logger logger = LoggerFactory.getLogger(BundleWatcher.class);
    private BundleContext bundleContext;
    private ConfigurationAdmin configurationAdmin;
    private AtomicBoolean running = new AtomicBoolean(false);
    private long interval = 1000L;
    private List<String> watchURLs = new CopyOnWriteArrayList<String>();
    private AtomicInteger counter = new AtomicInteger(0);

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 1 || event.getType() == 16) {
            this.counter.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.debug("Bundle watcher thread started");
        int oldCounter = -1;
        HashSet<Bundle> watchedBundles = new HashSet<Bundle>();
        while (this.running.get() && this.watchURLs.size() > 0) {
            if (oldCounter != this.counter.get()) {
                oldCounter = this.counter.get();
                watchedBundles.clear();
                for (String bundleURL : this.watchURLs) {
                    for (Bundle bundle : this.getBundlesByURL(bundleURL)) {
                        watchedBundles.add(bundle);
                    }
                }
            }
            if (watchedBundles.size() > 0) {
                FrameworkWiring wiring = (FrameworkWiring)this.getBundleContext().getBundle(0L).adapt(FrameworkWiring.class);
                File localRepository = this.getLocalRepository();
                ArrayList<Bundle> updated = new ArrayList<Bundle>();
                for (Bundle bundle : watchedBundles) {
                    try {
                        File location = this.getBundleExternalLocation(localRepository, bundle);
                        if (location == null || !location.exists() || location.lastModified() <= bundle.getLastModified()) continue;
                        FileInputStream is = new FileInputStream(location);
                        try {
                            this.logger.info("[Watch] Updating watched bundle: " + bundle.getSymbolicName() + " (" + bundle.getVersion() + ")");
                            System.out.println("[Watch] Updating watched bundle: " + bundle.getSymbolicName() + " (" + bundle.getVersion() + ")");
                            String updateLocation = this.getLocation(bundle);
                            if (!updateLocation.equals(bundle.getLocation())) {
                                File file = BundleUtils.fixBundleWithUpdateLocation(is, updateLocation);
                                FileInputStream fis = new FileInputStream(file);
                                try {
                                    bundle.update((InputStream)fis);
                                }
                                finally {
                                    fis.close();
                                }
                                file.delete();
                            } else {
                                bundle.update((InputStream)is);
                            }
                            updated.add(bundle);
                        }
                        finally {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException ex) {
                        this.logger.error("Error watching bundle.", (Throwable)ex);
                    }
                    catch (BundleException ex) {
                        this.logger.error("Error updating bundle.", (Throwable)ex);
                    }
                }
                try {
                    final CountDownLatch latch = new CountDownLatch(1);
                    wiring.refreshBundles(updated, new FrameworkListener[]{new FrameworkListener(){

                        public void frameworkEvent(FrameworkEvent event) {
                            latch.countDown();
                        }
                    }});
                    latch.await();
                }
                catch (InterruptedException e) {
                    this.running.set(false);
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException ex) {
                this.running.set(false);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bundle watcher thread stopped");
        }
    }

    public void add(String url) {
        boolean shouldStart;
        boolean bl = shouldStart = this.running.get() && this.watchURLs.size() == 0;
        if (!this.watchURLs.contains(url)) {
            this.watchURLs.add(url);
            this.counter.incrementAndGet();
        }
        if (shouldStart) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void remove(String url) {
        this.watchURLs.remove(url);
        this.counter.incrementAndGet();
    }

    public File getBundleExternalLocation(File localRepository, Bundle bundle) {
        try {
            Parser p = new Parser(this.getLocation(bundle).substring(4));
            return new File(localRepository.getPath() + File.separator + p.getArtifactPath());
        }
        catch (MalformedURLException e) {
            this.logger.error("Could not parse artifact path for bundle" + bundle.getSymbolicName(), (Throwable)e);
            return null;
        }
    }

    private String getLocation(Bundle bundle) {
        String location = (String)bundle.getHeaders().get("Bundle-UpdateLocation");
        return location != null ? location : bundle.getLocation();
    }

    public File getLocalRepository() {
        MavenRepositoryURL localRepositoryURL;
        MavenConfiguration configuration = this.retrieveMavenConfiguration();
        if (configuration != null && (localRepositoryURL = configuration.getLocalRepository()) != null) {
            return localRepositoryURL.getFile().getAbsoluteFile();
        }
        String localRepo = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
        return new File(localRepo).getAbsoluteFile();
    }

    protected MavenConfiguration retrieveMavenConfiguration() {
        MavenConfigurationImpl mavenConfiguration = null;
        try {
            Dictionary dictonary;
            Configuration configuration = this.configurationAdmin.getConfiguration("org.ops4j.pax.url.mvn", null);
            if (configuration != null && (dictonary = configuration.getProperties()) != null) {
                DictionaryPropertyResolver resolver = new DictionaryPropertyResolver(dictonary);
                mavenConfiguration = new MavenConfigurationImpl((PropertyResolver)resolver, "org.ops4j.pax.url.mvn");
            }
        }
        catch (IOException e) {
            this.logger.error("Error retrieving maven configuration", (Throwable)e);
        }
        return mavenConfiguration;
    }

    public List<Bundle> getBundlesByURL(String url) {
        ArrayList<Bundle> bundleList;
        block3: {
            bundleList = new ArrayList<Bundle>();
            try {
                Long id = Long.parseLong(url);
                Bundle bundle = this.bundleContext.getBundle(id.longValue());
                if (bundle == null) break block3;
                bundleList.add(bundle);
            }
            catch (NumberFormatException e) {
                for (int i = 0; i < this.bundleContext.getBundles().length; ++i) {
                    Bundle bundle = this.bundleContext.getBundles()[i];
                    if (!this.isMavenSnapshotUrl(bundle.getLocation()) || !this.wildCardMatch(bundle.getLocation(), url)) continue;
                    bundleList.add(bundle);
                }
            }
        }
        return bundleList;
    }

    protected boolean isMavenSnapshotUrl(String url) {
        return url.startsWith("mvn:") && url.contains("SNAPSHOT");
    }

    protected boolean wildCardMatch(String text, String pattern) {
        String[] cards;
        for (String card : cards = pattern.split("\\*")) {
            int idx = text.indexOf(card);
            if (idx == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
        }
        return true;
    }

    public void start() {
        this.bundleContext.addBundleListener((BundleListener)this);
        if (this.running.compareAndSet(false, true) && this.watchURLs.size() > 0) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void stop() {
        this.running.set(false);
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public List<String> getWatchURLs() {
        return this.watchURLs;
    }

    public void setWatchURLs(List<String> watchURLs) {
        this.watchURLs = watchURLs;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isRunning() {
        return this.running.get();
    }
}

