/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceSupport
implements StatefulService {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceSupport.class);
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean starting = new AtomicBoolean(false);
    protected final AtomicBoolean stopping = new AtomicBoolean(false);
    protected final AtomicBoolean stopped = new AtomicBoolean(false);
    protected final AtomicBoolean suspending = new AtomicBoolean(false);
    protected final AtomicBoolean suspended = new AtomicBoolean(false);
    protected final AtomicBoolean shuttingdown = new AtomicBoolean(false);
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);
    private String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        if (this.isStarting() || this.isStarted()) {
            LOG.trace("Service already started");
            return;
        }
        if (this.starting.compareAndSet(false, true)) {
            LOG.trace("Starting service");
            try {
                this.doStart();
                this.started.set(true);
                this.starting.set(false);
                this.stopping.set(false);
                this.stopped.set(false);
                this.suspending.set(false);
                this.suspended.set(false);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
            catch (Exception e) {
                try {
                    this.stop();
                }
                catch (Exception exception) {
                }
                finally {
                    this.stopping.set(false);
                    this.stopped.set(true);
                    this.starting.set(false);
                    this.started.set(false);
                    this.suspending.set(false);
                    this.suspended.set(false);
                    this.shutdown.set(false);
                    this.shuttingdown.set(false);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        if (this.isStopped()) {
            LOG.trace("Service already stopped");
            return;
        }
        if (this.isStopping()) {
            LOG.trace("Service already stopping");
            return;
        }
        this.stopping.set(true);
        try {
            this.doStop();
        }
        finally {
            this.stopping.set(false);
            this.stopped.set(true);
            this.starting.set(false);
            this.started.set(false);
            this.suspending.set(false);
            this.suspended.set(false);
            this.shutdown.set(false);
            this.shuttingdown.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() throws Exception {
        if (!this.suspended.get() && this.suspending.compareAndSet(false, true)) {
            try {
                this.starting.set(false);
                this.stopping.set(false);
                this.doSuspend();
            }
            finally {
                this.stopped.set(false);
                this.stopping.set(false);
                this.starting.set(false);
                this.started.set(false);
                this.suspending.set(false);
                this.suspended.set(true);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws Exception {
        if (this.suspended.get() && this.starting.compareAndSet(false, true)) {
            try {
                this.doResume();
            }
            finally {
                this.started.set(true);
                this.starting.set(false);
                this.stopping.set(false);
                this.stopped.set(false);
                this.suspending.set(false);
                this.suspended.set(false);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws Exception {
        if (this.shutdown.get()) {
            LOG.trace("Service already shut down");
            return;
        }
        this.stop();
        if (this.shuttingdown.compareAndSet(false, true)) {
            try {
                this.doShutdown();
            }
            finally {
                this.shutdown.set(true);
                this.shuttingdown.set(false);
            }
        }
    }

    @Override
    public ServiceStatus getStatus() {
        if (this.isStarting()) {
            return ServiceStatus.Starting;
        }
        if (this.isStopping()) {
            return ServiceStatus.Stopping;
        }
        if (this.isSuspending()) {
            return ServiceStatus.Suspending;
        }
        if (this.isStarted()) {
            return ServiceStatus.Started;
        }
        if (this.isStopped()) {
            return ServiceStatus.Stopped;
        }
        if (this.isSuspended()) {
            return ServiceStatus.Suspended;
        }
        return ServiceStatus.Stopped;
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isStarting() {
        return this.starting.get();
    }

    @Override
    public boolean isStopping() {
        return this.stopping.get();
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    @Override
    public boolean isSuspending() {
        return this.suspending.get();
    }

    @Override
    public boolean isSuspended() {
        return this.suspended.get();
    }

    @Override
    public boolean isRunAllowed() {
        boolean unused2;
        boolean unused1 = !this.started.get() && !this.starting.get() && !this.stopping.get() && !this.stopped.get();
        boolean bl = unused2 = !this.suspending.get() && !this.suspended.get() && !this.shutdown.get() && !this.shuttingdown.get();
        if (unused1 && unused2) {
            return false;
        }
        return !this.isStoppingOrStopped();
    }

    public boolean isStoppingOrStopped() {
        return this.stopping.get() || this.stopped.get();
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    protected void doSuspend() throws Exception {
    }

    protected void doResume() throws Exception {
    }

    protected void doShutdown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String getVersion() {
        Package aPackage;
        block11: {
            if (this.version != null) {
                return this.version;
            }
            InputStream is = null;
            try {
                Properties p = new Properties();
                is = this.getClass().getResourceAsStream("/META-INF/maven/org.apache.camel/camel-core/pom.properties");
                if (is != null) {
                    p.load(is);
                    this.version = p.getProperty("version", "");
                }
                if (is == null) break block11;
            }
            catch (Exception e) {
                if (is != null) {
                    IOHelper.close(is);
                }
                break block11;
                catch (Throwable throwable) {
                    if (is != null) {
                        IOHelper.close(is);
                    }
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)is);
        }
        if (this.version == null && (aPackage = this.getClass().getPackage()) != null) {
            this.version = aPackage.getImplementationVersion();
            if (this.version == null) {
                this.version = aPackage.getSpecificationVersion();
            }
        }
        if (this.version == null) {
            this.version = "";
        }
        return this.version;
    }
}

