/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.dosgi.tcp;

import io.fabric8.dosgi.api.AsyncCallback;
import io.fabric8.dosgi.api.SerializationStrategy;
import io.fabric8.dosgi.tcp.InvocationStrategy;
import io.fabric8.dosgi.tcp.ResponseFuture;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;

public class AsyncInvocationStrategy
implements InvocationStrategy {
    public static final AsyncInvocationStrategy INSTANCE = new AsyncInvocationStrategy();

    public static boolean isAsyncMethod(Method method) {
        Class<?>[] types = method.getParameterTypes();
        return types.length != 0 && types[types.length - 1] == AsyncCallback.class;
    }

    @Override
    public ResponseFuture request(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object[] args, DataByteArrayOutputStream target) throws Exception {
        if (!AsyncInvocationStrategy.isAsyncMethod(method)) {
            throw new IllegalArgumentException("Invalid async method declaration: last argument is not a RequestCallback");
        }
        Class<?>[] new_types = AsyncInvocationStrategy.payloadTypes(method);
        Object[] new_args = new Object[args.length - 1];
        System.arraycopy(args, 0, new_args, 0, new_args.length);
        serializationStrategy.encodeRequest(loader, new_types, new_args, target);
        return new AsyncResponseFuture(loader, method, (AsyncCallback)args[args.length - 1], serializationStrategy, Dispatch.getCurrentQueue());
    }

    private static Class<?>[] payloadTypes(Method method) {
        Class<?>[] types = method.getParameterTypes();
        Class[] new_types = new Class[types.length - 1];
        System.arraycopy(types, 0, new_types, 0, new_types.length);
        return new_types;
    }

    private static Class getResultType(Method method) {
        Type[] types = method.getGenericParameterTypes();
        ParameterizedType t = (ParameterizedType)types[types.length - 1];
        return (Class)t.getActualTypeArguments()[0];
    }

    @Override
    public void service(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object target, DataByteArrayInputStream requestStream, DataByteArrayOutputStream responseStream, Runnable onComplete) {
        final ServiceResponse helper = new ServiceResponse(loader, method, responseStream, onComplete, serializationStrategy);
        try {
            Object[] new_args = new Object[method.getParameterTypes().length];
            serializationStrategy.decodeRequest(loader, AsyncInvocationStrategy.payloadTypes(method), requestStream, new_args);
            new_args[new_args.length - 1] = new AsyncCallback<Object>(){

                @Override
                public void onSuccess(Object result) {
                    helper.send(null, result);
                }

                @Override
                public void onFailure(Throwable failure) {
                    helper.send(failure, null);
                }
            };
            method.invoke(target, new_args);
        }
        catch (Throwable t) {
            helper.send(t, null);
        }
    }

    class ServiceResponse {
        private final ClassLoader loader;
        private final Method method;
        private final DataByteArrayOutputStream responseStream;
        private final Runnable onComplete;
        private final SerializationStrategy serializationStrategy;
        private final int pos;
        final AtomicBoolean responded = new AtomicBoolean(false);

        public ServiceResponse(ClassLoader loader, Method method, DataByteArrayOutputStream responseStream, Runnable onComplete, SerializationStrategy serializationStrategy) {
            this.loader = loader;
            this.method = method;
            this.responseStream = responseStream;
            this.onComplete = onComplete;
            this.serializationStrategy = serializationStrategy;
            this.pos = responseStream.position();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(Throwable error, Object value) {
            if (this.responded.compareAndSet(false, true)) {
                Class resultType = AsyncInvocationStrategy.getResultType(this.method);
                try {
                    this.serializationStrategy.encodeResponse(this.loader, resultType, value, error, this.responseStream);
                }
                catch (Exception e) {
                    try {
                        this.responseStream.position(this.pos);
                        this.serializationStrategy.encodeResponse(this.loader, resultType, value, new RemoteException(e.toString()), this.responseStream);
                    }
                    catch (Exception unexpected) {
                        unexpected.printStackTrace();
                    }
                }
                finally {
                    this.onComplete.run();
                }
            }
        }
    }

    private class AsyncResponseFuture
    implements ResponseFuture {
        private final ClassLoader loader;
        private final Method method;
        private final AsyncCallback callback;
        private final SerializationStrategy serializationStrategy;
        private final DispatchQueue queue;

        public AsyncResponseFuture(ClassLoader loader, Method method, AsyncCallback callback, SerializationStrategy serializationStrategy, DispatchQueue queue) {
            this.loader = loader;
            this.method = method;
            this.callback = callback;
            this.serializationStrategy = serializationStrategy;
            this.queue = queue;
        }

        @Override
        public void set(final DataByteArrayInputStream source) {
            if (this.queue != null) {
                this.queue.execute(new Runnable(){

                    @Override
                    public void run() {
                        AsyncResponseFuture.this.decodeIt(source);
                    }
                });
            } else {
                this.decodeIt(source);
            }
        }

        private void decodeIt(DataByteArrayInputStream source) {
            try {
                this.serializationStrategy.decodeResponse(this.loader, AsyncInvocationStrategy.getResultType(this.method), source, this.callback);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void fail(Throwable throwable) {
            this.callback.onFailure(throwable);
        }
    }
}

