/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.fabric.http;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.fusesource.mq.fabric.http.FabricDiscoveryServlet;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="org.fusesource.mq.fabric.http", description="Fabric Discovery Servlet", immediate=true)
public final class ServletRegistrationHandler
extends AbstractComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletRegistrationHandler.class);
    @Reference(referenceInterface=HttpService.class)
    private final ValidatingReference<HttpService> httpService = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();

    @Activate
    void activate(ComponentContext context, Map<String, ?> properties) {
        try {
            FabricDiscoveryServlet discoveryServlet = new FabricDiscoveryServlet();
            discoveryServlet.setCurator((CuratorFramework)this.curator.get());
            HttpContext base = ((HttpService)this.httpService.get()).createDefaultHttpContext();
            ((HttpService)this.httpService.get()).registerServlet("/mq-discovery", (Servlet)discoveryServlet, this.createParams("mq-discovery"), base);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to register fabric maven proxy servlets, due to:" + t.getMessage());
        }
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        try {
            ((HttpService)this.httpService.get()).unregister("/mq-discovery");
        }
        catch (Exception ex) {
            LOGGER.warn("Http service returned error on servlet unregister.");
        }
    }

    private Dictionary<String, String> createParams(String name) {
        Hashtable<String, String> d = new Hashtable<String, String>();
        ((Dictionary)d).put("servlet-name", name);
        return d;
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindHttpService(HttpService service) {
        this.httpService.bind((Object)service);
    }

    void unbindHttpService(HttpService service) {
        this.httpService.unbind((Object)service);
    }
}

