/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download;

import io.fabric8.agent.download.AbstractDownloadTask;
import io.fabric8.agent.download.DownloadFuture;
import io.fabric8.agent.download.DownloadManagerHelper;
import io.fabric8.agent.download.FutureListener;
import io.fabric8.agent.download.MavenDownloadTask;
import io.fabric8.agent.download.SimpleDownloadTask;
import io.fabric8.agent.mvn.MavenConfiguration;
import io.fabric8.agent.mvn.MavenRepositoryURL;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.ExecutorService;

public class DownloadManager {
    private ExecutorService executor;
    private final MavenConfiguration configuration;
    private final MavenRepositoryURL cache;
    private final MavenRepositoryURL system;

    public DownloadManager(MavenConfiguration configuration) throws MalformedURLException {
        this(configuration, null);
    }

    public DownloadManager(MavenConfiguration configuration, ExecutorService executor) throws MalformedURLException {
        this.configuration = configuration;
        this.executor = executor;
        this.cache = new MavenRepositoryURL("file://" + System.getProperty("karaf.data") + "/maven/agent" + "@snapshots");
        this.system = new MavenRepositoryURL("file://" + System.getProperty("karaf.home") + "/system" + "@snapshots");
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void shutdown() {
    }

    public DownloadFuture download(final String url) throws MalformedURLException {
        String mvnUrl = DownloadManagerHelper.stripUrl(url);
        if (mvnUrl.startsWith("mvn:")) {
            MavenDownloadTask task = new MavenDownloadTask(mvnUrl, this.cache, this.system, this.configuration, this.executor);
            this.executor.submit(task);
            if (!mvnUrl.equals(url)) {
                final DummyDownloadTask download = new DummyDownloadTask(url, this.executor);
                task.addListener(new FutureListener<DownloadFuture>(){

                    @Override
                    public void operationComplete(DownloadFuture future) {
                        try {
                            String mvn = future.getUrl();
                            String file = future.getFile().toURI().toURL().toString();
                            String real = url.replace(mvn, file);
                            SimpleDownloadTask task = new SimpleDownloadTask(real, DownloadManager.this.executor);
                            DownloadManager.this.executor.submit(task);
                            task.addListener(new FutureListener<DownloadFuture>(){

                                @Override
                                public void operationComplete(DownloadFuture future) {
                                    try {
                                        download.setFile(future.getFile());
                                    }
                                    catch (IOException e) {
                                        download.setException(e);
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            download.setException(e);
                        }
                    }
                });
                return download;
            }
            return task;
        }
        SimpleDownloadTask download = new SimpleDownloadTask(url, this.executor);
        this.executor.submit(download);
        return download;
    }

    static class DummyDownloadTask
    extends AbstractDownloadTask {
        DummyDownloadTask(String url, ExecutorService executor) {
            super(url, executor);
        }

        @Override
        protected File download() throws Exception {
            return this.getFile();
        }
    }
}

