/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.internal.BundleInfoImpl;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Overrides {
    private static final Logger LOGGER = LoggerFactory.getLogger(Overrides.class);
    private static final String OVERRIDE_RANGE = ";range=";
    private static final Pattern SYMBOLIC_NAME_PATTERN = Pattern.compile("([^;: ]+)(.*)");

    public static List<BundleInfo> override(List<BundleInfo> infos, String overridesUrl) {
        List<String> overrides = Overrides.loadOverrides(overridesUrl);
        if (overrides.isEmpty()) {
            return infos;
        }
        try {
            HashMap<String, Manifest> manifests = new HashMap<String, Manifest>();
            for (String override : overrides) {
                Manifest manifest = Overrides.getManifest(override);
                manifests.put(override, manifest);
            }
            ArrayList<BundleInfo> newInfos = new ArrayList<BundleInfo>();
            for (BundleInfo info : infos) {
                Manifest manifest = Overrides.getManifest(info.getLocation());
                if (manifest != null) {
                    String bsn = Overrides.getBundleSymbolicName(manifest);
                    Version ver = Overrides.getBundleVersion(manifest);
                    String url = info.getLocation();
                    for (String override : overrides) {
                        VersionRange range;
                        String oBsn;
                        Manifest overMan = (Manifest)manifests.get(override);
                        if (overMan == null || !bsn.equals(oBsn = Overrides.getBundleSymbolicName(overMan))) continue;
                        String vr = Overrides.extractVersionRange(override);
                        if (vr == null) {
                            Version v2 = new Version(ver.getMajor(), ver.getMinor() + 1, 0);
                            range = new VersionRange(false, ver, v2, true);
                        } else {
                            range = VersionRange.parseVersionRange(vr);
                        }
                        Version oVer = Overrides.getBundleVersion(overMan);
                        if (!range.contains(ver) || ver.compareTo(oVer) >= 0) continue;
                        ver = oVer;
                        url = override;
                    }
                    if (!info.getLocation().equals(url)) {
                        newInfos.add(new BundleInfoImpl(url, info.getStartLevel(), info.isStart(), info.isDependency()));
                        continue;
                    }
                    newInfos.add(info);
                    continue;
                }
                newInfos.add(info);
            }
            return newInfos;
        }
        catch (Exception e) {
            LOGGER.info("Unable to process bundle overrides", (Throwable)e);
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadOverrides(String overridesUrl) {
        ArrayList<String> overrides;
        block6: {
            overrides = new ArrayList<String>();
            try {
                if (overridesUrl == null) break block6;
                InputStream is = new URL(overridesUrl).openStream();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        overrides.add(line);
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                LOGGER.debug("Unable to load overrides bundles list", (Throwable)e);
            }
        }
        return overrides;
    }

    private static Version getBundleVersion(Manifest manifest) {
        String ver = manifest.getMainAttributes().getValue("Bundle-Version");
        return VersionTable.getVersion(ver);
    }

    private static String getBundleSymbolicName(Manifest manifest) {
        String bsn = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        bsn = Overrides.stripSymbolicName(bsn);
        return bsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(String url) throws IOException {
        InputStream is = new URL(url).openStream();
        try {
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                Manifest manifest = new Manifest(zis);
                return manifest;
            }
            Manifest manifest = null;
            return manifest;
        }
        finally {
            is.close();
        }
    }

    private static String extractVersionRange(String override) {
        return override.contains(OVERRIDE_RANGE) ? override.split(OVERRIDE_RANGE)[1] : null;
    }

    private static String stripSymbolicName(String symbolicName) {
        Matcher m = SYMBOLIC_NAME_PATTERN.matcher(symbolicName);
        if (m.matches() && m.groupCount() >= 1) {
            return m.group(1);
        }
        return symbolicName;
    }
}

