/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.InvalidSelectorException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.transport.amqp.ActiveMQJMSVendor;
import org.apache.activemq.transport.amqp.AmqpHeader;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.transport.amqp.AmqpTransport;
import org.apache.activemq.transport.amqp.AmqpTransportFilter;
import org.apache.activemq.transport.amqp.IAmqpProtocolConverter;
import org.apache.activemq.transport.amqp.ResponseHandler;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.EngineFactory;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.EngineFactoryImpl;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.framing.TransportFrame;
import org.apache.qpid.proton.jms.AMQPNativeInboundTransformer;
import org.apache.qpid.proton.jms.AMQPRawInboundTransformer;
import org.apache.qpid.proton.jms.AutoOutboundTransformer;
import org.apache.qpid.proton.jms.EncodedMessage;
import org.apache.qpid.proton.jms.InboundTransformer;
import org.apache.qpid.proton.jms.JMSMappingInboundTransformer;
import org.apache.qpid.proton.jms.OutboundTransformer;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AmqpProtocolConverter
implements IAmqpProtocolConverter {
    static final Logger TRACE_FRAMES = AmqpTransportFilter.TRACE_FRAMES;
    public static final EnumSet<EndpointState> UNINITIALIZED_SET = EnumSet.of(EndpointState.UNINITIALIZED);
    public static final EnumSet<EndpointState> INITIALIZED_SET = EnumSet.complementOf(UNINITIALIZED_SET);
    public static final EnumSet<EndpointState> ACTIVE_STATE = EnumSet.of(EndpointState.ACTIVE);
    public static final EnumSet<EndpointState> CLOSED_STATE = EnumSet.of(EndpointState.CLOSED);
    public static final EnumSet<EndpointState> ALL_STATES = EnumSet.of(EndpointState.CLOSED, EndpointState.ACTIVE, EndpointState.UNINITIALIZED);
    private static final Logger LOG = LoggerFactory.getLogger(AmqpProtocolConverter.class);
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final AmqpTransport amqpTransport;
    private static final Symbol COPY = Symbol.getSymbol("copy");
    private static final Symbol JMS_SELECTOR = Symbol.valueOf("jms-selector");
    private static final Symbol NO_LOCAL = Symbol.valueOf("no-local");
    private static final Symbol DURABLE_SUBSCRIPTION_ENDED = Symbol.getSymbol("DURABLE_SUBSCRIPTION_ENDED");
    int prefetch = 100;
    EngineFactory engineFactory = new EngineFactoryImpl();
    Transport protonTransport = this.engineFactory.createTransport();
    Connection protonConnection = this.engineFactory.createConnection();
    Sasl sasl;
    boolean closing = false;
    boolean closedSocket = false;
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final ConnectionInfo connectionInfo = new ConnectionInfo();
    private long nextSessionId = 0L;
    private long nextTempDestinationId = 0L;
    InboundTransformer inboundTransformer;
    long nextTransactionId = 1L;
    HashMap<Long, Transaction> transactions = new HashMap();
    AmqpDeliveryListener coordinatorContext = new BaseProducerContext(){

        @Override
        protected void onMessage(Receiver receiver, final Delivery delivery, Buffer buffer) throws Exception {
            int decoded;
            MessageImpl msg = new MessageImpl();
            int offset = buffer.offset;
            for (int len = buffer.length; len > 0; len -= decoded) {
                decoded = msg.decode(buffer.data, offset, len);
                assert (decoded > 0) : "Make progress decoding the message";
                offset += decoded;
            }
            final Object action = ((AmqpValue)msg.getBody()).getValue();
            LOG.debug("COORDINATOR received: {}, [{}]", action, (Object)buffer);
            if (action instanceof Declare) {
                Declare declare = (Declare)action;
                if (declare.getGlobalId() != null) {
                    throw new Exception("don't know how to handle a declare /w a set GlobalId");
                }
                long txid = AmqpProtocolConverter.this.nextTransactionId++;
                TransactionInfo txinfo = new TransactionInfo(AmqpProtocolConverter.this.connectionId, new LocalTransactionId(AmqpProtocolConverter.this.connectionId, txid), 0);
                AmqpProtocolConverter.this.sendToActiveMQ(txinfo, null);
                LOG.trace("started transaction {}", (Object)txid);
                Declared declared = new Declared();
                declared.setTxnId(new Binary(AmqpProtocolConverter.this.toBytes(txid)));
                delivery.disposition(declared);
                delivery.settle();
            } else if (action instanceof Discharge) {
                byte operation;
                Discharge discharge = (Discharge)action;
                long txid = AmqpProtocolConverter.this.toLong(discharge.getTxnId());
                if (discharge.getFail().booleanValue()) {
                    LOG.trace("rollback transaction {}", (Object)txid);
                    operation = 4;
                } else {
                    LOG.trace("commit transaction {}", (Object)txid);
                    operation = 2;
                }
                AmqpSessionContext context = (AmqpSessionContext)receiver.getSession().getContext();
                for (ConsumerContext consumer : context.consumers.values()) {
                    if (operation == 4) {
                        consumer.doRollback();
                        continue;
                    }
                    consumer.doCommit();
                }
                TransactionInfo txinfo = new TransactionInfo(AmqpProtocolConverter.this.connectionId, new LocalTransactionId(AmqpProtocolConverter.this.connectionId, txid), operation);
                AmqpProtocolConverter.this.sendToActiveMQ(txinfo, new ResponseHandler(){

                    @Override
                    public void onResponse(IAmqpProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            ExceptionResponse er = (ExceptionResponse)response;
                            Rejected rejected = new Rejected();
                            rejected.setError(AmqpProtocolConverter.this.createErrorCondition("failed", er.getException().getMessage()));
                            delivery.disposition(rejected);
                        }
                        LOG.debug("TX: {} settling {}", (Object)operation, action);
                        delivery.settle();
                        AmqpProtocolConverter.this.pumpProtonToSocket();
                    }
                });
                for (ConsumerContext consumer : context.consumers.values()) {
                    if (operation != 4) continue;
                    consumer.pumpOutbound();
                }
            } else {
                throw new Exception("Expected coordinator message type: " + action.getClass());
            }
        }
    };
    OutboundTransformer outboundTransformer = new AutoOutboundTransformer(ActiveMQJMSVendor.INSTANCE);
    private final ConcurrentHashMap<ConsumerId, ConsumerContext> subscriptionsByConsumerId = new ConcurrentHashMap();
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final ConcurrentHashMap<Integer, ResponseHandler> resposeHandlers = new ConcurrentHashMap();

    public AmqpProtocolConverter(AmqpTransport transport) {
        this.amqpTransport = transport;
        this.protonTransport.bind(this.protonConnection);
        this.updateTracer();
    }

    @Override
    public void updateTracer() {
        if (this.amqpTransport.isTrace()) {
            ((TransportImpl)this.protonTransport).setProtocolTracer(new ProtocolTracer(){

                @Override
                public void receivedFrame(TransportFrame transportFrame) {
                    TRACE_FRAMES.trace("{} | RECV: {}", (Object)AmqpProtocolConverter.this.amqpTransport.getRemoteAddress(), (Object)transportFrame.getBody());
                }

                @Override
                public void sentFrame(TransportFrame transportFrame) {
                    TRACE_FRAMES.trace("{} | SENT: {}", (Object)AmqpProtocolConverter.this.amqpTransport.getRemoteAddress(), (Object)transportFrame.getBody());
                }
            });
        }
    }

    void pumpProtonToSocket() {
        try {
            int size2 = 65536;
            byte[] data = new byte[size2];
            boolean done = false;
            while (!done) {
                int count = this.protonTransport.output(data, 0, size2);
                if (count > 0) {
                    Buffer buffer = new Buffer(data, 0, count);
                    this.amqpTransport.sendToAmqp(buffer);
                    continue;
                }
                done = true;
            }
        }
        catch (IOException e) {
            this.amqpTransport.onException(e);
        }
    }

    @Override
    public void onAMQPData(Object command) throws Exception {
        Buffer frame;
        if (command.getClass() == AmqpHeader.class) {
            AmqpHeader header = (AmqpHeader)command;
            switch (header.getProtocolId()) {
                case 0: {
                    break;
                }
                case 3: {
                    this.sasl = this.protonTransport.sasl();
                    this.sasl.setMechanisms("ANONYMOUS", "PLAIN");
                    this.sasl.server();
                    break;
                }
            }
            frame = header.getBuffer();
        } else {
            frame = (Buffer)command;
        }
        this.onFrame(frame);
    }

    public void onFrame(Buffer frame) throws Exception {
        while (frame.length > 0) {
            try {
                int count = this.protonTransport.input(frame.data, frame.offset, frame.length);
                frame.moveHead(count);
            }
            catch (Throwable e) {
                this.handleException(new AmqpProtocolException("Could not decode AMQP frame: " + frame, true, e));
                return;
            }
            try {
                if (this.sasl != null && this.sasl.getRemoteMechanisms().length > 0) {
                    if ("PLAIN".equals(this.sasl.getRemoteMechanisms()[0])) {
                        byte[] data = new byte[this.sasl.pending()];
                        this.sasl.recv(data, 0, data.length);
                        Buffer[] parts = new Buffer(data).split((byte)0);
                        if (parts.length > 0) {
                            this.connectionInfo.setUserName(parts[0].utf8().toString());
                        }
                        if (parts.length > 1) {
                            this.connectionInfo.setPassword(parts[1].utf8().toString());
                        }
                        this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                        this.amqpTransport.getWireFormat().magicRead = false;
                        this.sasl = null;
                    } else if ("ANONYMOUS".equals(this.sasl.getRemoteMechanisms()[0])) {
                        this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                        this.amqpTransport.getWireFormat().magicRead = false;
                        this.sasl = null;
                    }
                }
                if (this.protonConnection.getLocalState() == EndpointState.UNINITIALIZED && this.protonConnection.getRemoteState() != EndpointState.UNINITIALIZED) {
                    this.onConnectionOpen();
                }
                Session session = this.protonConnection.sessionHead(UNINITIALIZED_SET, INITIALIZED_SET);
                while (session != null) {
                    this.onSessionOpen(session);
                    session = this.protonConnection.sessionHead(UNINITIALIZED_SET, INITIALIZED_SET);
                }
                Link link2 = this.protonConnection.linkHead(UNINITIALIZED_SET, INITIALIZED_SET);
                while (link2 != null) {
                    this.onLinkOpen(link2);
                    link2 = this.protonConnection.linkHead(UNINITIALIZED_SET, INITIALIZED_SET);
                }
                for (Delivery delivery = this.protonConnection.getWorkHead(); delivery != null; delivery = delivery.getWorkNext()) {
                    AmqpDeliveryListener listener = (AmqpDeliveryListener)delivery.getLink().getContext();
                    if (listener == null) continue;
                    listener.onDelivery(delivery);
                }
                for (link2 = this.protonConnection.linkHead(ACTIVE_STATE, CLOSED_STATE); link2 != null; link2 = link2.next(ACTIVE_STATE, CLOSED_STATE)) {
                    ((AmqpDeliveryListener)link2.getContext()).onClose();
                    link2.close();
                }
                for (link2 = this.protonConnection.linkHead(ACTIVE_STATE, ALL_STATES); link2 != null; link2 = link2.next(ACTIVE_STATE, ALL_STATES)) {
                    ((AmqpDeliveryListener)link2.getContext()).drainCheck();
                }
                for (session = this.protonConnection.sessionHead(ACTIVE_STATE, CLOSED_STATE); session != null; session = session.next(ACTIVE_STATE, CLOSED_STATE)) {
                    this.onSessionClose(session);
                }
                if (this.protonConnection.getLocalState() == EndpointState.ACTIVE && this.protonConnection.getRemoteState() == EndpointState.CLOSED) {
                    this.doClose();
                }
            }
            catch (Throwable e) {
                this.handleException(new AmqpProtocolException("Could not process AMQP commands", true, e));
            }
            this.pumpProtonToSocket();
        }
    }

    private void doClose() {
        if (!this.closing) {
            this.closing = true;
            this.sendToActiveMQ(new RemoveInfo(this.connectionId), new ResponseHandler(){

                @Override
                public void onResponse(IAmqpProtocolConverter converter, Response response) throws IOException {
                    AmqpProtocolConverter.this.protonConnection.close();
                    if (!AmqpProtocolConverter.this.closedSocket) {
                        AmqpProtocolConverter.this.pumpProtonToSocket();
                    }
                }
            });
            this.sendToActiveMQ(new ShutdownInfo(), null);
        }
    }

    @Override
    public void onAMQPException(IOException error) {
        this.closedSocket = true;
        if (!this.closing) {
            this.amqpTransport.sendToActiveMQ(error);
        } else {
            try {
                this.amqpTransport.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onActiveMQCommand(Command command) throws Exception {
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = this.resposeHandlers.remove(response.getCorrelationId());
            if (rh != null) {
                rh.onResponse(this, response);
            } else if (response.isException()) {
                Throwable exception = ((ExceptionResponse)response).getException();
                this.handleException(exception);
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            ConsumerContext consumerContext = this.subscriptionsByConsumerId.get(md.getConsumerId());
            if (consumerContext != null) {
                if (md.getMessage() != null) {
                    LOG.trace("Dispatching MessageId: {} to consumer", (Object)md.getMessage().getMessageId());
                } else {
                    LOG.trace("Dispatching End of Browse Command to consumer {}", (Object)md.getConsumerId());
                }
                consumerContext.onMessageDispatch(md);
            }
        } else if (command.getDataStructureType() == 16) {
            Throwable exception = ((ConnectionError)command).getException();
            this.handleException(exception);
        } else if (!command.isBrokerInfo()) {
            LOG.debug("Do not know how to process ActiveMQ Command {}", (Object)command);
        }
    }

    private void onConnectionOpen() throws AmqpProtocolException {
        this.connectionInfo.setResponseRequired(true);
        this.connectionInfo.setConnectionId(this.connectionId);
        String clientId = this.protonConnection.getRemoteContainer();
        if (clientId != null && !clientId.isEmpty()) {
            this.connectionInfo.setClientId(clientId);
        }
        this.connectionInfo.setTransportContext(this.amqpTransport.getPeerCertificates());
        this.sendToActiveMQ(this.connectionInfo, new ResponseHandler(){

            @Override
            public void onResponse(IAmqpProtocolConverter converter, Response response) throws IOException {
                AmqpProtocolConverter.this.protonConnection.open();
                AmqpProtocolConverter.this.pumpProtonToSocket();
                if (response.isException()) {
                    Throwable exception = ((ExceptionResponse)response).getException();
                    AmqpProtocolConverter.this.protonConnection.setCondition(new ErrorCondition(AmqpError.UNAUTHORIZED_ACCESS, exception.getMessage()));
                    AmqpProtocolConverter.this.protonConnection.close();
                    AmqpProtocolConverter.this.pumpProtonToSocket();
                    AmqpProtocolConverter.this.amqpTransport.onException(IOExceptionSupport.create(exception));
                    return;
                }
            }
        });
    }

    private void onSessionOpen(Session session) {
        AmqpSessionContext sessionContext = new AmqpSessionContext(this.connectionId, this.nextSessionId++);
        session.setContext(sessionContext);
        this.sendToActiveMQ(new SessionInfo(sessionContext.sessionId), null);
        session.open();
    }

    private void onSessionClose(Session session) {
        AmqpSessionContext sessionContext = (AmqpSessionContext)session.getContext();
        if (sessionContext != null) {
            LOG.trace("Session {} closed", (Object)sessionContext.sessionId);
            this.sendToActiveMQ(new RemoveInfo(sessionContext.sessionId), null);
            session.setContext(null);
        }
        session.close();
    }

    private void onLinkOpen(Link link2) {
        link2.setSource(link2.getRemoteSource());
        link2.setTarget(link2.getRemoteTarget());
        AmqpSessionContext sessionContext = (AmqpSessionContext)link2.getSession().getContext();
        if (link2 instanceof Receiver) {
            this.onReceiverOpen((Receiver)link2, sessionContext);
        } else {
            this.onSenderOpen((Sender)link2, sessionContext);
        }
    }

    protected InboundTransformer getInboundTransformer() {
        if (this.inboundTransformer == null) {
            String transformer = this.amqpTransport.getTransformer();
            if (transformer.equals("jms")) {
                this.inboundTransformer = new JMSMappingInboundTransformer(ActiveMQJMSVendor.INSTANCE);
            } else if (transformer.equals("native")) {
                this.inboundTransformer = new AMQPNativeInboundTransformer(ActiveMQJMSVendor.INSTANCE);
            } else if (transformer.equals("raw")) {
                this.inboundTransformer = new AMQPRawInboundTransformer(ActiveMQJMSVendor.INSTANCE);
            } else {
                LOG.warn("Unknown transformer type {} using native one instead", (Object)transformer);
                this.inboundTransformer = new AMQPNativeInboundTransformer(ActiveMQJMSVendor.INSTANCE);
            }
        }
        return this.inboundTransformer;
    }

    public byte[] toBytes(long value) {
        Buffer buffer = new Buffer(8);
        buffer.bigEndianEditor().writeLong(value);
        return buffer.data;
    }

    private long toLong(Binary value) {
        Buffer buffer = new Buffer(value.getArray(), value.getArrayOffset(), value.getLength());
        return buffer.bigEndianEditor().readLong();
    }

    void onReceiverOpen(final Receiver receiver, AmqpSessionContext sessionContext) {
        org.apache.qpid.proton.amqp.transport.Target remoteTarget = receiver.getRemoteTarget();
        try {
            if (remoteTarget instanceof Coordinator) {
                this.pumpProtonToSocket();
                receiver.setContext(this.coordinatorContext);
                receiver.flow(this.prefetch);
                receiver.open();
                this.pumpProtonToSocket();
            } else {
                ActiveMQDestination dest;
                Target target = (Target)remoteTarget;
                ProducerId producerId = new ProducerId(sessionContext.sessionId, sessionContext.nextProducerId++);
                if (target.getDynamic()) {
                    dest = this.createTempQueue();
                    Target actualTarget = new Target();
                    actualTarget.setAddress(dest.getQualifiedName());
                    actualTarget.setDynamic(true);
                    receiver.setTarget(actualTarget);
                } else {
                    dest = this.createDestination(remoteTarget);
                }
                ProducerContext producerContext = new ProducerContext(producerId, dest);
                receiver.setContext(producerContext);
                receiver.flow(this.prefetch);
                ProducerInfo producerInfo = new ProducerInfo(producerId);
                producerInfo.setDestination(dest);
                this.sendToActiveMQ(producerInfo, new ResponseHandler(){

                    @Override
                    public void onResponse(IAmqpProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            receiver.setTarget(null);
                            Throwable exception = ((ExceptionResponse)response).getException();
                            receiver.setCondition(new ErrorCondition(AmqpError.INTERNAL_ERROR, exception.getMessage()));
                            receiver.close();
                        } else {
                            receiver.open();
                        }
                        AmqpProtocolConverter.this.pumpProtonToSocket();
                    }
                });
            }
        }
        catch (AmqpProtocolException exception) {
            receiver.setTarget(null);
            receiver.setCondition(new ErrorCondition(Symbol.getSymbol(exception.getSymbolicName()), exception.getMessage()));
            receiver.close();
        }
    }

    private ActiveMQDestination createDestination(Object terminus) throws AmqpProtocolException {
        if (terminus == null) {
            return null;
        }
        if (terminus instanceof Source) {
            Source source = (Source)terminus;
            if (source.getAddress() == null || source.getAddress().length() == 0) {
                throw new AmqpProtocolException("amqp:invalid-field", "source address not set");
            }
            return ActiveMQDestination.createDestination(source.getAddress(), (byte)1);
        }
        if (terminus instanceof Target) {
            Target target = (Target)terminus;
            if (target.getAddress() == null || target.getAddress().length() == 0) {
                throw new AmqpProtocolException("amqp:invalid-field", "target address not set");
            }
            return ActiveMQDestination.createDestination(target.getAddress(), (byte)1);
        }
        if (terminus instanceof Coordinator) {
            return null;
        }
        throw new RuntimeException("Unexpected terminus type: " + terminus);
    }

    void onSenderOpen(final Sender sender, final AmqpSessionContext sessionContext) {
        Source source = (Source)sender.getRemoteSource();
        try {
            DescribedType value;
            Map filter;
            ConsumerInfo consumerInfo;
            ActiveMQDestination dest;
            DescribedType value2;
            Map filter2;
            final ConsumerId id = new ConsumerId(sessionContext.sessionId, sessionContext.nextConsumerId++);
            final ConsumerContext consumerContext = new ConsumerContext(id, sender);
            sender.setContext(consumerContext);
            String selector = null;
            if (source != null && (filter2 = source.getFilter()) != null && (value2 = (DescribedType)filter2.get(JMS_SELECTOR)) != null) {
                selector = value2.getDescribed().toString();
                try {
                    SelectorParser.parse(selector);
                }
                catch (InvalidSelectorException e) {
                    sender.setSource(null);
                    sender.setCondition(new ErrorCondition(AmqpError.INVALID_FIELD, e.getMessage()));
                    sender.close();
                    consumerContext.closed = true;
                    return;
                }
            }
            if (source == null) {
                source = new Source();
                source.setAddress("");
                source.setCapabilities(DURABLE_SUBSCRIPTION_ENDED);
                sender.setSource(source);
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.connectionId);
                rsi.setSubscriptionName(sender.getName());
                rsi.setClientId(this.connectionInfo.getClientId());
                consumerContext.closed = true;
                this.sendToActiveMQ(rsi, new ResponseHandler(){

                    @Override
                    public void onResponse(IAmqpProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            sender.setSource(null);
                            Throwable exception = ((ExceptionResponse)response).getException();
                            String name = exception.getClass().getName();
                            sender.setCondition(new ErrorCondition(AmqpError.INTERNAL_ERROR, exception.getMessage()));
                        }
                        sender.open();
                        AmqpProtocolConverter.this.pumpProtonToSocket();
                    }
                });
                return;
            }
            if (AmqpProtocolConverter.contains(source.getCapabilities(), DURABLE_SUBSCRIPTION_ENDED)) {
                consumerContext.closed = true;
                sender.close();
                this.pumpProtonToSocket();
                return;
            }
            if (source.getDynamic()) {
                dest = this.createTempQueue();
                source = new Source();
                source.setAddress(dest.getQualifiedName());
                source.setDynamic(true);
                sender.setSource(source);
            } else {
                dest = this.createDestination(source);
            }
            this.subscriptionsByConsumerId.put(id, consumerContext);
            consumerContext.info = consumerInfo = new ConsumerInfo(id);
            consumerInfo.setSelector(selector);
            consumerInfo.setNoRangeAcks(true);
            consumerInfo.setDestination(dest);
            consumerInfo.setPrefetchSize(100);
            consumerInfo.setDispatchAsync(true);
            if (source.getDistributionMode() == COPY && dest.isQueue()) {
                consumerInfo.setBrowser(true);
            }
            if (TerminusDurability.UNSETTLED_STATE.equals((Object)source.getDurable()) && dest.isTopic()) {
                consumerInfo.setSubscriptionName(sender.getName());
            }
            if ((filter = source.getFilter()) != null && (value = (DescribedType)filter.get(NO_LOCAL)) != null) {
                consumerInfo.setNoLocal(true);
            }
            this.sendToActiveMQ(consumerInfo, new ResponseHandler(){

                @Override
                public void onResponse(IAmqpProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        sender.setSource(null);
                        Throwable exception = ((ExceptionResponse)response).getException();
                        Symbol condition = AmqpError.INTERNAL_ERROR;
                        if (exception instanceof InvalidSelectorException) {
                            condition = AmqpError.INVALID_FIELD;
                        }
                        sender.setCondition(new ErrorCondition(condition, exception.getMessage()));
                        AmqpProtocolConverter.this.subscriptionsByConsumerId.remove(id);
                        sender.close();
                    } else {
                        sessionContext.consumers.put(id, consumerContext);
                        sender.open();
                    }
                    AmqpProtocolConverter.this.pumpProtonToSocket();
                }
            });
        }
        catch (AmqpProtocolException e) {
            sender.setSource(null);
            sender.setCondition(new ErrorCondition(Symbol.getSymbol(e.getSymbolicName()), e.getMessage()));
            sender.close();
        }
    }

    private static boolean contains(Symbol[] haystack, Symbol needle) {
        if (haystack != null) {
            for (Symbol capability : haystack) {
                if (capability != needle) continue;
                return true;
            }
        }
        return false;
    }

    private ActiveMQDestination createTempQueue() {
        ActiveMQTempQueue rc = new ActiveMQTempQueue(this.connectionId, this.nextTempDestinationId++);
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.connectionId);
        info.setOperationType((byte)0);
        info.setDestination(rc);
        this.sendToActiveMQ(info, null);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    void sendToActiveMQ(Command command, ResponseHandler handler) {
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put(command.getCommandId(), handler);
        }
        this.amqpTransport.sendToActiveMQ(command);
    }

    void handleException(Throwable exception) {
        exception.printStackTrace();
        LOG.debug("Exception detail", exception);
        try {
            this.amqpTransport.stop();
        }
        catch (Throwable e) {
            LOG.error("Failed to stop AMQP Transport ", e);
        }
    }

    ErrorCondition createErrorCondition(String name) {
        return this.createErrorCondition(name, "");
    }

    ErrorCondition createErrorCondition(String name, String description) {
        ErrorCondition condition = new ErrorCondition();
        condition.setCondition(Symbol.valueOf(name));
        condition.setDescription(description);
        return condition;
    }

    class ConsumerContext
    extends AmqpDeliveryListener {
        private final ConsumerId consumerId;
        private final Sender sender;
        private final boolean presettle;
        private boolean closed;
        public ConsumerInfo info;
        private boolean endOfBrowse = false;
        protected LinkedList<MessageDispatch> dispatchedInTx = new LinkedList();
        long nextTagId = 0L;
        HashSet<byte[]> tagCache = new HashSet();
        LinkedList<MessageDispatch> outbound = new LinkedList();
        Buffer currentBuffer;
        Delivery currentDelivery;
        final String MESSAGE_FORMAT_KEY;

        public ConsumerContext(ConsumerId consumerId, Sender sender) {
            this.MESSAGE_FORMAT_KEY = AmqpProtocolConverter.this.outboundTransformer.getPrefixVendor() + "MESSAGE_FORMAT";
            this.consumerId = consumerId;
            this.sender = sender;
            this.presettle = sender.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED;
        }

        byte[] nextTag() {
            byte[] rc;
            if (this.tagCache != null && !this.tagCache.isEmpty()) {
                Iterator<byte[]> iterator = this.tagCache.iterator();
                rc = iterator.next();
                iterator.remove();
            } else {
                try {
                    rc = Long.toHexString(this.nextTagId++).getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return rc;
        }

        void checkinTag(byte[] data) {
            if (this.tagCache.size() < 1024) {
                this.tagCache.add(data);
            }
        }

        @Override
        public void onClose() throws Exception {
            if (!this.closed) {
                this.closed = true;
                AmqpSessionContext session = (AmqpSessionContext)this.sender.getSession().getContext();
                if (session != null) {
                    session.consumers.remove(this.info.getConsumerId());
                }
                AmqpProtocolConverter.this.sendToActiveMQ(new RemoveInfo(this.consumerId), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessageDispatch(MessageDispatch md) throws Exception {
            if (!this.closed) {
                LinkedList<MessageDispatch> linkedList = this.outbound;
                synchronized (linkedList) {
                    this.outbound.addLast(md);
                }
                this.pumpOutbound();
                AmqpProtocolConverter.this.pumpProtonToSocket();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pumpOutbound() throws Exception {
            while (!this.closed) {
                while (this.currentBuffer != null) {
                    int sent = this.sender.send(this.currentBuffer.data, this.currentBuffer.offset, this.currentBuffer.length);
                    if (sent > 0) {
                        this.currentBuffer.moveHead(sent);
                        if (this.currentBuffer.length != 0) continue;
                        if (this.presettle) {
                            this.settle(this.currentDelivery, 4);
                        } else {
                            this.sender.advance();
                        }
                        this.currentBuffer = null;
                        this.currentDelivery = null;
                        continue;
                    }
                    return;
                }
                if (this.outbound.isEmpty()) {
                    return;
                }
                MessageDispatch md = this.outbound.removeFirst();
                try {
                    ActiveMQMessage jms;
                    ActiveMQMessage temp = null;
                    if (md.getMessage() != null) {
                        if (md.getDestination().isTopic()) {
                            Message message = md.getMessage();
                            synchronized (message) {
                                temp = (ActiveMQMessage)md.getMessage().copy();
                            }
                        } else {
                            temp = (ActiveMQMessage)md.getMessage();
                        }
                        if (!temp.getProperties().containsKey(this.MESSAGE_FORMAT_KEY)) {
                            temp.setProperty(this.MESSAGE_FORMAT_KEY, 0);
                        }
                    }
                    if ((jms = temp) == null) {
                        this.endOfBrowse = true;
                        this.drainCheck();
                        continue;
                    }
                    jms.setRedeliveryCounter(md.getRedeliveryCounter());
                    jms.setReadOnlyBody(true);
                    EncodedMessage amqp = AmqpProtocolConverter.this.outboundTransformer.transform(jms);
                    if (amqp == null || amqp.getLength() <= 0) continue;
                    this.currentBuffer = new Buffer(amqp.getArray(), amqp.getArrayOffset(), amqp.getLength());
                    if (this.presettle) {
                        this.currentDelivery = this.sender.delivery(EMPTY_BYTE_ARRAY, 0, 0);
                    } else {
                        byte[] tag = this.nextTag();
                        this.currentDelivery = this.sender.delivery(tag, 0, tag.length);
                    }
                    this.currentDelivery.setContext(md);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void settle(final Delivery delivery, int ackType) throws Exception {
            byte[] tag = delivery.getTag();
            if (tag != null && tag.length > 0 && delivery.remotelySettled()) {
                this.checkinTag(tag);
            }
            if (ackType == -1) {
                delivery.settle();
                this.onMessageDispatch((MessageDispatch)delivery.getContext());
            } else {
                MessageDispatch md = (MessageDispatch)delivery.getContext();
                MessageAck ack = new MessageAck();
                ack.setConsumerId(this.consumerId);
                ack.setFirstMessageId(md.getMessage().getMessageId());
                ack.setLastMessageId(md.getMessage().getMessageId());
                ack.setMessageCount(1);
                ack.setAckType((byte)ackType);
                ack.setDestination(md.getDestination());
                DeliveryState remoteState = delivery.getRemoteState();
                if (remoteState != null && remoteState instanceof TransactionalState) {
                    TransactionalState s = (TransactionalState)remoteState;
                    long txid = AmqpProtocolConverter.this.toLong(s.getTxnId());
                    LocalTransactionId localTxId = new LocalTransactionId(AmqpProtocolConverter.this.connectionId, txid);
                    ack.setTransactionId(localTxId);
                    md.getMessage().setTransactionId(localTxId);
                    this.dispatchedInTx.addFirst(md);
                }
                LOG.trace("Sending Ack to ActiveMQ: {}", (Object)ack);
                AmqpProtocolConverter.this.sendToActiveMQ(ack, new ResponseHandler(){

                    @Override
                    public void onResponse(IAmqpProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            if (response.isException()) {
                                Throwable exception = ((ExceptionResponse)response).getException();
                                exception.printStackTrace();
                                ConsumerContext.this.sender.close();
                            }
                        } else {
                            delivery.settle();
                        }
                        AmqpProtocolConverter.this.pumpProtonToSocket();
                    }
                });
            }
        }

        @Override
        public void drainCheck() {
            if (this.info.isBrowser() && !this.endOfBrowse) {
                return;
            }
            if (this.outbound.isEmpty()) {
                this.sender.drained();
            }
        }

        @Override
        public void onDelivery(Delivery delivery) throws Exception {
            MessageDispatch md = (MessageDispatch)delivery.getContext();
            DeliveryState state = delivery.getRemoteState();
            if (state instanceof TransactionalState) {
                TransactionalState txState = (TransactionalState)state;
                if (txState.getOutcome() instanceof DeliveryState) {
                    LOG.trace("onDelivery: TX delivery state = {}", (Object)state);
                    state = (DeliveryState)((Object)txState.getOutcome());
                    if (state instanceof Accepted) {
                        if (!delivery.remotelySettled()) {
                            delivery.disposition(new Accepted());
                        }
                        this.settle(delivery, 0);
                    }
                }
            } else if (state instanceof Accepted) {
                LOG.trace("onDelivery: accepted state = {}", (Object)state);
                if (!delivery.remotelySettled()) {
                    delivery.disposition(new Accepted());
                }
                this.settle(delivery, 4);
            } else if (state instanceof Rejected) {
                md.setRedeliveryCounter(md.getRedeliveryCounter() + 1);
                LOG.trace("onDelivery: Rejected state = {}, delivery count now {}", (Object)state, (Object)md.getRedeliveryCounter());
                this.settle(delivery, -1);
            } else if (state instanceof Released) {
                LOG.trace("onDelivery: Released state = {}", (Object)state);
                this.settle(delivery, -1);
            } else if (state instanceof Modified) {
                Modified modified = (Modified)state;
                if (modified.getDeliveryFailed().booleanValue()) {
                    md.setRedeliveryCounter(md.getRedeliveryCounter() + 1);
                }
                LOG.trace("onDelivery: Modified state = {}, delivery count now {}", (Object)state, (Object)md.getRedeliveryCounter());
                int ackType = -1;
                Boolean undeliverableHere = modified.getUndeliverableHere();
                if (undeliverableHere != null && undeliverableHere.booleanValue()) {
                    ackType = 1;
                }
                this.settle(delivery, ackType);
            }
            this.pumpOutbound();
        }

        @Override
        void doCommit() throws Exception {
            if (!this.dispatchedInTx.isEmpty()) {
                MessageDispatch md = this.dispatchedInTx.getFirst();
                MessageAck pendingTxAck = new MessageAck(md, 2, this.dispatchedInTx.size());
                pendingTxAck.setTransactionId(md.getMessage().getTransactionId());
                pendingTxAck.setFirstMessageId(this.dispatchedInTx.getLast().getMessage().getMessageId());
                LOG.trace("Sending commit Ack to ActiveMQ: {}", (Object)pendingTxAck);
                this.dispatchedInTx.clear();
                AmqpProtocolConverter.this.sendToActiveMQ(pendingTxAck, new ResponseHandler(){

                    @Override
                    public void onResponse(IAmqpProtocolConverter converter, Response response) throws IOException {
                        if (response.isException() && response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            exception.printStackTrace();
                            ConsumerContext.this.sender.close();
                        }
                        AmqpProtocolConverter.this.pumpProtonToSocket();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void doRollback() throws Exception {
            LinkedList<MessageDispatch> linkedList = this.outbound;
            synchronized (linkedList) {
                LOG.trace("Rolling back {} messages for redelivery. ", (Object)this.dispatchedInTx.size());
                for (MessageDispatch md : this.dispatchedInTx) {
                    md.setRedeliveryCounter(md.getRedeliveryCounter() + 1);
                    md.getMessage().setTransactionId(null);
                    this.outbound.addFirst(md);
                }
                this.dispatchedInTx.clear();
            }
        }
    }

    class Transaction {
        Transaction() {
        }
    }

    class ProducerContext
    extends BaseProducerContext {
        private final ProducerId producerId;
        private final LongSequenceGenerator messageIdGenerator;
        private final ActiveMQDestination destination;

        public ProducerContext(ProducerId producerId, ActiveMQDestination destination) {
            this.messageIdGenerator = new LongSequenceGenerator();
            this.producerId = producerId;
            this.destination = destination;
        }

        @Override
        protected void onMessage(final Receiver receiver, final Delivery delivery, Buffer buffer) throws Exception {
            EncodedMessage em = new EncodedMessage(delivery.getMessageFormat(), buffer.data, buffer.offset, buffer.length);
            ActiveMQMessage message = (ActiveMQMessage)AmqpProtocolConverter.this.getInboundTransformer().transform(em);
            this.current = null;
            if (this.destination != null) {
                message.setJMSDestination(this.destination);
            }
            message.setProducerId(this.producerId);
            MessageId messageId = message.getMessageId();
            if (messageId == null) {
                messageId = new MessageId();
                message.setMessageId(messageId);
            }
            messageId.setProducerId(this.producerId);
            messageId.setProducerSequenceId(this.messageIdGenerator.getNextSequenceId());
            LOG.trace("Inbound Message:{} from Producer:{}", (Object)message.getMessageId(), (Object)(this.producerId + ":" + messageId.getProducerSequenceId()));
            DeliveryState remoteState = delivery.getRemoteState();
            if (remoteState != null && remoteState instanceof TransactionalState) {
                TransactionalState s = (TransactionalState)remoteState;
                long txid = AmqpProtocolConverter.this.toLong(s.getTxnId());
                message.setTransactionId(new LocalTransactionId(AmqpProtocolConverter.this.connectionId, txid));
            }
            message.onSend();
            AmqpProtocolConverter.this.sendToActiveMQ(message, new ResponseHandler(){

                @Override
                public void onResponse(IAmqpProtocolConverter converter, Response response) throws IOException {
                    if (!delivery.remotelySettled() && response.isException()) {
                        ExceptionResponse er = (ExceptionResponse)response;
                        Rejected rejected = new Rejected();
                        ErrorCondition condition = new ErrorCondition();
                        condition.setCondition(Symbol.valueOf("failed"));
                        condition.setDescription(er.getException().getMessage());
                        rejected.setError(condition);
                        delivery.disposition(rejected);
                    }
                    receiver.flow(1);
                    delivery.settle();
                    AmqpProtocolConverter.this.pumpProtonToSocket();
                }
            });
        }
    }

    abstract class BaseProducerContext
    extends AmqpDeliveryListener {
        ByteArrayOutputStream current = new ByteArrayOutputStream();

        BaseProducerContext() {
        }

        @Override
        public void onDelivery(Delivery delivery) throws Exception {
            int count;
            Receiver receiver = (Receiver)delivery.getLink();
            if (!delivery.isReadable()) {
                LOG.debug("Delivery was not readable!");
                return;
            }
            if (this.current == null) {
                this.current = new ByteArrayOutputStream();
            }
            byte[] data = new byte[4096];
            while ((count = receiver.recv(data, 0, data.length)) > 0) {
                this.current.write(data, 0, count);
            }
            if (count == 0) {
                return;
            }
            receiver.advance();
            Buffer buffer = this.current.toBuffer();
            this.current = null;
            this.onMessage(receiver, delivery, buffer);
        }

        @Override
        void doCommit() throws Exception {
        }

        @Override
        void doRollback() throws Exception {
        }

        protected abstract void onMessage(Receiver var1, Delivery var2, Buffer var3) throws Exception;
    }

    static abstract class AmqpDeliveryListener {
        AmqpDeliveryListener() {
        }

        public abstract void onDelivery(Delivery var1) throws Exception;

        public void onClose() throws Exception {
        }

        public void drainCheck() {
        }

        abstract void doCommit() throws Exception;

        abstract void doRollback() throws Exception;
    }

    static class AmqpSessionContext {
        private final SessionId sessionId;
        long nextProducerId = 0L;
        long nextConsumerId = 0L;
        final Map<ConsumerId, ConsumerContext> consumers = new HashMap<ConsumerId, ConsumerContext>();

        public AmqpSessionContext(ConnectionId connectionId, long id) {
            this.sessionId = new SessionId(connectionId, id);
        }
    }
}

