/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.LRUCache;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.fusesource.hawtbuf.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTRetainedMessages
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTRetainedMessages.class);
    private static final Object LOCK = new Object();
    private LRUCache<String, Buffer> cache = new LRUCache(10000);

    private MQTTRetainedMessages() {
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        this.cache.clear();
    }

    @Override
    protected void doStart() throws Exception {
    }

    public void addMessage(String destination, Buffer payload) {
        this.cache.put(destination, payload);
    }

    public Buffer getMessage(String destination) {
        return (Buffer)this.cache.get(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQTTRetainedMessages getMQTTRetainedMessages(BrokerService broker) {
        MQTTRetainedMessages result = null;
        if (broker != null) {
            Object object = LOCK;
            synchronized (object) {
                Service[] services = broker.getServices();
                if (services != null) {
                    for (Service service : services) {
                        if (!(service instanceof MQTTRetainedMessages)) continue;
                        return (MQTTRetainedMessages)service;
                    }
                }
                result = new MQTTRetainedMessages();
                broker.addService(result);
                if (broker != null && broker.isStarted()) {
                    try {
                        result.start();
                    }
                    catch (Exception e) {
                        LOG.warn("Couldn't start MQTTRetainedMessages");
                    }
                }
            }
        }
        return result;
    }
}

