/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent;

import aQute.lib.osgi.Macro;
import aQute.lib.osgi.Processor;
import io.fabric8.agent.StreamProvider;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.repository.AggregateRepository;
import io.fabric8.agent.repository.StaticRepository;
import io.fabric8.agent.resolver.FeatureResource;
import io.fabric8.agent.resolver.RequirementImpl;
import io.fabric8.agent.resolver.ResolveContextImpl;
import io.fabric8.agent.resolver.ResourceBuilder;
import io.fabric8.agent.resolver.ResourceImpl;
import io.fabric8.agent.resolver.Slf4jResolverLog;
import io.fabric8.agent.resolver.UriNamespace;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.agent.utils.MultiException;
import io.fabric8.fab.DependencyTree;
import io.fabric8.fab.osgi.FabBundleInfo;
import io.fabric8.fab.osgi.FabResolver;
import io.fabric8.fab.osgi.FabResolverFactory;
import io.fabric8.utils.PatchUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.felix.resolver.ResolverImpl;
import org.apache.felix.resolver.Util;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Repository;
import org.fusesource.common.util.Manifests;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentBuilder.class);
    private final DownloadManager manager;
    private final FabResolverFactory fabResolverFactory;
    private final Collection<Repository> repositories;
    private final List<org.osgi.service.repository.Repository> resourceRepos;
    String featureRange = "${version;==}";
    AgentUtils.FileDownloader downloader;
    ResourceImpl requirements;
    Map<String, Resource> resources;
    Map<String, StreamProvider> providers;
    Set<Feature> featuresToRegister = new HashSet<Feature>();

    public DeploymentBuilder(DownloadManager manager, FabResolverFactory fabResolverFactory, Collection<Repository> repositories) {
        this.manager = manager;
        this.fabResolverFactory = fabResolverFactory;
        this.repositories = repositories;
        this.resourceRepos = new ArrayList<org.osgi.service.repository.Repository>();
    }

    public void addResourceRepository(org.osgi.service.repository.Repository repository) {
        this.resourceRepos.add(repository);
    }

    public Map<String, StreamProvider> getProviders() {
        return this.providers;
    }

    public void download(Set<String> features, Set<String> bundles, Set<String> fabs, Set<String> reqs, Set<String> overrides, Set<String> optionals) throws IOException, MultiException, InterruptedException, ResolutionException {
        this.downloader = new AgentUtils.FileDownloader(this.manager);
        this.resources = new ConcurrentHashMap<String, Resource>();
        this.providers = new ConcurrentHashMap<String, StreamProvider>();
        this.requirements = new ResourceImpl("dummy", "dummy", Version.emptyVersion);
        for (String string : features) {
            this.registerMatchingFeatures(string);
        }
        for (String string : bundles) {
            this.downloadAndBuildResource(string);
        }
        for (String string : fabs) {
            this.downloadAndBuildResource("fab:" + string);
        }
        for (String string : reqs) {
            this.downloadAndBuildResource("req:" + string);
        }
        for (String string : overrides) {
            this.downloadAndBuildResource(PatchUtils.extractUrl(string));
        }
        for (String string : optionals) {
            this.downloadAndBuildResource(string);
        }
        this.downloader.await();
        for (String string : overrides) {
            Resource over = this.resources.get(PatchUtils.extractUrl(string));
            if (over == null) continue;
            for (String uri : new ArrayList<String>(this.resources.keySet())) {
                VersionRange range;
                Resource res = this.resources.get(uri);
                if (!Util.getSymbolicName(res).equals(Util.getSymbolicName(over))) continue;
                String vr = PatchUtils.extractVersionRange(string);
                if (vr == null) {
                    Version v1 = Util.getVersion(res);
                    Version v2 = new Version(v1.getMajor(), v1.getMinor() + 1, 0);
                    range = new VersionRange(false, v1, v2, true);
                } else {
                    range = VersionRange.parseVersionRange(vr);
                }
                if (!range.contains(Util.getVersion(res)) || Util.getVersion(res).compareTo(Util.getVersion(over)) >= 0) continue;
                this.resources.put(uri, over);
            }
        }
        for (Feature feature : this.featuresToRegister) {
            Resource resource = FeatureResource.build(feature, this.featureRange, this.resources);
            this.resources.put("feature:" + feature.getName() + "/" + feature.getVersion(), resource);
        }
        for (String string : features) {
            this.requireFeature(string, this.requirements);
        }
        for (String string : bundles) {
            this.requireResource(string);
        }
        for (String string : reqs) {
            this.requireResource("req:" + string);
        }
        for (String string : fabs) {
            this.requireResource("fab:" + string);
        }
    }

    public Collection<Resource> resolve(Resource systemBundle, boolean resolveOptionalImports) throws ResolutionException {
        this.resources.put("system-bundle", systemBundle);
        ArrayList<org.osgi.service.repository.Repository> repos = new ArrayList<org.osgi.service.repository.Repository>();
        repos.add(new StaticRepository(this.resources.values()));
        repos.addAll(this.resourceRepos);
        ResolverImpl resolver = new ResolverImpl(new Slf4jResolverLog(LOGGER));
        ResolveContextImpl context = new ResolveContextImpl(Collections.singleton(this.requirements), Collections.<Resource>emptySet(), new AggregateRepository(repos), resolveOptionalImports);
        Map<Resource, List<Wire>> wiring = resolver.resolve(context);
        TreeMap<String, Resource> deploy = new TreeMap<String, Resource>();
        for (Resource res : wiring.keySet()) {
            String uri = UriNamespace.getUri(res);
            if (uri == null) continue;
            deploy.put(uri, res);
        }
        return deploy.values();
    }

    public void requireFeature(String feature, ResourceImpl resource) throws IOException {
        String[] split = feature.split("/");
        String name = split[0].trim();
        String version = split.length > 1 ? split[1].trim() : "";
        VersionRange range = version.length() == 0 ? VersionRange.ANY_VERSION : new VersionRange(version);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("osgi.identity", name);
        attrs.put("type", "karaf.feature");
        attrs.put("version", range);
        resource.addRequirement(new RequirementImpl(resource, "osgi.identity", Collections.<String, String>emptyMap(), attrs));
    }

    public void requireResource(String location) {
        Resource res = this.resources.get(location);
        if (res == null) {
            throw new IllegalStateException("Could not find resource for " + location);
        }
        List caps = res.getCapabilities("osgi.identity");
        if (caps.size() != 1) {
            throw new IllegalStateException("Resource does not have a single osgi.identity capability");
        }
        Capability cap = (Capability)caps.get(0);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("osgi.identity", cap.getAttributes().get("osgi.identity"));
        attrs.put("type", cap.getAttributes().get("type"));
        attrs.put("version", new VersionRange((Version)cap.getAttributes().get("version"), true));
        this.requirements.addRequirement(new RequirementImpl(this.requirements, "osgi.identity", Collections.<String, String>emptyMap(), attrs));
    }

    public void registerMatchingFeatures(String feature) throws IOException {
        String[] split = feature.split("/");
        String name = split[0].trim();
        String version = split.length > 1 ? split[1].trim() : Version.emptyVersion.toString();
        this.registerMatchingFeatures(name, new VersionRange(version));
    }

    public void registerMatchingFeatures(Feature feature) throws IOException {
        this.registerMatchingFeatures(feature.getName(), feature.getVersion());
    }

    public void registerMatchingFeatures(String name, String version) throws IOException {
        if (!version.startsWith("[") && !version.startsWith("(")) {
            Processor processor = new Processor();
            processor.setProperty("@", VersionTable.getVersion(version).toString());
            Macro macro = new Macro(processor, new Object[0]);
            version = macro.process(this.featureRange);
        }
        this.registerMatchingFeatures(name, new VersionRange(version));
    }

    public void registerMatchingFeatures(String name, VersionRange range) throws IOException {
        for (Repository repo : this.repositories) {
            Feature[] features;
            try {
                features = repo.getFeatures();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            for (Feature f : features) {
                Version v;
                if (!name.equals(f.getName()) || !range.contains(v = VersionTable.getVersion(f.getVersion()))) continue;
                this.featuresToRegister.add(f);
                for (Feature dep : f.getDependencies()) {
                    this.registerMatchingFeatures(dep);
                }
                for (BundleInfo bundle : f.getBundles()) {
                    this.downloadAndBuildResource(bundle.getLocation());
                }
            }
        }
    }

    public void downloadAndBuildResource(final String location) throws IOException {
        if (location.startsWith("fab:")) {
            String url = location.substring("fab:".length());
            this.downloader.download(url, new AgentUtils.DownloadCallback(){

                @Override
                public void downloaded(File file) throws Exception {
                    FabResolver resolver = DeploymentBuilder.this.fabResolverFactory.getResolver(file.toURI().toURL());
                    FabBundleInfo fabInfo = resolver.getInfo();
                    ResourceImpl resource = (ResourceImpl)DeploymentBuilder.this.manageResource(location, fabInfo.getManifest(), new StreamProvider.Fab(fabInfo));
                    for (String name : fabInfo.getFeatures()) {
                        DeploymentBuilder.this.registerMatchingFeatures(name);
                        DeploymentBuilder.this.requireFeature(name, resource);
                    }
                    for (DependencyTree dep : fabInfo.getBundles()) {
                        File depFile = dep.getJarFile();
                        Attributes attrs = DeploymentBuilder.this.getAttributes(dep.getJarURL().toString(), depFile);
                        if (attrs.getValue("Bundle-SymbolicName") == null) continue;
                        DeploymentBuilder.this.manageResource(DeploymentBuilder.this.getMvnUrl(dep), attrs, new StreamProvider.File(depFile));
                    }
                }
            });
        } else if (location.startsWith("req:")) {
            try {
                ResourceImpl resource = new ResourceImpl(location, "dummy", Version.emptyVersion);
                for (Requirement req : ResourceBuilder.parseRequirement(resource, location.substring("req:".length()))) {
                    resource.addRequirement(req);
                }
                this.resources.put(location, resource);
            }
            catch (BundleException e) {
                throw new IOException("Error parsing requirement", e);
            }
        } else {
            this.downloader.download(location, new AgentUtils.DownloadCallback(){

                @Override
                public void downloaded(File file) throws Exception {
                    DeploymentBuilder.this.manageResource(location, file);
                }
            });
        }
    }

    private String getMvnUrl(DependencyTree dep) {
        String groupId = dep.getGroupId();
        String artifactId = dep.getArtifactId();
        String version = dep.getVersion();
        String classifier = dep.getClassifier();
        String extension = dep.getExtension();
        StringBuilder sb = new StringBuilder();
        sb.append("mvn:");
        sb.append(groupId);
        sb.append("/");
        sb.append(artifactId);
        sb.append("/");
        sb.append(version);
        if (!"".equals(classifier) || !"jar".equals(extension)) {
            sb.append("/");
            sb.append(extension);
        }
        if (!"".equals(classifier)) {
            sb.append("/");
            sb.append(classifier);
        }
        return sb.toString();
    }

    private Resource manageResource(String location, File file) throws Exception {
        Resource resource = this.resources.get(location);
        if (resource == null) {
            Attributes attributes = this.getAttributes(location, file);
            resource = this.manageResource(location, attributes, new StreamProvider.File(file));
        }
        return resource;
    }

    private Resource manageResource(String location, Attributes attributes, StreamProvider provider) throws Exception {
        Resource resource = this.resources.get(location);
        if (resource == null) {
            resource = this.createResource(location, attributes);
            this.resources.put(location, resource);
            this.providers.put(location, provider);
        }
        return resource;
    }

    private Resource createResource(String uri, Attributes attributes) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
            headers.put(attr.getKey().toString(), attr.getValue().toString());
        }
        try {
            return ResourceBuilder.build(uri, headers);
        }
        catch (BundleException e) {
            throw new Exception("Unable to create resource for bundle " + uri, e);
        }
    }

    protected Attributes getAttributes(String uri, File file) throws Exception {
        Manifest man = Manifests.getManifest(file);
        if (man == null) {
            throw new IllegalArgumentException("Resource " + uri + " does not contain a manifest");
        }
        return man.getMainAttributes();
    }
}

