/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.internal;

import io.fabric8.fab.osgi.ServiceConstants;
import io.fabric8.fab.osgi.internal.Configuration;
import io.fabric8.fab.osgi.internal.FabConnectionFactory;
import io.fabric8.fab.osgi.internal.OsgiModuleRegistry;
import java.io.File;
import org.ops4j.pax.url.commons.handler.HandlerActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;

public class Activator
extends HandlerActivator<Configuration> {
    private static Activator instance;
    private BundleContext bundleContext;
    public static OsgiModuleRegistry registry;

    public static Activator getInstance() {
        return instance;
    }

    public static BundleContext getInstanceBundleContext() {
        Activator activator = Activator.getInstance();
        if (activator != null) {
            return activator.getBundleContext();
        }
        return null;
    }

    public Activator() {
        super(ServiceConstants.PROTOCOLS_SUPPORTED, "io.fabric8.fab.osgi.url", new FabConnectionFactory());
        instance = this;
    }

    @Override
    public void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        ServiceReference serviceReference = bundleContext.getServiceReference("org.osgi.service.cm.ConfigurationAdmin");
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
        File data = new File(System.getProperty("karaf.data", "."));
        registry.setDirectory(new File(data, "fab-module-registry"));
        registry.setConfigurationAdmin(configurationAdmin);
        registry.setPid("io.fabric8.fab.osgi.registry");
        registry.load();
        super.start(bundleContext);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    static {
        registry = new OsgiModuleRegistry();
    }
}

