/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.internal;

import io.fabric8.fab.ModuleDescriptor;
import io.fabric8.fab.ModuleRegistry;
import io.fabric8.fab.VersionedDependencyId;
import io.fabric8.fab.osgi.internal.Activator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.fusesource.common.util.Strings;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class OsgiModuleRegistry
extends ModuleRegistry {
    File directory;
    ConfigurationAdmin configurationAdmin;
    String pid;
    HashMap<String, URL> repos = new HashMap();

    public OsgiModuleRegistry() {
        Activator.registry = this;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public File getLocalIndexDir() {
        return new File(this.directory, "local");
    }

    public void load() {
        this.loadRepoConfiguration();
        boolean download = false;
        for (Map.Entry<String, URL> entry : this.repos.entrySet()) {
            String name = entry.getKey();
            URL url = entry.getValue();
            File file = new File(this.directory, "repo-" + name + ".zip");
            if ("file".equals(url.getProtocol()) || file.exists()) continue;
            download = true;
        }
        this.update(System.err, download);
    }

    private void loadRepoConfiguration() {
        this.repos.clear();
        try {
            Dictionary config = this.getConfig();
            Enumeration elements = config.keys();
            while (elements.hasMoreElements()) {
                String key = (String)elements.nextElement();
                if (!key.startsWith("repo.")) continue;
                String name = key.substring("repo.".length());
                String value = (String)config.get(key);
                this.repos.put(name, new URL(value));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static long copy(InputStream in, OutputStream out) throws IOException {
        long rc = 0L;
        byte[] buffer = new byte[8192];
        int bytes = in.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            rc += (long)bytes;
            bytes = in.read(buffer);
        }
        return rc;
    }

    public void update(PrintStream err) {
        this.loadRepoConfiguration();
        this.update(err, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(PrintStream err, boolean download) {
        this.clear();
        this.getLocalIndexDir().mkdirs();
        this.loadDirectory(this.getLocalIndexDir(), err, true);
        for (Map.Entry<String, URL> entry : this.repos.entrySet()) {
            File file;
            String name;
            block15: {
                name = entry.getKey();
                URL url = entry.getValue();
                file = new File(this.directory, "repo-" + name + ".zip");
                if ("file".equals(url.getProtocol())) {
                    file = new File(url.getFile());
                } else if (download) {
                    err.println("Downloading: " + url);
                    try {
                        InputStream is = url.openStream();
                        try {
                            FileOutputStream os = new FileOutputStream(file);
                            try {
                                OsgiModuleRegistry.copy(is, os);
                            }
                            finally {
                                os.close();
                            }
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        if (err == null) break block15;
                        err.println(String.format("Error occurred while downloading '%s'.  Error: %s", url, e));
                    }
                }
            }
            if (file.isDirectory()) {
                this.loadDirectory(file, err);
                continue;
            }
            try {
                this.loadJar(file);
            }
            catch (IOException e) {
                if (err == null) continue;
                err.println(String.format("Error occurred while loading repo '%s'.  Error: %s", name, e));
            }
        }
    }

    @Override
    protected List<String> getEnabledExtensions(VersionedDependencyId id) {
        try {
            String value = this.getConfigProperty("extensions." + id);
            if (value == null) {
                return null;
            }
            return Strings.splitAndTrimAsList(value, " ");
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    protected void setEnabledExtensions(VersionedDependencyId id, List<String> values) {
        this.setConfigProperty("extensions." + id.toString(), Strings.join(values, " "));
    }

    private String getConfigProperty(String key) throws IOException {
        Dictionary props = this.getConfigurationProperties();
        if (props == null) {
            return null;
        }
        String value = (String)props.get(key);
        if (value == null) {
            return null;
        }
        return value;
    }

    protected Configuration getConfiguration() throws IOException {
        Configuration configuration = null;
        if (this.configurationAdmin != null) {
            configuration = this.configurationAdmin.getConfiguration(this.pid);
        }
        return configuration;
    }

    private Dictionary getConfig() throws IOException {
        Dictionary props = this.getConfigurationProperties();
        if (props == null) {
            return new Hashtable();
        }
        return props;
    }

    protected void setConfigProperty(String key, String value) {
        try {
            Hashtable<String, String> props = this.getConfigurationProperties();
            if (props == null) {
                props = new Hashtable<String, String>();
            }
            ((Dictionary)props).put(key, value);
            Configuration configuration = this.getConfiguration();
            if (configuration != null) {
                configuration.update(props);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Dictionary getConfigurationProperties() throws IOException {
        Configuration configuration = this.getConfiguration();
        Dictionary props = null;
        if (configuration != null) {
            props = configuration.getProperties();
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleRegistry.VersionedModule add(ModuleDescriptor descriptor) {
        try {
            String path = descriptor.getId().getRepositoryPath() + ".fmd";
            File file = new File(this.getLocalIndexDir(), path);
            file.getParentFile().mkdirs();
            Properties props = descriptor.toProperties();
            FileOutputStream os = new FileOutputStream(file);
            try {
                props.store(os, null);
            }
            finally {
                os.close();
            }
            return super.add(descriptor, file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ModuleRegistry.VersionedModule remove(VersionedDependencyId id) {
        ModuleRegistry.VersionedModule rc = this.getVersionedModule(id);
        if (rc != null && rc.getFile() != null) {
            rc = super.remove(id);
            rc.getFile().delete();
        }
        return rc;
    }

    public Map<VersionedDependencyId, Bundle> getInstalled() {
        HashMap<VersionedDependencyId, Bundle> rc = new HashMap<VersionedDependencyId, Bundle>();
        for (Bundle bundle : Activator.getInstanceBundleContext().getBundles()) {
            String value = (String)bundle.getHeaders().get("FAB-Id");
            if (!Strings.notEmpty(value)) continue;
            try {
                rc.put(VersionedDependencyId.fromString(value), bundle);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return rc;
    }
}

