/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import io.fabric8.api.FabricException;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.git.GitListener;
import io.fabric8.git.GitService;
import io.fabric8.git.internal.GitContext;
import io.fabric8.git.internal.GitHelpers;
import io.fabric8.git.internal.GitOperation;
import io.fabric8.git.internal.GitProfiles;
import io.fabric8.internal.RequirementsJson;
import io.fabric8.service.AbstractDataStore;
import io.fabric8.utils.DataStoreUtils;
import io.fabric8.utils.Files;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.felix.utils.properties.Properties;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.CannotDeleteCurrentBranchException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.gitective.core.CommitUtils;
import org.gitective.core.RepositoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GitDataStore
extends AbstractDataStore<GitDataStore> {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitDataStore.class);
    private static final String MASTER_BRANCH = "master";
    private static final String CONFIG_ROOT_DIR = "fabric";
    public static final String GIT_PULL_PERIOD = "gitPullPeriod";
    public static final String GIT_REMOTE_URL = "gitRemoteUrl";
    public static final String GIT_REMOTE_USER = "gitRemoteUser";
    public static final String GIT_REMOTE_PASSWORD = "gitRemotePassword";
    public static final String[] SUPPORTED_CONFIGURATION = new String[]{"type", "gitRemoteUrl", "gitRemoteUser", "gitRemotePassword", "gitPullPeriod"};
    public static final String CONFIGS = "fabric";
    public static final String CONFIGS_PROFILES = "fabric" + File.separator + "profiles";
    public static final String AGENT_METADATA_FILE = "io.fabric8.agent.properties";
    private static final String PROPERTIES_SUFFIX = ".properties";
    public static final String TYPE = "git";
    public static final int GIT_COMMIT_SHORT_LENGTH = 7;
    public static final boolean useDirectoriesForProfiles = true;
    public static final String PROFILE_FOLDER_SUFFIX = ".profile";
    private final ValidatingReference<GitService> gitService = new ValidatingReference();
    private final ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor();
    private final Object gitOperationMonitor = new Object();
    private final Set<String> versions = new CopyOnWriteArraySet<String>();
    private final GitListener gitListener = new GitDataStoreListener();
    private final AtomicReference<String> remoteRef = new AtomicReference<String>("origin");
    private String configuredUrl;
    private String remoteUrl;
    private long pullPeriod = 1000L;
    private String lastFetchWarning;

    protected void activateInternal() {
        try {
            super.activateInternal();
            Map configuration = this.getDataStoreProperties();
            this.pullPeriod = PropertiesHelper.getLongValue(configuration, GIT_PULL_PERIOD, this.pullPeriod);
            this.configuredUrl = (String)configuration.get(GIT_REMOTE_URL);
            GitService optionalService = (GitService)this.gitService.getOptional();
            if (this.configuredUrl != null) {
                this.gitListener.onRemoteUrlChanged(this.configuredUrl);
                this.remoteUrl = this.configuredUrl;
            } else if (optionalService != null) {
                optionalService.addGitListener(this.gitListener);
                this.remoteUrl = optionalService.getRemoteUrl();
                this.gitListener.onRemoteUrlChanged(this.remoteUrl);
            }
            this.forceGetVersions();
            LOG.info("starting to pull from remote repository every " + this.pullPeriod + " millis");
            this.threadPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (GitDataStore.this.isValid()) {
                        LOG.debug("Performing timed pull");
                        GitDataStore.this.pull();
                        GitDataStore.this.push();
                    }
                }
            }, this.pullPeriod, this.pullPeriod, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new FabricException("Failed to start GitDataStore:", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateInternal() {
        block8: {
            try {
                GitService optsrv = (GitService)this.gitService.getOptional();
                if (optsrv != null) {
                    optsrv.removeGitListener(this.gitListener);
                }
                if (this.threadPool == null) break block8;
                this.threadPool.shutdown();
                try {
                    if (!this.threadPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                        this.threadPool.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    this.threadPool.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    throw FabricException.launderThrowable((Throwable)ex);
                }
            }
            finally {
                super.deactivateInternal();
            }
        }
    }

    public String getRemote() {
        return this.remoteRef.get();
    }

    public void setRemote(String remote) {
        if (remote == null) {
            throw new IllegalArgumentException("Remote name cannot be null");
        }
        this.remoteRef.set(remote);
    }

    public void importFromFileSystem(String from) {
        this.assertValid();
        File sourceDir = new File(from);
        if (!sourceDir.isDirectory()) {
            throw new IllegalArgumentException("Not a valid source dir: " + sourceDir.getAbsolutePath());
        }
        File fabricsDir = new File(sourceDir, "fabric");
        File configs = new File(fabricsDir, "configs");
        String defaultVersion = this.getDefaultVersion();
        if (configs.exists()) {
            File metrics;
            File[] files;
            LOG.info("Importing the old ZooKeeper layout");
            File versions = new File(configs, "versions");
            if (versions.exists() && versions.isDirectory() && (files = versions.listFiles()) != null) {
                for (File versionFolder : files) {
                    File[] versionFiles;
                    String version = versionFolder.getName();
                    if (!versionFolder.isDirectory() || (versionFiles = versionFolder.listFiles()) == null) continue;
                    for (File versionFile : versionFiles) {
                        LOG.info("Importing version configuration " + versionFile + " to branch " + version);
                        this.importFromFileSystem(versionFile, "fabric", version, true);
                    }
                }
            }
            if ((metrics = new File(fabricsDir, "metrics")).exists()) {
                LOG.info("Importing metrics from " + metrics + " to branch " + defaultVersion);
                this.importFromFileSystem(metrics, "fabric", defaultVersion, false);
            }
        } else {
            LOG.info("Importing " + sourceDir + " as version " + defaultVersion);
            this.importFromFileSystem(sourceDir, "", defaultVersion, false);
        }
    }

    protected void importFromFileSystem(final File from, final String destinationPath, final String version, final boolean isProfileDir) {
        this.assertValid();
        this.gitOperation(new GitOperation<Void>(){

            @Override
            public Void call(Git git, GitContext context) throws Exception {
                GitDataStore.this.createOrCheckoutVersion(git, version);
                File toDir = GitHelpers.getRootGitDirectory(git);
                if (Strings.isNotBlank(destinationPath)) {
                    toDir = new File(toDir, destinationPath);
                }
                if (isProfileDir) {
                    GitDataStore.this.recursiveAddLegacyProfileDirectoryFiles(git, from, toDir, destinationPath);
                } else {
                    GitDataStore.this.recursiveCopyAndAdd(git, from, toDir, destinationPath, true);
                }
                context.commit("Imported from " + from);
                return null;
            }
        });
    }

    public void createVersion(final String version) {
        this.assertValid();
        this.gitOperation(new GitOperation<Void>(){

            @Override
            public Void call(Git git, GitContext context) throws Exception {
                GitDataStore.this.createOrCheckoutVersion(git, version);
                context.requirePush();
                return null;
            }
        });
    }

    public void createVersion(final String parentVersionId, final String toVersion) {
        this.assertValid();
        this.gitOperation(new GitOperation<Void>(){

            @Override
            public Void call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, parentVersionId);
                GitDataStore.this.createOrCheckoutVersion(git, toVersion);
                context.requirePush();
                return null;
            }
        });
    }

    public void deleteVersion(String version) {
        throw new UnsupportedOperationException("TODO");
    }

    public List<String> getVersions() {
        this.assertValid();
        return new ArrayList<String>(this.versions);
    }

    protected List<String> forceGetVersions() {
        return this.gitOperation(new GitOperation<List<String>>(){

            @Override
            public List<String> call(Git git, GitContext context) throws Exception {
                Collection<String> branches = RepositoryUtils.getBranches(git.getRepository());
                ArrayList<String> answer = new ArrayList<String>();
                for (String branch : branches) {
                    String prefix;
                    String name = branch;
                    if (!name.startsWith(prefix = "refs/heads/") || (name = name.substring(prefix.length())).equals(GitDataStore.MASTER_BRANCH)) continue;
                    answer.add(name);
                }
                GitDataStore.this.versions.clear();
                GitDataStore.this.versions.addAll(answer);
                return answer;
            }
        }, false);
    }

    public boolean hasVersion(String name) {
        this.assertValid();
        return this.getVersions().contains(name);
    }

    public List<String> getProfiles(final String version) {
        this.assertValid();
        return this.gitOperation(new GitOperation<List<String>>(){

            @Override
            public List<String> call(Git git, GitContext context) throws Exception {
                ArrayList<String> answer = new ArrayList<String>();
                File profilesDir = GitDataStore.this.getProfilesDirectory(git);
                if (GitDataStore.this.hasVersion(version)) {
                    GitDataStore.this.checkoutVersion(git, GitDataStore.MASTER_BRANCH);
                    GitDataStore.this.doAddProfileNames(answer, profilesDir, "");
                    GitDataStore.this.checkoutVersion(git, version);
                    GitDataStore.this.doAddProfileNames(answer, profilesDir, "");
                }
                return answer;
            }
        }, !this.hasVersion(version));
    }

    private void doAddProfileNames(List<String> answer, File profilesDir, String prefix) {
        File[] files;
        if (profilesDir.exists() && (files = profilesDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                String name = file.getName();
                if (name.endsWith(PROFILE_FOLDER_SUFFIX)) {
                    name = name.substring(0, name.length() - PROFILE_FOLDER_SUFFIX.length());
                    answer.add(prefix + name);
                    continue;
                }
                this.doAddProfileNames(answer, file, prefix + name + "-");
            }
        }
    }

    protected File getProfilesDirectory(Git git) {
        this.assertValid();
        return new File(GitHelpers.getRootGitDirectory(git), CONFIGS_PROFILES);
    }

    public File getProfileDirectory(Git git, String profile) {
        this.assertValid();
        File profilesDirectory = this.getProfilesDirectory(git);
        String path = this.convertProfileIdToDirectory(profile);
        return new File(profilesDirectory, path);
    }

    public String getProfile(final String version, final String profile, final boolean create) {
        this.assertValid();
        return this.gitOperation(new GitOperation<String>(){

            @Override
            public String call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                File profileDirectory = GitDataStore.this.getProfileDirectory(git, profile);
                if (!profileDirectory.exists()) {
                    if (create) {
                        return GitDataStore.this.doCreateProfile(git, context, profile, version);
                    }
                    return null;
                }
                return profile;
            }
        });
    }

    public void createProfile(final String version, final String profile) {
        this.assertValid();
        this.gitOperation(new GitOperation<String>(){

            @Override
            public String call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                return GitDataStore.this.doCreateProfile(git, context, profile, version);
            }
        });
    }

    public void deleteProfile(final String version, final String profile) {
        this.assertValid();
        this.gitOperation(new GitOperation<Void>(){

            @Override
            public Void call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                File profileDirectory = GitDataStore.this.getProfileDirectory(git, profile);
                GitDataStore.this.doRecursiveDeleteAndRemove(git, profileDirectory);
                context.commit("Removed profile " + profile);
                return null;
            }
        });
    }

    public Map<String, String> getVersionAttributes(String version) {
        this.assertValid();
        try {
            String node = ZkPath.CONFIG_VERSION.getPath(new String[]{version});
            return ZooKeeperUtils.getPropertiesAsMap((TreeCache)this.getTreeCache(), (String)node);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setVersionAttribute(String version, String key, String value) {
        this.assertValid();
        try {
            Map<String, String> props = this.getVersionAttributes(version);
            if (value != null) {
                props.put(key, value);
            } else {
                props.remove(key);
            }
            String node = ZkPath.CONFIG_VERSION.getPath(new String[]{version});
            ZooKeeperUtils.setPropertiesAsMap((CuratorFramework)this.getCurator(), (String)node, props);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public String getLastModified(final String version, final String profile) {
        this.assertValid();
        String answer = this.gitOperation(new GitOperation<String>(){

            @Override
            public String call(Git git, GitContext context) throws Exception {
                String revision = git.getRepository().getRefDatabase().getRef(version).getObjectId().getName();
                String path = GitDataStore.this.convertProfileIdToDirectory(profile);
                RevCommit commit = CommitUtils.getLastCommit(git.getRepository(), revision, CONFIGS_PROFILES + File.separator + path);
                return commit != null ? commit.getId().abbreviate(7).name() : "";
            }
        }, false);
        return answer != null ? answer : "";
    }

    public Collection<String> listFiles(final String version, final Iterable<String> profiles, final String path) {
        this.assertValid();
        return this.gitOperation(new GitOperation<Collection<String>>(){

            @Override
            public Collection<String> call(Git git, GitContext context) throws Exception {
                TreeSet<String> answer = new TreeSet<String>();
                for (String profile : profiles) {
                    String[] values;
                    GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                    File profileDirectory = GitDataStore.this.getProfileDirectory(git, profile);
                    File file = Strings.isNotBlank(path) ? new File(profileDirectory, path) : profileDirectory;
                    if (!file.exists() || (values = file.list()) == null) continue;
                    for (String value : values) {
                        answer.add(value);
                    }
                }
                return answer;
            }
        }, !this.hasVersion(version));
    }

    public Map<String, byte[]> getFileConfigurations(final String version, final String profile) {
        this.assertValid();
        return this.gitOperation(new GitOperation<Map<String, byte[]>>(){

            @Override
            public Map<String, byte[]> call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                return GitDataStore.this.doGetFileConfigurations(git, profile);
            }
        }, !this.hasVersion(version));
    }

    protected Map<String, byte[]> doGetFileConfigurations(Git git, String profile) throws IOException {
        this.assertValid();
        HashMap<String, byte[]> configurations = new HashMap<String, byte[]>();
        File profileDirectory = this.getProfileDirectory(git, profile);
        this.doPutFileConfigurations(configurations, profileDirectory, profileDirectory);
        return configurations;
    }

    protected Map<String, Map<String, String>> doGetConfigurations(Git git, String profile) throws IOException {
        this.assertValid();
        HashMap<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
        File profileDirectory = this.getProfileDirectory(git, profile);
        this.doPutConfigurations(configurations, profileDirectory, profileDirectory);
        return configurations;
    }

    private void doPutFileConfigurations(Map<String, byte[]> configurations, File profileDirectory, File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    String relativePath = this.getFilePattern(profileDirectory, file);
                    configurations.put(relativePath, this.doLoadFileConfiguration(file));
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.doPutFileConfigurations(configurations, profileDirectory, file);
            }
        }
    }

    private void doPutConfigurations(Map<String, Map<String, String>> configurations, File profileDirectory, File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getPath().endsWith(PROPERTIES_SUFFIX)) continue;
                String relativePath = this.getFilePattern(profileDirectory, file);
                configurations.put(DataStoreUtils.stripSuffix(relativePath, PROPERTIES_SUFFIX), this.doLoadConfiguration(file));
            }
        }
    }

    public byte[] getFileConfiguration(final String version, final String profile, final String fileName) {
        this.assertValid();
        return this.gitOperation(new GitOperation<byte[]>(){

            @Override
            public byte[] call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                File profileDirectory = GitDataStore.this.getProfileDirectory(git, profile);
                File file = new File(profileDirectory, fileName);
                return GitDataStore.this.doLoadFileConfiguration(file);
            }
        }, !this.hasVersion(version));
    }

    public void setFileConfigurations(final String version, final String profile, final Map<String, byte[]> configurations) {
        this.assertValid();
        this.gitOperation(new GitOperation<Void>(){

            @Override
            public Void call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                File profileDirectory = GitDataStore.this.getProfileDirectory(git, profile);
                GitDataStore.this.doSetFileConfigurations(git, profileDirectory, profile, configurations);
                context.setPushBranch(version);
                context.commit("Updated configuration for profile " + profile);
                return null;
            }
        });
    }

    protected void doSetFileConfigurations(Git git, File profileDirectory, String profile, Map<String, byte[]> configurations) throws IOException, GitAPIException {
        this.assertValid();
        Map<String, byte[]> oldCfgs = this.doGetFileConfigurations(git, profile);
        for (Map.Entry<String, byte[]> entry : configurations.entrySet()) {
            String file = entry.getKey();
            oldCfgs.remove(file);
            byte[] newCfg = entry.getValue();
            this.doSetFileConfiguration(git, profile, file, newCfg);
        }
        for (String pid : oldCfgs.keySet()) {
            this.doRecursiveDeleteAndRemove(git, new File(profileDirectory, pid));
        }
    }

    protected void doSetConfigurations(Git git, File profileDirectory, String profile, Map<String, Map<String, String>> configurations) throws IOException, GitAPIException {
        this.assertValid();
        Map<String, Map<String, String>> oldCfgs = this.doGetConfigurations(git, profile);
        for (Map.Entry<String, Map<String, String>> entry : configurations.entrySet()) {
            String pid = entry.getKey();
            oldCfgs.remove(pid);
            Map<String, String> newCfg = entry.getValue();
            this.doSetConfiguration(git, profile, pid, newCfg);
        }
        for (String pid : oldCfgs.keySet()) {
            this.doRecursiveDeleteAndRemove(git, this.getPidFile(profileDirectory, pid));
        }
    }

    public void setFileConfiguration(final String version, final String profile, final String fileName, final byte[] configuration) {
        this.assertValid();
        this.gitOperation(new GitOperation<Void>(){

            @Override
            public Void call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                GitDataStore.this.doSetFileConfiguration(git, profile, fileName, configuration);
                context.commit("Updated " + fileName + " for profile " + profile);
                return null;
            }
        });
    }

    protected void doSetFileConfiguration(Git git, String profile, String fileName, byte[] configuration) throws IOException, GitAPIException {
        this.assertValid();
        File profileDirectory = this.getProfileDirectory(git, profile);
        File file = new File(profileDirectory, fileName);
        if (configuration == null) {
            this.doRecursiveDeleteAndRemove(git, file);
        } else {
            Files.writeToFile(file, configuration);
            this.doAddFiles(git, file);
        }
    }

    protected void doSetConfiguration(Git git, String profile, String pid, Map<String, String> configuration) throws IOException, GitAPIException {
        this.assertValid();
        File profileDirectory = this.getProfileDirectory(git, profile);
        File file = new File(profileDirectory, pid + PROPERTIES_SUFFIX);
        if (configuration == null) {
            this.doRecursiveDeleteAndRemove(git, file);
        } else {
            Properties props = new Properties(file);
            for (Map.Entry<String, String> entry : configuration.entrySet()) {
                props.setProperty(entry.getKey(), entry.getValue());
            }
            for (String key : new ArrayList(props.keySet())) {
                if (configuration.containsKey(key)) continue;
                props.remove(key);
            }
            props.save();
            this.doAddFiles(git, file);
        }
    }

    protected File getPidFile(File profileDirectory, String pid) {
        this.assertValid();
        return new File(profileDirectory, pid + PROPERTIES_SUFFIX);
    }

    protected String getPidFromFileName(String relativePath) throws IOException {
        this.assertValid();
        return DataStoreUtils.stripSuffix(relativePath, PROPERTIES_SUFFIX);
    }

    public Map<String, String> getConfiguration(final String version, final String profile, final String pid) {
        this.assertValid();
        return this.gitOperation(new GitOperation<Map<String, String>>(){

            @Override
            public Map<String, String> call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                File profileDirectory = GitDataStore.this.getProfileDirectory(git, profile);
                File file = GitDataStore.this.getPidFile(profileDirectory, pid);
                if (file.isFile() && file.exists()) {
                    byte[] data = Files.readBytes(file);
                    return DataStoreUtils.toMap(data);
                }
                return new HashMap<String, String>();
            }
        }, !this.hasVersion(version));
    }

    public void setConfigurations(final String version, final String profile, final Map<String, Map<String, String>> configurations) {
        this.assertValid();
        this.gitOperation(new GitOperation<Void>(){

            @Override
            public Void call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                File profileDirectory = GitDataStore.this.getProfileDirectory(git, profile);
                GitDataStore.this.doSetConfigurations(git, profileDirectory, profile, configurations);
                context.setPushBranch(version);
                context.commit("Updated configuration for profile " + profile);
                return null;
            }
        });
    }

    public void setConfiguration(final String version, final String profile, final String pid, final Map<String, String> configuration) {
        this.assertValid();
        this.gitOperation(new GitOperation<Void>(){

            @Override
            public Void call(Git git, GitContext context) throws Exception {
                GitDataStore.this.checkoutVersion(git, GitProfiles.getBranch(version, profile));
                GitDataStore.this.doSetConfiguration(git, profile, pid, configuration);
                context.setPushBranch(version);
                context.commit("Updated configuration for profile " + profile);
                return null;
            }
        });
    }

    public String getDefaultJvmOptions() {
        this.assertValid();
        try {
            if (this.getCurator().getZookeeperClient().isConnected() && ZooKeeperUtils.exists((CuratorFramework)this.getCurator(), (String)"/fabric/configs/io.fabric8.containers.jvmOptions") != null) {
                return ZooKeeperUtils.getStringData((TreeCache)this.getTreeCache(), (String)"/fabric/configs/io.fabric8.containers.jvmOptions");
            }
            return "";
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setDefaultJvmOptions(String jvmOptions) {
        this.assertValid();
        try {
            String opts = jvmOptions != null ? jvmOptions : "";
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)"/fabric/configs/io.fabric8.containers.jvmOptions", (String)opts);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public FabricRequirements getRequirements() {
        this.assertValid();
        try {
            FabricRequirements answer = null;
            if (this.getTreeCache().getCurrentData("/fabric/configs/io.fabric8.requirements.json") != null) {
                String json = ZooKeeperUtils.getStringData((TreeCache)this.getTreeCache(), (String)"/fabric/configs/io.fabric8.requirements.json");
                answer = RequirementsJson.fromJSON((String)json);
            }
            if (answer == null) {
                answer = new FabricRequirements();
            }
            return answer;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setRequirements(FabricRequirements requirements) throws IOException {
        this.assertValid();
        try {
            requirements.removeEmptyRequirements();
            String json = RequirementsJson.toJSON((FabricRequirements)requirements);
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)"/fabric/configs/io.fabric8.requirements.json", (String)json);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public String getClusterId() {
        this.assertValid();
        try {
            return ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public List<String> getEnsembleContainers() {
        this.assertValid();
        ArrayList<String> containers = new ArrayList<String>();
        try {
            String ensemble = ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_ENSEMBLE.getPath(new String[]{this.getClusterId()}));
            if (ensemble != null) {
                for (String name : ensemble.trim().split(",")) {
                    containers.add(name);
                }
            }
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
        return containers;
    }

    public Git getGit() throws IOException {
        this.assertValid();
        return ((GitService)this.gitService.get()).get();
    }

    public <T> T gitOperation(GitOperation<T> operation) {
        this.assertValid();
        return this.gitOperation(null, operation, true);
    }

    public <T> T gitOperation(GitOperation<T> operation, boolean pullFirst) {
        this.assertValid();
        return this.gitOperation(null, operation, pullFirst);
    }

    public <T> T gitOperation(PersonIdent personIdent, GitOperation<T> operation, boolean pullFirst) {
        this.assertValid();
        return this.gitOperation(personIdent, operation, pullFirst, new GitContext());
    }

    public <T> T gitOperation(PersonIdent personIdent, GitOperation<T> operation, boolean pullFirst, GitContext context) {
        Object object = this.gitOperationMonitor;
        synchronized (object) {
            this.assertValid();
            try {
                Git git = this.getGit();
                Repository repository = git.getRepository();
                if (personIdent == null) {
                    personIdent = new PersonIdent(repository);
                }
                if (GitHelpers.hasGitHead(git)) {
                    git.stashCreate().setPerson(personIdent).setWorkingDirectoryMessage("Stash before a write").call();
                }
                if (pullFirst) {
                    this.doPull(git, this.getCredentialsProvider(), false);
                }
                T answer = operation.call(git, context);
                boolean requirePush = context.isRequirePush();
                if (context.isRequireCommit()) {
                    requirePush = true;
                    String message = context.getCommitMessage().toString();
                    if (message.length() == 0) {
                        LOG.warn("No commit message from " + operation + ". Please add one! :)");
                    }
                    git.commit().setMessage(message).call();
                }
                if (requirePush) {
                    this.doPush(git, context, this.getCredentialsProvider());
                }
                if (context.isRequireCommit()) {
                    this.clearCaches();
                    this.fireChangeNotifications();
                }
                return answer;
            }
            catch (Exception e) {
                throw FabricException.launderThrowable((Throwable)e);
            }
        }
    }

    public Iterable<PushResult> doPush(Git git, GitContext gitContext) throws Exception {
        this.assertValid();
        return this.doPush(git, gitContext, this.getCredentialsProvider());
    }

    protected Iterable<PushResult> doPush(Git git, GitContext gitContext, CredentialsProvider credentialsProvider) throws Exception {
        this.assertValid();
        try {
            Repository repository = git.getRepository();
            StoredConfig config = repository.getConfig();
            String url = config.getString("remote", this.remoteRef.get(), "url");
            if (Strings.isNullOrBlank(url)) {
                LOG.info("No remote repository defined yet for the git repository at " + GitHelpers.getRootGitDirectory(git) + " so not doing a push");
                return Collections.emptyList();
            }
            return ((PushCommand)((PushCommand)git.push().setTimeout(10)).setCredentialsProvider(credentialsProvider)).setPushAll().call();
        }
        catch (Exception ex) {
            LOG.debug("Push failed. This will be ignored.", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    protected CredentialsProvider getCredentialsProvider() {
        this.assertValid();
        Map properties = this.getDataStoreProperties();
        String username = null;
        String password = null;
        if (this.isExternalGitConfigured(properties)) {
            username = this.getExternalUser(properties);
            password = this.getExternalCredential(properties);
        } else {
            RuntimeProperties sysprops = this.getRuntimeProperties();
            username = ZooKeeperUtils.getContainerLogin((RuntimeProperties)sysprops);
            password = ZooKeeperUtils.generateContainerToken((RuntimeProperties)sysprops, (CuratorFramework)this.getCurator());
        }
        return new UsernamePasswordCredentialsProvider(username, password);
    }

    private boolean isExternalGitConfigured(Map<String, String> properties) {
        return properties != null && properties.containsKey(GIT_REMOTE_USER) && properties.containsKey(GIT_REMOTE_PASSWORD);
    }

    private String getExternalUser(Map<String, String> properties) {
        return properties.get(GIT_REMOTE_USER);
    }

    private String getExternalCredential(Map<String, String> properties) {
        return properties.get(GIT_REMOTE_PASSWORD);
    }

    protected void doPull(Git git, CredentialsProvider credentialsProvider, boolean doDeleteBranches) {
        this.assertValid();
        try {
            Repository repository = git.getRepository();
            StoredConfig config = repository.getConfig();
            String url = config.getString("remote", this.remoteRef.get(), "url");
            if (Strings.isNullOrBlank(url)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No remote repository defined for the git repository at " + GitHelpers.getRootGitDirectory(git) + " so not doing a pull");
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Performing a fetch in git repository " + GitHelpers.getRootGitDirectory(git) + " on remote URL: " + url);
            }
            boolean hasChanged = false;
            try {
                FetchResult result = ((FetchCommand)((FetchCommand)git.fetch().setTimeout(10)).setCredentialsProvider(credentialsProvider)).setRemote(this.remoteRef.get()).call();
                if (Strings.isNullOrBlank(result.getMessages())) {
                    // empty if block
                }
                LOG.debug(result.getMessages());
                this.lastFetchWarning = null;
            }
            catch (Exception ex) {
                String fetchWarning = ex.getMessage();
                if (!fetchWarning.equals(this.lastFetchWarning)) {
                    LOG.warn("Fetch failed because of: " + fetchWarning);
                    LOG.debug("Fetch failed - the error will be ignored", (Throwable)ex);
                    this.lastFetchWarning = fetchWarning;
                }
                return;
            }
            HashMap<String, Ref> localBranches = new HashMap<String, Ref>();
            HashMap<String, Ref> remoteBranches = new HashMap<String, Ref>();
            HashSet<String> gitVersions = new HashSet<String>();
            Iterator i$ = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call().iterator();
            while (i$.hasNext()) {
                String name;
                Ref ref = (Ref)i$.next();
                if (ref.getName().startsWith("refs/remotes/" + this.remoteRef.get() + "/")) {
                    name = ref.getName().substring(("refs/remotes/" + this.remoteRef.get() + "/").length());
                    remoteBranches.put(name, ref);
                    gitVersions.add(name);
                    continue;
                }
                if (!ref.getName().startsWith("refs/heads/")) continue;
                name = ref.getName().substring("refs/heads/".length());
                localBranches.put(name, ref);
                gitVersions.add(name);
            }
            for (String version : gitVersions) {
                String remoteCommit;
                if (remoteBranches.isEmpty()) continue;
                if (!remoteBranches.containsKey(version)) {
                    if (!doDeleteBranches || version.equals(MASTER_BRANCH)) continue;
                    try {
                        git.branchDelete().setBranchNames(((Ref)localBranches.get(version)).getName()).setForce(true).call();
                    }
                    catch (CannotDeleteCurrentBranchException ex) {
                        git.checkout().setName(MASTER_BRANCH).setForce(true).call();
                        git.branchDelete().setBranchNames(((Ref)localBranches.get(version)).getName()).setForce(true).call();
                    }
                    this.removeVersion(version);
                    hasChanged = true;
                    continue;
                }
                if (!localBranches.containsKey(version)) {
                    this.addVersion(version);
                    git.checkout().setCreateBranch(true).setName(version).setStartPoint(this.remoteRef.get() + "/" + version).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setForce(true).call();
                    hasChanged = true;
                    continue;
                }
                String localCommit = ((Ref)localBranches.get(version)).getObjectId().getName();
                if (localCommit.equals(remoteCommit = ((Ref)remoteBranches.get(version)).getObjectId().getName())) continue;
                git.clean().setCleanDirectories(true).call();
                git.checkout().setName("HEAD").setForce(true).call();
                git.checkout().setName(version).setForce(true).call();
                MergeResult result = git.merge().setStrategy(MergeStrategy.THEIRS).include(((Ref)remoteBranches.get(version)).getObjectId()).call();
                if (result.getMergeStatus() == MergeResult.MergeStatus.ALREADY_UP_TO_DATE || !this.hasChanged(git, localCommit, remoteCommit)) continue;
                hasChanged = true;
            }
            if (hasChanged) {
                LOG.debug("Changed after pull!");
                if (credentialsProvider != null) {
                    this.getProfilesDirectory(git);
                }
                this.fireChangeNotifications();
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to pull from the remote git repo " + GitHelpers.getRootGitDirectory(git) + ". Reason: " + e, e);
        }
    }

    protected String doCreateProfile(Git git, GitContext context, String profile, String version) throws IOException, GitAPIException {
        this.assertValid();
        File profileDirectory = this.getProfileDirectory(git, profile);
        File metadataFile = new File(profileDirectory, AGENT_METADATA_FILE);
        if (metadataFile.exists()) {
            return null;
        }
        profileDirectory.mkdirs();
        Files.writeToFile(metadataFile, "#Profile:" + profile + "\n", Charset.defaultCharset());
        this.doAddFiles(git, profileDirectory, metadataFile);
        context.commit("Added profile " + profile);
        return profile;
    }

    protected void recursiveCopyAndAdd(Git git, File from, File toDir, String path, boolean useToDirAsDestination) throws GitAPIException, IOException {
        this.assertValid();
        String name = from.getName();
        String pattern = path + (path.length() > 0 ? "/" : "") + name;
        File toFile = new File(toDir, name);
        if (from.isDirectory()) {
            if (useToDirAsDestination) {
                toFile = toDir;
            }
            toFile.mkdirs();
            File[] files = from.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.recursiveCopyAndAdd(git, file, toFile, pattern, false);
                }
            }
        } else {
            Files.copy(from, toFile);
        }
        git.add().addFilepattern(pattern).call();
    }

    protected void recursiveAddLegacyProfileDirectoryFiles(Git git, File from, File toDir, String path) throws GitAPIException, IOException {
        this.assertValid();
        if (!from.isDirectory()) {
            throw new IllegalStateException("Should only be invoked on the profiles directory but was given file " + from);
        }
        String name = from.getName();
        String pattern = path + (path.length() > 0 ? "/" : "") + name;
        File[] profiles = from.listFiles();
        File toFile = new File(toDir, name);
        if (profiles != null) {
            for (File profileDir : profiles) {
                if (this.isProfileDirectory(profileDir)) {
                    String profileId = profileDir.getName();
                    String toProfileDirName = this.convertProfileIdToDirectory(profileId);
                    File toProfileDir = new File(toFile, toProfileDirName);
                    toProfileDir.mkdirs();
                    this.recursiveCopyAndAdd(git, profileDir, toProfileDir, pattern, true);
                    continue;
                }
                this.recursiveCopyAndAdd(git, profileDir, toFile, pattern, false);
            }
        }
        git.add().addFilepattern(pattern).call();
    }

    protected boolean isProfileDirectory(File profileDir) {
        String[] list;
        this.assertValid();
        if (profileDir.isDirectory() && (list = profileDir.list()) != null) {
            for (String file : list) {
                if (!file.endsWith(PROPERTIES_SUFFIX) && !file.endsWith(".mvel")) continue;
                return true;
            }
        }
        return false;
    }

    public String convertProfileIdToDirectory(String profileId) {
        this.assertValid();
        return profileId.replace('-', '/') + PROFILE_FOLDER_SUFFIX;
    }

    protected void pull() {
        this.assertValid();
        try {
            this.gitOperation(new GitOperation<Object>(){

                @Override
                public Object call(Git git, GitContext context) throws Exception {
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Failed to perform a pull " + e, (Throwable)e);
        }
    }

    protected void push() {
        this.assertValid();
        try {
            this.gitOperation(new GitOperation<Object>(){

                @Override
                public Object call(Git git, GitContext context) throws Exception {
                    context.requirePush();
                    return null;
                }
            }, false);
        }
        catch (Exception e) {
            LOG.warn("Failed to perform a pull " + e, (Throwable)e);
        }
    }

    protected void createOrCheckoutVersion(Git git, String version) throws GitAPIException {
        this.assertValid();
        this.addVersion(version);
        GitHelpers.createOrCheckoutBranch(git, version, this.remoteRef.get());
    }

    protected void checkoutVersion(Git git, String version) throws GitAPIException {
        this.assertValid();
        this.addVersion(version);
        GitHelpers.checkoutBranch(git, version);
    }

    protected void doAddFiles(Git git, File ... files) throws GitAPIException, IOException {
        this.assertValid();
        File rootDir = GitHelpers.getRootGitDirectory(git);
        for (File file : files) {
            String relativePath = this.getFilePattern(rootDir, file);
            git.add().addFilepattern(relativePath).call();
        }
    }

    protected void doRecursiveDeleteAndRemove(Git git, File file) throws IOException, GitAPIException {
        this.assertValid();
        File rootDir = GitHelpers.getRootGitDirectory(git);
        String relativePath = this.getFilePattern(rootDir, file);
        if (file.exists() && !relativePath.equals(".git")) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File child : files) {
                    this.doRecursiveDeleteAndRemove(git, child);
                }
            }
            file.delete();
            git.rm().addFilepattern(relativePath).call();
        }
    }

    protected byte[] doLoadFileConfiguration(File file) throws IOException {
        this.assertValid();
        if (file.isDirectory()) {
            StringBuilder buf = new StringBuilder();
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    String value = Files.toString(child);
                    buf.append(String.format("%s = %s\n", child.getName(), value));
                }
            }
            return buf.toString().getBytes();
        }
        if (file.exists() && file.isFile()) {
            return Files.readBytes(file);
        }
        return null;
    }

    protected Map<String, String> doLoadConfiguration(File file) throws IOException {
        this.assertValid();
        Properties props = new Properties();
        props.load(file);
        return props;
    }

    protected String getFilePattern(File rootDir, File file) throws IOException {
        this.assertValid();
        String relativePath = Files.getRelativePath(rootDir, file);
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    private boolean hasChanged(Git git, String before, String after) throws IOException, GitAPIException {
        if (GitDataStore.isCommitEqual(before, after)) {
            return false;
        }
        Repository db = git.getRepository();
        Object entries = git.diff().setOldTree(this.getTreeIterator(db, before)).setNewTree(this.getTreeIterator(db, after)).call();
        return entries.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractTreeIterator getTreeIterator(Repository db, String name) throws IOException {
        ObjectId id = db.resolve(name);
        if (id == null) {
            throw new IllegalArgumentException(name);
        }
        CanonicalTreeParser p = new CanonicalTreeParser();
        ObjectReader or = db.newObjectReader();
        try {
            p.reset(or, new RevWalk(db).parseTree(id));
            CanonicalTreeParser canonicalTreeParser = p;
            return canonicalTreeParser;
        }
        finally {
            or.release();
        }
    }

    private static boolean isCommitEqual(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public String getType() {
        return TYPE;
    }

    void addVersion(String version) {
        if (!MASTER_BRANCH.equals(version)) {
            this.versions.add(version);
        }
    }

    void removeVersion(String version) {
        this.versions.remove(version);
    }

    void bindGitService(GitService service) {
        this.gitService.bind((Object)service);
    }

    void unbindGitService(GitService service) {
        this.gitService.unbind((Object)service);
    }

    class GitDataStoreListener
    implements GitListener {
        GitDataStoreListener() {
        }

        @Override
        public void onRemoteUrlChanged(String updatedUrl) {
            String actualUrl;
            String string = actualUrl = GitDataStore.this.configuredUrl != null ? GitDataStore.this.configuredUrl : updatedUrl;
            if (GitDataStore.this.isValid()) {
                GitDataStore.this.threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (GitDataStore.this.isValid()) {
                            GitDataStore.this.gitOperation(new GitOperation<Void>(){

                                @Override
                                public Void call(Git git, GitContext context) throws Exception {
                                    Repository repository = git.getRepository();
                                    StoredConfig config = repository.getConfig();
                                    String currentUrl = config.getString("remote", "origin", "url");
                                    if (actualUrl != null && !actualUrl.equals(currentUrl)) {
                                        GitDataStore.this.remoteUrl = actualUrl;
                                        config.setString("remote", "origin", "url", actualUrl);
                                        config.setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
                                        config.save();
                                        GitDataStore.this.doPull(git, GitDataStore.this.getCredentialsProvider(), false);
                                        GitDataStore.this.doPush(git, context);
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                });
            }
        }

        @Override
        public void onReceivePack() {
            GitDataStore.this.assertValid();
            GitDataStore.this.clearCaches();
        }
    }
}

