/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import org.apache.sshd.agent.unix.AgentServerProxy;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.tomcat.jni.Socket;

public class AgentForwardedChannel
extends AbstractClientChannel
implements Runnable {
    private final long socket;

    public AgentForwardedChannel(long socket) {
        super("auth-agent@openssh.com");
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            int result;
            byte[] buf = new byte[1024];
            while ((result = Socket.recv((long)this.socket, (byte[])buf, (int)0, (int)buf.length)) != 70014) {
                if (result < 0) {
                    AgentServerProxy.throwException(result);
                }
                this.getOut().write(buf, 0, result);
                this.getOut().flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(false);
        }
    }

    public synchronized OpenFuture open() throws IOException {
        return this.internalOpen();
    }

    protected synchronized void doOpen() throws IOException {
        this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
    }

    protected synchronized void postClose() {
        Socket.close((long)this.socket);
        super.postClose();
    }

    protected synchronized void doWriteData(byte[] data, int off, int len) throws IOException {
        this.localWindow.consumeAndCheck(len);
        int result = Socket.send((long)this.socket, (byte[])data, (int)off, (int)len);
        if (result < 0) {
            AgentServerProxy.throwException(result);
        }
    }
}

