/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.IoUtils;

public abstract class AbstractClientChannel
extends AbstractChannel
implements ClientChannel {
    protected volatile boolean opened;
    protected final String type;
    protected InputStream in;
    protected OutputStream invertedIn;
    protected OutputStream out;
    protected InputStream invertedOut;
    protected OutputStream err;
    protected InputStream invertedErr;
    protected Integer exitStatus;
    protected String exitSignal;
    protected int openFailureReason;
    protected String openFailureMsg;
    protected OpenFuture openFuture;

    protected AbstractClientChannel(String type) {
        this.type = type;
    }

    public OutputStream getInvertedIn() {
        return this.invertedIn;
    }

    public InputStream getIn() {
        return this.in;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public InputStream getInvertedOut() {
        return this.invertedOut;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public InputStream getInvertedErr() {
        return this.invertedErr;
    }

    public OutputStream getErr() {
        return this.err;
    }

    public void setErr(OutputStream err) {
        this.err = err;
    }

    public CloseFuture close(final boolean immediately) {
        if (!this.closeFuture.isDone()) {
            if (this.opened) {
                super.close(immediately);
            } else if (this.openFuture != null) {
                if (immediately) {
                    this.openFuture.setException(new SshException("Channel closed"));
                    super.close(immediately);
                } else {
                    this.openFuture.addListener(new SshFutureListener<OpenFuture>(){

                        @Override
                        public void operationComplete(OpenFuture future) {
                            if (future.isOpened()) {
                                AbstractClientChannel.this.close(immediately);
                            } else {
                                AbstractClientChannel.this.close(true);
                            }
                        }
                    });
                }
            } else {
                this.closeFuture.setClosed();
                this.notifyStateChanged();
            }
        }
        return this.closeFuture;
    }

    protected void postClose() {
        IoUtils.closeQuietly(this.invertedIn, this.invertedOut, this.invertedErr, this.in, this.out, this.err);
        super.postClose();
    }

    public int waitFor(int mask, long timeout) {
        long t = 0L;
        Object object = this.lock;
        synchronized (object) {
            block5: while (true) {
                while (true) {
                    int cond = 0;
                    if (this.openFuture != null && this.openFuture.isOpened()) {
                        cond |= 0x80;
                    }
                    if (this.closeFuture.isClosed()) {
                        cond |= 0x12;
                    }
                    if (this.eof) {
                        cond |= 0x10;
                    }
                    if (this.exitStatus != null) {
                        cond |= 0x20;
                    }
                    if (this.exitSignal != null) {
                        cond |= 0x40;
                    }
                    if ((cond & mask) != 0) {
                        this.log.trace("WaitFor call returning on channel {}, mask={}, cond={}", new Object[]{this.id, mask, cond});
                        return cond;
                    }
                    if (timeout > 0L) {
                        if (t == 0L) {
                            t = System.currentTimeMillis() + timeout;
                        } else {
                            timeout = t - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                return cond |= 1;
                            }
                        }
                    }
                    try {
                        this.log.trace("Waiting for lock on channel {}, mask={}, cond={}", new Object[]{this.id, mask, cond});
                        if (timeout > 0L) {
                            this.lock.wait(timeout);
                        } else {
                            this.lock.wait();
                        }
                        this.log.trace("Lock notified on channel {}", (Object)this.id);
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    protected OpenFuture internalOpen() throws IOException {
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(this.lock);
        this.log.info("Send SSH_MSG_CHANNEL_OPEN on channel {}", (Object)this.id);
        Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN, 0);
        buffer.putString(this.type);
        buffer.putInt(this.id);
        buffer.putInt(this.localWindow.getSize());
        buffer.putInt(this.localWindow.getPacketSize());
        this.writePacket(buffer);
        return this.openFuture;
    }

    public OpenFuture open(int recipient, int rwsize, int rmpsize, Buffer buffer) {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOpenSuccess(int recipient, int rwsize, int rmpsize, Buffer buffer) {
        this.recipient = recipient;
        this.remoteWindow.init(rwsize, rmpsize);
        try {
            this.doOpen();
            this.opened = true;
            this.openFuture.setOpened();
        }
        catch (Exception e) {
            this.openFuture.setException(e);
            this.closeFuture.setClosed();
            this.postClose();
        }
        finally {
            this.notifyStateChanged();
        }
    }

    protected abstract void doOpen() throws IOException;

    public void handleOpenFailure(Buffer buffer) {
        int reason = buffer.getInt();
        String msg = buffer.getString();
        this.openFailureReason = reason;
        this.openFailureMsg = msg;
        this.openFuture.setException(new SshException(msg));
        this.closeFuture.setClosed();
        this.postClose();
        this.notifyStateChanged();
    }

    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        if (this.closing.get()) {
            return;
        }
        if (this.out == null) {
            throw new IllegalStateException("No output stream for channel");
        }
        this.out.write(data, off, len);
        this.out.flush();
        this.localWindow.consumeAndCheck(len);
    }

    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        if (this.err == null) {
            throw new IllegalStateException("No error stream for channel");
        }
        this.err.write(data, off, len);
        this.err.flush();
        this.localWindow.consumeAndCheck(len);
    }

    public void handleRequest(Buffer buffer) throws IOException {
        this.log.info("Received SSH_MSG_CHANNEL_REQUEST on channel {}", (Object)this.id);
        String req = buffer.getString();
        if ("exit-status".equals(req)) {
            buffer.getBoolean();
            this.exitStatus = buffer.getInt();
            this.notifyStateChanged();
        } else if ("exit-signal".equals(req)) {
            buffer.getBoolean();
            this.exitSignal = buffer.getString();
            this.notifyStateChanged();
        }
    }

    public Integer getExitStatus() {
        return this.exitStatus;
    }
}

