/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.IoUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceKeyPairProvider
extends AbstractKeyPairProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader cloader;
    private String[] resources;
    private PasswordFinder passwordFinder;

    public ResourceKeyPairProvider() {
        this.cloader = this.getClass().getClassLoader();
    }

    public ResourceKeyPairProvider(String[] resources) {
        this.cloader = this.getClass().getClassLoader();
        this.resources = resources;
    }

    public ResourceKeyPairProvider(String[] resources, PasswordFinder passwordFinder) {
        this.cloader = this.getClass().getClassLoader();
        this.resources = resources;
        this.passwordFinder = passwordFinder;
    }

    public ResourceKeyPairProvider(String[] resources, PasswordFinder passwordFinder, ClassLoader cloader) {
        this.cloader = cloader;
        this.resources = resources;
        this.passwordFinder = passwordFinder;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public PasswordFinder getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(PasswordFinder passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair[] loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>(this.resources.length);
        for (String resource : this.resources) {
            InputStream is;
            InputStreamReader isr;
            PEMReader r;
            block6: {
                r = null;
                isr = null;
                is = null;
                try {
                    is = this.cloader.getResourceAsStream(resource);
                    isr = new InputStreamReader(is);
                    r = new PEMReader((Reader)isr, this.passwordFinder);
                    Object o = r.readObject();
                    if (!(o instanceof KeyPair)) break block6;
                    keys.add((KeyPair)o);
                }
                catch (Exception e) {
                    try {
                        this.log.warn("Unable to read key", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(new Closeable[]{r, is, isr});
                        throw throwable;
                    }
                    IoUtils.closeQuietly(new Closeable[]{r, is, isr});
                    continue;
                }
            }
            IoUtils.closeQuietly(new Closeable[]{r, is, isr});
        }
        return keys.toArray(new KeyPair[keys.size()]);
    }
}

