/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.manager.support;

import aQute.lib.osgi.Jar;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import io.fabric8.fab.DependencyFilters;
import io.fabric8.fab.DependencyTreeResult;
import io.fabric8.fab.MavenResolverImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.jar.Attributes;
import org.fusesource.common.util.Filter;
import org.fusesource.common.util.Strings;
import org.fusesource.process.manager.InstallOptions;
import org.fusesource.process.manager.config.ProcessConfig;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.resolution.ArtifactResolutionException;

public class JarInstaller {
    MavenResolverImpl mavenResolver = new MavenResolverImpl();
    private final Executor executor;

    public JarInstaller(Executor executor) {
        this.executor = executor;
    }

    public void unpackJarProcess(ProcessConfig config, int id, File installDir, InstallOptions parameters) throws Exception {
        Filter optionalFilter = DependencyFilters.parseExcludeOptionalFilter((String)Strings.join(Arrays.asList(parameters.getOptionalDependencyPatterns()), (String)" "));
        Filter excludeFilter = DependencyFilters.parseExcludeFilter((String)Strings.join(Arrays.asList(parameters.getExcludeDependencyFilterPatterns()), (String)" "), (Filter)optionalFilter);
        DependencyTreeResult result = this.mavenResolver.collectDependencies(this.getArtifactFile(parameters.getUrl()), parameters.isOffline(), excludeFilter);
        DependencyNode mainJarDependency = result.getRootNode();
        File libDir = new File(installDir, "lib");
        libDir.mkdirs();
        File mainJar = this.getFile(mainJarDependency);
        if (mainJar == null) {
            System.out.println("Cannot find file for main jar " + mainJarDependency);
        } else {
            File newMain = new File(libDir, "main.jar");
            Files.copy((File)mainJar, (File)newMain);
            String mainClass = parameters.getMainClass();
            if (mainClass != null) {
                this.setMainClass(config, installDir, newMain, id, mainClass);
            }
        }
        this.copyDependencies(mainJarDependency, libDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getArtifactFile(URL url) throws IOException {
        File tmpFile = File.createTempFile("artifact", ".jar");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tmpFile);
            Resources.copy((URL)url, (OutputStream)fos);
        }
        catch (Exception ex) {
            try {
                Throwables.propagate((Throwable)ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fos);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)fos);
        }
        Closeables.closeQuietly((Closeable)fos);
        return tmpFile;
    }

    protected void setMainClass(ProcessConfig config, File installDir, File jarFile, int id, String mainClass) throws Exception {
        File tmpFile = File.createTempFile("fuse-process-" + id, ".jar");
        Files.copy((File)jarFile, (File)tmpFile);
        Jar jar = new Jar(tmpFile);
        Attributes attributes = jar.getManifest().getMainAttributes();
        attributes.putValue("Main-Class", mainClass);
        jar.write(jarFile);
    }

    protected void copyDependencies(DependencyNode dependency, File libDir) throws IOException, ArtifactResolutionException {
        List children = dependency.getChildren();
        if (children != null) {
            for (DependencyNode child : children) {
                File file = this.getFile(child);
                if (file == null) {
                    System.out.println("Cannot find file for dependent jar " + child);
                } else {
                    Files.copy((File)file, (File)new File(libDir, file.getName()));
                }
                this.copyDependencies(child, libDir);
            }
        }
    }

    protected File getFile(DependencyNode node) throws ArtifactResolutionException {
        Artifact artifact;
        Dependency dependency;
        if (node != null && (dependency = node.getDependency()) != null && (artifact = dependency.getArtifact()) != null) {
            File file = artifact.getFile();
            if (file == null) {
                return this.mavenResolver.resolveFile(artifact);
            }
            return file;
        }
        return null;
    }
}

