/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jaas;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.karaf.jaas.modules.properties.PropertiesBackingEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperBackingEngine
implements BackingEngine {
    public static final String USERS_NODE = "/fabric/authentication/users";
    private static final transient Logger LOGGER = LoggerFactory.getLogger(PropertiesBackingEngine.class);
    private Properties users;
    private EncryptionSupport encryptionSupport;

    public ZookeeperBackingEngine(Properties users) {
        this.users = users;
    }

    public ZookeeperBackingEngine(Properties users, EncryptionSupport encryptionSupport) {
        this.users = users;
        this.encryptionSupport = encryptionSupport;
    }

    public void addUser(String username, String password) {
        String userInfos;
        String[] infos = null;
        StringBuffer userInfoBuffer = new StringBuffer();
        String newPassword = password;
        if (this.encryptionSupport != null && this.encryptionSupport.getEncryption() != null) {
            newPassword = this.encryptionSupport.getEncryption().encryptPassword(password);
            if (this.encryptionSupport.getEncryptionPrefix() != null) {
                newPassword = this.encryptionSupport.getEncryptionPrefix() + newPassword;
            }
            if (this.encryptionSupport.getEncryptionSuffix() != null) {
                newPassword = newPassword + this.encryptionSupport.getEncryptionSuffix();
            }
        }
        if ((userInfos = (String)this.users.get(username)) != null && userInfos.length() > 0) {
            infos = userInfos.split(",");
            userInfoBuffer.append(newPassword);
            for (int i = 1; i < infos.length; ++i) {
                userInfoBuffer.append(",");
                userInfoBuffer.append(infos[i]);
            }
            String newUserInfo = userInfoBuffer.toString();
            this.users.put(username, newUserInfo);
        } else {
            this.users.put(username, newPassword);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot update users file,", (Throwable)ex);
        }
    }

    public void deleteUser(String username) {
        this.users.remove(username);
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot remove users file,", (Throwable)ex);
        }
    }

    public List<UserPrincipal> listUsers() {
        ArrayList<UserPrincipal> result = new ArrayList<UserPrincipal>();
        for (String userNames : this.users.keySet()) {
            UserPrincipal userPrincipal = new UserPrincipal(userNames);
            result.add(userPrincipal);
        }
        return result;
    }

    public List<RolePrincipal> listRoles(UserPrincipal user) {
        ArrayList<RolePrincipal> result = new ArrayList<RolePrincipal>();
        String userInfo = (String)this.users.get(user.getName());
        String[] infos = userInfo.split(",");
        for (int i = 1; i < infos.length; ++i) {
            result.add(new RolePrincipal(infos[i]));
        }
        return result;
    }

    public void addRole(String username, String role) {
        String userInfos = (String)this.users.get(username);
        if (userInfos != null) {
            String newUserInfos = userInfos + "," + role;
            this.users.put(username, newUserInfos);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot update users file,", (Throwable)ex);
        }
    }

    public void deleteRole(String username, String role) {
        String[] infos = null;
        StringBuffer userInfoBuffer = new StringBuffer();
        String userInfos = (String)this.users.get(username);
        if (userInfos != null && userInfos.length() > 0) {
            infos = userInfos.split(",");
            String password = infos[0];
            userInfoBuffer.append(password);
            for (int i = 1; i < infos.length; ++i) {
                if (infos[i] == null || infos[i].equals(role)) continue;
                userInfoBuffer.append(",");
                userInfoBuffer.append(infos[i]);
            }
            String newUserInfo = userInfoBuffer.toString();
            this.users.put(username, newUserInfo);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot update users file,", (Throwable)ex);
        }
    }
}

