/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.patch.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.fusesource.patch.impl.PatchData;
import org.fusesource.patch.impl.Utils;
import org.osgi.framework.Version;

public class Offline {
    private static final String OVERRIDE_RANGE = ";range=";
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    private final File karafBase;
    private final Logger logger;

    public Offline(File karafBase) {
        this(karafBase, new SysLogger());
    }

    public Offline(File karafBase, Logger logger) {
        this.karafBase = karafBase;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(File patchZip) throws IOException {
        ZipFile zipFile;
        block4: {
            zipFile = new ZipFile(patchZip);
            try {
                List<PatchData> patches = this.extractPatch(zipFile);
                if (patches.isEmpty()) {
                    this.log(2, "No patch to apply");
                    break block4;
                }
                for (PatchData data : patches) {
                    this.applyPatch(data, zipFile);
                }
            }
            catch (Throwable throwable) {
                Utils.close(zipFile);
                throw throwable;
            }
        }
        Utils.close(zipFile);
    }

    public void applyConfigChanges(PatchData patch) throws IOException {
        this.applyPatch(patch, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PatchData> extractPatch(ZipFile zipFile) throws IOException {
        ArrayList<PatchData> patches = new ArrayList<PatchData>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            String entryName;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".patch") || entryName.contains("/")) continue;
            InputStream fis = zipFile.getInputStream(entry);
            try {
                PatchData patch = PatchData.load(fis);
                patches.add(patch);
            }
            catch (Throwable throwable) {
                Utils.close(fis);
                throw throwable;
            }
            Utils.close(fis);
        }
        return patches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyPatch(PatchData patch, ZipFile zipFile) throws IOException {
        this.log(0, "Applying patch: " + patch.getId() + " / " + patch.getDescription());
        File startupFile = new File(this.karafBase, "etc/startup.properties");
        File overridesFile = new File(this.karafBase, "etc/overrides.properties");
        List<String> startup = Utils.readLines(new File(this.karafBase, "etc/startup.properties"));
        List<String> overrides = Utils.readLines(overridesFile);
        ArrayList<Artifact> toExtract = new ArrayList<Artifact>();
        ArrayList<Artifact> toDelete = new ArrayList<Artifact>();
        for (String bundle : patch.getBundles()) {
            String line;
            int i;
            VersionRange range;
            String override;
            Artifact artifact = Offline.mvnurlToArtifact(bundle, true);
            if (artifact == null) continue;
            Version oVer = VersionTable.getVersion(artifact.getVersion());
            String vr = patch.getVersionRange(bundle);
            if (vr != null && !vr.isEmpty()) {
                override = bundle + OVERRIDE_RANGE + vr;
                range = VersionRange.parseVersionRange(vr);
            } else {
                override = bundle;
                Version v1 = new Version(oVer.getMajor(), oVer.getMinor(), 0);
                Version v2 = new Version(oVer.getMajor(), oVer.getMinor() + 1, 0);
                range = new VersionRange(false, v1, v2, true);
            }
            boolean matching = false;
            boolean added = false;
            for (i = 0; i < overrides.size(); ++i) {
                line = overrides.get(i).trim();
                if (line.isEmpty() || line.startsWith("#")) continue;
                Artifact overrideArtifact = Offline.mvnurlToArtifact(line, true);
                if (overrideArtifact != null) {
                    Version ver = VersionTable.getVersion(overrideArtifact.getVersion());
                    if (!Artifact.isSameButVersion(artifact, overrideArtifact) || !range.contains(ver)) continue;
                    matching = true;
                    if (ver.compareTo(oVer) >= 0) continue;
                    overrides.set(i, override);
                    if (!added) {
                        this.log(0, "Replacing with artifact: " + override);
                        added = true;
                    }
                    toDelete.add(overrideArtifact);
                    toExtract.remove(overrideArtifact);
                    continue;
                }
                this.log(2, "Unable to convert to artifact: " + line);
            }
            if (!matching) {
                overrides.add(override);
                this.log(0, "Adding artifact: " + override);
            }
            for (i = 0; i < startup.size(); ++i) {
                Artifact startupArtifact;
                int index;
                String mvnUrl;
                line = startup.get(i).trim();
                if (line.isEmpty() || line.startsWith("#") || (mvnUrl = this.pathToMvnurl(line.substring(0, index = line.indexOf(61)))) == null || (startupArtifact = Offline.mvnurlToArtifact(mvnUrl, true)) == null) continue;
                Version ver = VersionTable.getVersion(startupArtifact.getVersion());
                if (!Artifact.isSameButVersion(artifact, startupArtifact) || !range.contains(ver)) continue;
                matching = true;
                if (ver.compareTo(oVer) >= 0) continue;
                line = artifact.getPath() + line.substring(index);
                startup.set(i, line);
                this.log(0, "Overwriting startup.properties with: " + artifact);
                added = true;
            }
            if (matching && !added) continue;
            toExtract.add(artifact);
        }
        if (zipFile != null) {
            for (Artifact artifact : toExtract) {
                this.log(0, "Extracting artifact: " + artifact);
                ZipEntry entry = zipFile.getEntry("repository/" + artifact.getPath());
                if (entry == null) {
                    this.log(3, "Could not find artifact in patch zip: " + artifact);
                    continue;
                }
                File f = new File(this.karafBase, "system/" + artifact.getPath());
                if (f.isFile()) continue;
                f.getParentFile().mkdirs();
                InputStream fis = zipFile.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(f);
                try {
                    Utils.copy(fis, fos);
                }
                catch (Throwable throwable) {
                    Utils.close(fis, fos);
                    throw throwable;
                }
                Utils.close(fis, fos);
            }
            for (Artifact artifact : toDelete) {
                String fileName = artifact.getPath();
                File file = new File(this.karafBase, "system/" + fileName);
                if (file.exists()) {
                    this.log(0, "Removing old artifact " + artifact);
                    file.delete();
                    continue;
                }
                this.log(2, "Could not find: " + file);
            }
        }
        overrides = new ArrayList<String>(new HashSet<String>(overrides));
        Collections.sort(overrides);
        Utils.writeLines(overridesFile, overrides);
        Utils.writeLines(startupFile, startup);
    }

    protected void log(int level, String message) {
        this.logger.log(level, message);
    }

    protected String pathToMvnurl(String path) {
        String[] p = path.split("/");
        if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
            String artifactId = p[p.length - 3];
            String version = p[p.length - 2];
            String artifactIdVersion = artifactId + "-" + version;
            StringBuffer sb = new StringBuffer();
            String classifier = p[p.length - 1].charAt(artifactIdVersion.length()) == '-' ? p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46)) : null;
            String type = p[p.length - 1].substring(p[p.length - 1].lastIndexOf(46) + 1);
            sb.append("mvn:");
            for (int j = 0; j < p.length - 3; ++j) {
                if (j > 0) {
                    sb.append('.');
                }
                sb.append(p[j]);
            }
            sb.append('/').append(artifactId).append('/').append(version);
            if (!"jar".equals(type) || classifier != null) {
                sb.append('/');
                if (!"jar".equals(type)) {
                    sb.append(type);
                }
                if (classifier != null) {
                    sb.append('/').append(classifier);
                }
            }
            return sb.toString();
        }
        return null;
    }

    static Artifact mvnurlToArtifact(String resourceLocation, boolean skipNonMavenProtocols) {
        String[] parts;
        int index3;
        int index = (resourceLocation = resourceLocation.replace("\r\n", "").replace("\n", "").replace(" ", "").replace("\t", "")).indexOf("mvn:");
        if (index < 0) {
            if (skipNonMavenProtocols) {
                return null;
            }
            throw new IllegalArgumentException("Resource URL is not a maven URL: " + resourceLocation);
        }
        resourceLocation = resourceLocation.substring(index + "mvn:".length());
        int index1 = resourceLocation.indexOf(63);
        int index2 = resourceLocation.indexOf(35);
        int endIndex = -1;
        if (index1 > 0) {
            endIndex = index2 > 0 ? Math.min(index1, index2) : index1;
        } else if (index2 > 0) {
            endIndex = index2;
        }
        if (endIndex >= 0) {
            resourceLocation = resourceLocation.substring(0, endIndex);
        }
        if ((index3 = resourceLocation.indexOf(36)) > 0) {
            resourceLocation = resourceLocation.substring(0, index3);
        }
        if ((parts = resourceLocation.split("/")).length > 2) {
            String groupId = parts[0];
            String artifactId = parts[1];
            String version = parts[2];
            String type = "jar";
            String classifier = null;
            if (parts.length > 3) {
                type = parts[3];
                if (parts.length > 4) {
                    classifier = parts[4];
                }
            }
            return new Artifact(groupId, artifactId, version, type, classifier);
        }
        throw new IllegalArgumentException("Bad maven url: " + resourceLocation);
    }

    public static class Artifact {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String type;
        private final String classifier;

        public Artifact(String groupId, String artifactId, String version, String type, String classifier) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.type = type;
            this.classifier = classifier;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public boolean hasClassifier() {
            return this.classifier != null;
        }

        public String getPath() {
            return this.groupId.replace('.', '/') + '/' + this.artifactId + '/' + this.version + '/' + this.artifactId + (this.classifier != null ? "-" + this.classifier : "") + '-' + this.version + '.' + this.type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.groupId).append(":").append(this.artifactId).append(":").append(this.version);
            if (!"jar".equals(this.type) || this.classifier != null) {
                sb.append(":").append(this.type);
                if (this.classifier != null) {
                    sb.append(":").append(this.classifier);
                }
            }
            return sb.toString();
        }

        public static boolean isSameButVersion(Artifact a1, Artifact a2) {
            return a1.getGroupId().equals(a2.getGroupId()) && a1.getArtifactId().equals(a2.getArtifactId()) && a1.hasClassifier() == a2.hasClassifier() && (!a1.hasClassifier() || a1.getClassifier().equals(a2.getClassifier())) && a1.getType().equals(a2.getType());
        }
    }

    public static class SysLogger
    implements Logger {
        @Override
        public void log(int level, String message) {
            switch (level) {
                case 0: {
                    System.out.println("DEBUG: " + message);
                    break;
                }
                case 1: {
                    System.out.println("INFO:  " + message);
                    break;
                }
                case 2: {
                    System.out.println("WARN:  " + message);
                    break;
                }
                case 3: {
                    System.out.println("ERROR: " + message);
                }
            }
        }
    }

    public static interface Logger {
        public void log(int var1, String var2);
    }
}

