/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.patch.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;

public class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
            outputStream.flush();
        }
        catch (Throwable throwable) {
            Utils.close(inputStream, outputStream);
            throw throwable;
        }
        Utils.close(inputStream, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader reader, Writer writer) throws IOException {
        try {
            int len;
            char[] buffer = new char[8192];
            while ((len = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, len);
            }
            writer.flush();
        }
        catch (Throwable throwable) {
            Utils.close(reader, writer);
            throw throwable;
        }
        Utils.close(reader, writer);
    }

    public static void close(ZipFile ... closeables) {
        for (ZipFile c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(File file) throws IOException {
        String string;
        if (!file.isFile()) {
            return null;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        StringWriter w = new StringWriter();
        try {
            Utils.copy(r, w);
            string = w.toString();
        }
        catch (Throwable throwable) {
            Utils.close(r, w);
            throw throwable;
        }
        Utils.close(r, w);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFully(File file, String content) throws IOException {
        if (content == null) {
            file.delete();
        }
        StringReader r = new StringReader(content);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        try {
            Utils.copy(r, w);
        }
        catch (Throwable throwable) {
            Utils.close(r, w);
            throw throwable;
        }
        Utils.close(r, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file) throws IOException {
        ArrayList<String> overrides = new ArrayList<String>();
        if (file.exists()) {
            FileInputStream is = new FileInputStream(file);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    overrides.add(line);
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return overrides;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, List<String> lines) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
            for (String over : lines) {
                writer.write(over);
                writer.newLine();
            }
            writer.close();
        }
        finally {
            ((OutputStream)os).close();
        }
    }
}

