/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.storage;

import java.text.SimpleDateFormat;
import java.util.Date;

public class InsightUtils {
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");

    public static String formatDate(long timestamp) {
        return simpleDateFormat.format(new Date(timestamp));
    }

    public static void quote(String string, StringBuilder w) {
        if (string == null || string.length() == 0) {
            w.append("\"\"");
            return;
        }
        char c = '\u0000';
        int len = string.length();
        w.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.append('\\');
                    w.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        w.append('\\');
                    }
                    w.append(c);
                    continue block9;
                }
                case '\b': {
                    w.append("\\b");
                    continue block9;
                }
                case '\t': {
                    w.append("\\t");
                    continue block9;
                }
                case '\n': {
                    w.append("\\n");
                    continue block9;
                }
                case '\f': {
                    w.append("\\f");
                    continue block9;
                }
                case '\r': {
                    w.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String hhhh = "000" + Integer.toHexString(c);
                        w.append("\\u" + hhhh.substring(hhhh.length() - 4));
                        continue block9;
                    }
                    w.append(c);
                }
            }
        }
        w.append('\"');
    }
}

