/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.features;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.internal.ProfileImpl;
import io.fabric8.internal.ProfileOverlayImpl;
import io.fabric8.utils.features.FeatureUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.FeatureValidationUtil;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.features", description="Fabric Features Service", immediate=true)
@Service(value={FeaturesService.class})
public final class FabricFeaturesServiceImpl
extends AbstractComponent
implements FeaturesService,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesService.class);
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @GuardedBy(value="this")
    private final Set<Repository> repositories = new HashSet<Repository>();
    @GuardedBy(value="this")
    private final Set<Feature> allfeatures = new HashSet<Feature>();
    @GuardedBy(value="this")
    private final Set<Feature> installed = new HashSet<Feature>();

    @Activate
    void activate() {
        ((FabricService)this.fabricService.get()).trackConfiguration((Runnable)this);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        ((FabricService)this.fabricService.get()).untrackConfiguration((Runnable)this);
    }

    @Override
    public synchronized void run() {
        this.assertValid();
        this.repositories.clear();
        this.allfeatures.clear();
        this.installed.clear();
    }

    @Override
    public void validateRepository(URI uri) throws Exception {
        this.assertValid();
        FeatureValidationUtil.validate(uri);
    }

    @Override
    public void addRepository(URI uri) throws Exception {
        this.unsupportedAddRepository(uri);
    }

    @Override
    public void addRepository(URI uri, boolean b) throws Exception {
        this.unsupportedAddRepository(uri);
    }

    private void unsupportedAddRepository(URI uri) {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --repositories %s target-profile instead. See fabric:profile-edit --help for more information.", uri.toString()));
    }

    @Override
    public void removeRepository(URI uri) throws Exception {
        this.unsupportedRemoveRepository(uri);
    }

    @Override
    public void removeRepository(URI uri, boolean b) throws Exception {
        this.unsupportedRemoveRepository(uri);
    }

    private void unsupportedRemoveRepository(URI uri) {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --delete --repositories %s target-profile instead. See fabric:profile-edit --help for more information.", uri.toString()));
    }

    @Override
    public void restoreRepository(URI uri) throws Exception {
    }

    @Override
    public synchronized Repository[] listRepositories() {
        this.assertValid();
        if (this.repositories.isEmpty()) {
            LinkedHashSet<String> repositoryUris = new LinkedHashSet<String>();
            for (String uri : this.getAllProfilesOverlay().getRepositories()) {
                repositoryUris.add(uri);
                this.addRepositoryUri(uri, repositoryUris);
            }
            for (String uri : repositoryUris) {
                try {
                    RepositoryImpl r = new RepositoryImpl(new URI(uri));
                    r.load();
                    this.repositories.add(r);
                }
                catch (URISyntaxException e) {
                    LOGGER.debug("Error while adding repository with uri {}.", (Object)uri);
                }
                catch (IOException e) {
                    LOGGER.debug("Error while loading repository with uri {}.", (Object)uri);
                }
            }
        }
        return this.repositories.toArray(new Repository[this.repositories.size()]);
    }

    @Override
    public void installFeature(String s) throws Exception {
        this.unsupportedInstallFeature(s);
    }

    @Override
    public void installFeature(String s, EnumSet<FeaturesService.Option> options) throws Exception {
        this.unsupportedInstallFeature(s);
    }

    @Override
    public void installFeature(String s, String s2) throws Exception {
        String featureName = s;
        if (s2 != null && s2.equals("0.0.0")) {
            featureName = s + "/" + s2;
        }
        this.unsupportedInstallFeature(featureName);
    }

    @Override
    public void installFeature(String s, String s2, EnumSet<FeaturesService.Option> options) throws Exception {
        String featureName = s;
        if (s2 != null && s2.equals("0.0.0")) {
            featureName = s + "/" + s2;
        }
        this.unsupportedInstallFeature(featureName);
    }

    @Override
    public void installFeature(Feature feature, EnumSet<FeaturesService.Option> options) throws Exception {
        this.unsupportedInstallFeature(feature.getName());
    }

    @Override
    public void installFeatures(Set<Feature> features, EnumSet<FeaturesService.Option> options) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (Feature feature : features) {
            sb.append("--feature ").append(feature.getName());
        }
        this.unsupportedInstallFeature(sb.toString());
    }

    private void unsupportedInstallFeature(String s) {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --features %s target-profile instead. See fabric:profile-edit --help for more information.", s));
    }

    @Override
    public void uninstallFeature(String s) throws Exception {
        this.unsupportedUninstallFeature(s);
    }

    @Override
    public void uninstallFeature(String s, String s2) throws Exception {
        String featureName = s;
        if (s2 != null && s2.equals("0.0.0")) {
            featureName = s + "/" + s2;
        }
        this.unsupportedUninstallFeature(featureName);
    }

    private void unsupportedUninstallFeature(String s) {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --delete --features %s target-profile instead. See fabric:profile-edit --help for more information.", s));
    }

    @Override
    public synchronized Feature[] listFeatures() throws Exception {
        this.assertValid();
        if (this.allfeatures.isEmpty()) {
            Repository[] repositories;
            for (Repository repository : repositories = this.listRepositories()) {
                try {
                    for (Feature feature : repository.getFeatures()) {
                        if (this.allfeatures.contains(feature)) continue;
                        this.allfeatures.add(feature);
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Could not load features from %s.", (Object)repository.getURI());
                }
            }
        }
        return this.allfeatures.toArray(new Feature[this.allfeatures.size()]);
    }

    @Override
    public synchronized Feature[] listInstalledFeatures() {
        this.assertValid();
        if (this.installed.isEmpty()) {
            try {
                Map<String, Map<String, Feature>> allFeatures = this.getFeatures(this.listProfileRepositories());
                for (String featureName : this.getAllProfilesOverlay().getFeatures()) {
                    try {
                        Feature f;
                        if (featureName.contains("/")) {
                            String[] parts = featureName.split("/");
                            String name = parts[0];
                            String version = parts[1];
                            f = allFeatures.get(name).get(version);
                        } else {
                            TreeMap versionMap = (TreeMap)allFeatures.get(featureName);
                            f = (Feature)versionMap.lastEntry().getValue();
                        }
                        this.addFeatures(f, this.installed);
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Error while adding {} to the features list");
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error retrieveing features.", (Throwable)e);
            }
        }
        return this.installed.toArray(new Feature[this.installed.size()]);
    }

    @Override
    public synchronized boolean isInstalled(Feature feature) {
        this.assertValid();
        if (this.installed.isEmpty()) {
            this.listInstalledFeatures();
        }
        return this.installed.contains(feature);
    }

    @Override
    public Feature getFeature(String name) throws Exception {
        Feature[] features;
        this.assertValid();
        for (Feature feature : features = this.listFeatures()) {
            if (!name.equals(feature.getName())) continue;
            return feature;
        }
        return null;
    }

    @Override
    public Feature getFeature(String name, String version) throws Exception {
        Feature[] features;
        this.assertValid();
        for (Feature feature : features = this.listFeatures()) {
            if (!name.equals(feature.getName()) || !version.equals(feature.getVersion())) continue;
            return feature;
        }
        return null;
    }

    private Map<String, Map<String, Feature>> getFeatures(Repository[] repositories) throws Exception {
        HashMap<String, Map<String, Feature>> features = new HashMap<String, Map<String, Feature>>();
        for (Repository repo : repositories) {
            try {
                for (Feature f : repo.getFeatures()) {
                    if (features.get(f.getName()) == null) {
                        TreeMap<String, Feature> versionMap = new TreeMap<String, Feature>();
                        versionMap.put(f.getVersion(), f);
                        features.put(f.getName(), versionMap);
                        continue;
                    }
                    ((Map)features.get(f.getName())).put(f.getVersion(), f);
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Could not load features from %s.", (Object)repo.getURI());
            }
        }
        return features;
    }

    private Repository[] listProfileRepositories() {
        LinkedHashSet<String> repositoryUris = new LinkedHashSet<String>();
        LinkedHashSet<RepositoryImpl> repositories = new LinkedHashSet<RepositoryImpl>();
        Container container = ((FabricService)this.fabricService.get()).getCurrentContainer();
        HashSet<Profile> profilesWithParents = new HashSet<Profile>();
        Profile[] profiles = container.getProfiles();
        if (profiles != null) {
            for (Profile profile : profiles) {
                this.addProfiles(profile, profilesWithParents);
            }
            for (Profile profile : profilesWithParents) {
                if (profile.getRepositories() == null) continue;
                for (String uri : profile.getRepositories()) {
                    repositoryUris.add(uri);
                    this.addRepositoryUri(uri, repositoryUris);
                }
            }
        }
        for (String uri : repositoryUris) {
            try {
                repositories.add(new RepositoryImpl(new URI(uri)));
            }
            catch (URISyntaxException e) {
                LOGGER.debug("Error while adding repository with uri {}.", (Object)uri);
            }
        }
        return repositories.toArray(new Repository[repositories.size()]);
    }

    private void addRepositoryUri(String uri, Set<String> repositoryUris) {
        if (repositoryUris.contains(uri)) {
            return;
        }
        repositoryUris.add(uri);
        try {
            RepositoryImpl repository = new RepositoryImpl(new URI(uri));
            repository.load();
            URI[] internalUris = repository.getRepositories();
            if (internalUris != null) {
                for (URI u : internalUris) {
                    this.addRepositoryUri(u.toString(), repositoryUris);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error while adding internal repositories of {}.", (Object)uri);
        }
    }

    private void addProfiles(Profile profile, Set<Profile> profiles) {
        if (profiles.contains(profile)) {
            return;
        }
        profiles.add(profile);
        for (Profile parent : profile.getParents()) {
            this.addProfiles(parent, profiles);
        }
    }

    private void addFeatures(Feature feature, Set<Feature> features) {
        if (features.contains(feature)) {
            return;
        }
        features.add(feature);
        for (Feature dependency : feature.getDependencies()) {
            this.addFeatures(FeatureUtils.search(dependency.getName(), dependency.getVersion(), this.repositories), features);
        }
    }

    private Profile getAllProfilesOverlay() {
        FabricService service = (FabricService)this.fabricService.get();
        Container container = service.getCurrentContainer();
        Version version = container.getVersion();
        VersionProfile p = new VersionProfile(version);
        return new ProfileOverlayImpl((Profile)p, true, service.getDataStore(), service.getEnvironment());
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    private class VersionProfile
    extends ProfileImpl {
        private VersionProfile(Version version) {
            super("#version-" + version.getId(), version.getId(), (FabricService)FabricFeaturesServiceImpl.this.fabricService.get());
        }

        public Profile[] getParents() {
            return ((FabricService)FabricFeaturesServiceImpl.this.fabricService.get()).getVersion(this.getVersion()).getProfiles();
        }

        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        public void setAttribute(String key, String value) {
            throw new UnsupportedOperationException();
        }

        public Container[] getAssociatedContainers() {
            return new Container[0];
        }

        public Map<String, byte[]> getFileConfigurations() {
            return Collections.emptyMap();
        }

        public void setFileConfigurations(Map<String, byte[]> configurations) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Map<String, String>> getConfigurations() {
            return Collections.emptyMap();
        }

        public void setConfigurations(Map<String, Map<String, String>> configurations) {
            throw new UnsupportedOperationException();
        }

        public void delete() {
            throw new UnsupportedOperationException();
        }

        public String getProfileHash() {
            throw new UnsupportedOperationException();
        }
    }
}

