/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.shell.ShellUtils;
import java.net.URL;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="patch-apply", scope="fabric", description="Apply the given patch")
public class PatchApply
extends FabricCommand {
    @Option(name="-u", aliases={"--username"}, description="Remote user name", required=false, multiValued=false)
    private String username;
    @Option(name="-p", aliases={"--password"}, description="Remote user password", required=false, multiValued=false)
    private String password;
    @Option(name="--version", description="Only apply upgrades for the given version")
    private String version;
    @Argument
    private URL patch;

    protected Object doExecute() throws Exception {
        Version v = null;
        if (this.version != null && !this.version.isEmpty()) {
            v = this.fabricService.getVersion(this.version);
        }
        this.username = this.username != null && !this.username.isEmpty() ? this.username : ShellUtils.retrieveFabricUser(this.session);
        this.password = this.password != null ? this.password : ShellUtils.retrieveFabricUserPassword(this.session);
        this.fabricService.getPatchService().applyPatch(v, this.patch, this.username, this.password);
        return null;
    }
}

