/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.Container;
import io.fabric8.api.NameValidator;
import io.fabric8.api.Profile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Containers {
    public static List<Container> containersForProfile(Container[] containers, String profileId) {
        ArrayList<Container> answer = new ArrayList<Container>();
        if (profileId != null) {
            for (Container c : containers) {
                if (!Containers.containerHasProfile(c, profileId)) continue;
                answer.add(c);
            }
        }
        return answer;
    }

    public static boolean containerHasProfile(Container container, Profile profile) {
        return Containers.containerHasProfile(container, profile.getId());
    }

    public static boolean containerHasProfile(Container container, String profileId) {
        for (Profile p : container.getProfiles()) {
            if (!profileId.equals(p.getId())) continue;
            return true;
        }
        return false;
    }

    public static List<Profile> overlayProfiles(Container container) {
        LinkedHashSet<Profile> set = new LinkedHashSet<Profile>();
        Profile[] profiles = container.getProfiles();
        Containers.recursiveAddProfiles(set, profiles);
        return new ArrayList<Profile>(set);
    }

    protected static void recursiveAddProfiles(Set<Profile> set, Profile[] profiles) {
        for (Profile profile : profiles) {
            set.add(profile);
            Profile[] parents = profile.getParents();
            if (parents == null) continue;
            Containers.recursiveAddProfiles(set, parents);
        }
    }

    public static String createContainerName(Container[] containers, String profile, String scheme, NameValidator nameValidator) {
        String name;
        HashMap<String, Container> map = new HashMap<String, Container>();
        for (Container container : containers) {
            map.put(container.getId(), container);
        }
        String namePrefix = profile;
        String postFix = "." + scheme;
        if (namePrefix.endsWith(postFix)) {
            namePrefix = namePrefix.substring(0, namePrefix.length() - postFix.length());
        }
        namePrefix = Containers.filterOutNonAlphaNumerics(namePrefix);
        List<Container> profileContainers = Containers.containersForProfile(containers, profile);
        int idx = profileContainers.size();
        while (map.containsKey(name = namePrefix + Integer.toString(++idx)) || !nameValidator.isValid(name)) {
        }
        return name;
    }

    private static String filterOutNonAlphaNumerics(String text) {
        StringBuilder builder = new StringBuilder();
        int size = text.length();
        for (int i = 0; i < size; ++i) {
            char ch = text.charAt(i);
            if (!Character.isLetterOrDigit(ch)) continue;
            builder.append(ch);
        }
        return builder.toString();
    }
}

