/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.rest.RestStatus;

public class ElasticSearchException
extends RuntimeException {
    public ElasticSearchException(String msg) {
        super(msg);
    }

    public ElasticSearchException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public RestStatus status() {
        Throwable cause = this.unwrapCause();
        if (cause == this) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        if (cause instanceof ElasticSearchException) {
            return ((ElasticSearchException)cause).status();
        }
        if (cause instanceof IllegalArgumentException) {
            return RestStatus.BAD_REQUEST;
        }
        return RestStatus.INTERNAL_SERVER_ERROR;
    }

    public Throwable unwrapCause() {
        return ExceptionsHelper.unwrapCause(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof ElasticSearchException) {
                sb.append(((ElasticSearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return super.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public Throwable getMostSpecificCause() {
        Throwable rootCause = this.getRootCause();
        return rootCause != null ? rootCause : this;
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause == this) {
            return false;
        }
        if (cause instanceof ElasticSearchException) {
            return ((ElasticSearchException)cause).contains(exType);
        }
        while (cause != null) {
            if (exType.isInstance(cause)) {
                return true;
            }
            if (cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }
}

