/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class UpdateSettingsRequest
extends MasterNodeOperationRequest<UpdateSettingsRequest> {
    private String[] indices;
    private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;

    UpdateSettingsRequest() {
    }

    public UpdateSettingsRequest(String ... indices) {
        this.indices = indices;
    }

    public UpdateSettingsRequest(Settings settings, String ... indices) {
        this.indices = indices;
        this.settings = settings;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.settings.getAsMap().isEmpty()) {
            validationException = ValidateActions.addValidationError("no settings to update", validationException);
        }
        return validationException;
    }

    String[] indices() {
        return this.indices;
    }

    Settings settings() {
        return this.settings;
    }

    public UpdateSettingsRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public UpdateSettingsRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public UpdateSettingsRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public UpdateSettingsRequest settings(String source) {
        this.settings = ImmutableSettings.settingsBuilder().loadFromSource(source).build();
        return this;
    }

    public UpdateSettingsRequest settings(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.settings = ImmutableSettings.readSettingsFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        ImmutableSettings.writeSettingsToStream(this.settings, out);
    }
}

