/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;

public class DiscoveryNodeFilters {
    private final Map<String, String[]> filters;
    private final OpType opType;

    public static DiscoveryNodeFilters buildFromSettings(OpType opType, String prefix, Settings settings) {
        return DiscoveryNodeFilters.buildFromKeyValue(opType, settings.getByPrefix(prefix).getAsMap());
    }

    public static DiscoveryNodeFilters buildFromKeyValue(OpType opType, Map<String, String> filters) {
        HashMap<String, String[]> bFilters = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            String[] values = Strings.splitStringByCommaToArray(entry.getValue());
            if (values.length <= 0) continue;
            bFilters.put(entry.getKey(), values);
        }
        if (bFilters.isEmpty()) {
            return null;
        }
        return new DiscoveryNodeFilters(opType, bFilters);
    }

    DiscoveryNodeFilters(OpType opType, Map<String, String[]> filters) {
        this.opType = opType;
        this.filters = filters;
    }

    public boolean match(DiscoveryNode node) {
        for (Map.Entry<String, String[]> entry : this.filters.entrySet()) {
            InetSocketTransportAddress inetAddress;
            String attr = entry.getKey();
            String[] values = entry.getValue();
            if ("_ip".equals(attr)) {
                if (!(node.address() instanceof InetSocketTransportAddress)) {
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                inetAddress = (InetSocketTransportAddress)node.address();
                for (String value : values) {
                    if (Regex.simpleMatch(value, inetAddress.address().getAddress().getHostAddress())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_host".equals(attr)) {
                if (!(node.address() instanceof InetSocketTransportAddress)) {
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                inetAddress = (InetSocketTransportAddress)node.address();
                for (String value : values) {
                    if (Regex.simpleMatch(value, inetAddress.address().getHostName())) {
                        if (this.opType == OpType.OR) {
                            return true;
                        }
                    } else if (this.opType == OpType.AND) {
                        return false;
                    }
                    if (Regex.simpleMatch(value, inetAddress.address().getAddress().getHostAddress())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_id".equals(attr)) {
                for (String value : values) {
                    if (node.id().equals(value)) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_name".equals(attr) || "name".equals(attr)) {
                for (String value : values) {
                    if (Regex.simpleMatch(value, node.name())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            String nodeAttributeValue = node.attributes().get(attr);
            if (nodeAttributeValue == null) {
                if (this.opType != OpType.AND) continue;
                return false;
            }
            for (String value : values) {
                if (Regex.simpleMatch(value, nodeAttributeValue)) {
                    if (this.opType != OpType.OR) continue;
                    return true;
                }
                if (this.opType != OpType.AND) continue;
                return false;
            }
        }
        return this.opType != OpType.OR;
    }

    public static enum OpType {
        AND,
        OR;

    }
}

