/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.yaml;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import org.elasticsearch.common.jackson.core.Base64Variant;
import org.elasticsearch.common.jackson.core.FormatSchema;
import org.elasticsearch.common.jackson.core.JsonGenerationException;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.PrettyPrinter;
import org.elasticsearch.common.jackson.core.SerializableString;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.base.GeneratorBase;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.dataformat.yaml.ModuleVersion;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.DumperOptions;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.emitter.Emitter;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.DocumentEndEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.DocumentStartEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.ImplicitTuple;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.MappingEndEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.MappingStartEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.ScalarEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.SequenceEndEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.SequenceStartEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.StreamEndEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.StreamStartEvent;

public class YAMLGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected final IOContext _ioContext;
    protected int _yamlFeatures;
    protected Writer _writer;
    protected DumperOptions _outputOptions;
    private static final Character STYLE_NAME = null;
    private static final Character STYLE_SCALAR = null;
    private static final Character STYLE_STRING = Character.valueOf('\"');
    private static final Character STYLE_BASE64 = Character.valueOf('\"');
    protected Emitter _emitter;
    private static final ImplicitTuple DEFAULT_IMPLICIT = new ImplicitTuple(true, true);

    public YAMLGenerator(IOContext ctxt, int jsonFeatures, int yamlFeatures, ObjectCodec codec, Writer out, DumperOptions outputOptions, Integer[] version) throws IOException {
        super(jsonFeatures, codec);
        this._ioContext = ctxt;
        this._yamlFeatures = yamlFeatures;
        this._writer = out;
        this._emitter = new Emitter(this._writer, outputOptions);
        this._outputOptions = outputOptions;
        this._emitter.emit(new StreamStartEvent(null, null));
        this._emitter.emit(new DocumentStartEvent(null, null, false, version, Collections.<String, String>emptyMap()));
    }

    @Override
    public Version version() {
        return ModuleVersion.instance.version();
    }

    @Override
    public YAMLGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public YAMLGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._writer;
    }

    @Override
    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    @Override
    public final void writeFieldName(String name) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(name) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name);
    }

    @Override
    public final void writeFieldName(SerializableString name) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(name.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name.getValue());
    }

    @Override
    public final void writeStringField(String fieldName, String value) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(fieldName);
        this.writeString(value);
    }

    private final void _writeFieldName(String name) throws IOException, JsonGenerationException {
        this._writeScalar(name, "string", STYLE_NAME);
    }

    public YAMLGenerator enable(Feature f) {
        this._yamlFeatures |= f.getMask();
        return this;
    }

    public YAMLGenerator disable(Feature f) {
        this._yamlFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._yamlFeatures & f.getMask()) != 0;
    }

    public YAMLGenerator configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    @Override
    public final void flush() throws IOException {
        this._writer.flush();
    }

    @Override
    public void close() throws IOException {
        this._emitter.emit(new DocumentEndEvent(null, null, false));
        this._emitter.emit(new StreamEndEvent(null, null));
        super.close();
        this._writer.close();
    }

    @Override
    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        Boolean style = this._outputOptions.getDefaultFlowStyle().getStyleBoolean();
        this._emitter.emit(new SequenceStartEvent(null, null, true, null, null, style));
    }

    @Override
    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this._emitter.emit(new SequenceEndEvent(null, null));
    }

    @Override
    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        Boolean style = this._outputOptions.getDefaultFlowStyle().getStyleBoolean();
        this._emitter.emit(new MappingStartEvent(null, null, true, null, null, style));
    }

    @Override
    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this._emitter.emit(new MappingEndEvent(null, null));
    }

    @Override
    public void writeString(String text) throws IOException, JsonGenerationException {
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        this._writeScalar(text, "string", STYLE_STRING);
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.writeString(new String(text, offset, len));
    }

    @Override
    public final void writeString(SerializableString sstr) throws IOException, JsonGenerationException {
        this.writeString(sstr.toString());
    }

    @Override
    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public final void writeUTF8String(byte[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.writeString(new String(text, offset, len, "UTF-8"));
    }

    @Override
    public void writeRaw(String text) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String text) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (offset > 0 || offset + len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        String encoded = b64variant.encode(data);
        this._writeScalar(encoded, "byte[]", STYLE_BASE64);
    }

    @Override
    public void writeBoolean(boolean state) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        this._writeScalar(state ? "true" : "false", "bool", STYLE_SCALAR);
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writeScalar("null", "object", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(int i) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(i), "int", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(l), "long", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(BigInteger v) throws IOException, JsonGenerationException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(v.toString()), "java.math.BigInteger", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(d), "double", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(f), "float", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(BigDecimal dec) throws IOException, JsonGenerationException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(dec.toString(), "java.math.BigDecimal", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException, UnsupportedOperationException {
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(encodedValue, "number", STYLE_SCALAR);
    }

    @Override
    protected final void _verifyValueWrite(String typeMsg) throws IOException, JsonGenerationException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
    }

    @Override
    protected void _releaseBuffers() {
    }

    protected void _writeScalar(String value, String type, Character style) throws IOException {
        this._emitter.emit(this._scalarEvent(value, type, style));
    }

    protected ScalarEvent _scalarEvent(String value, String tag, Character style) {
        return new ScalarEvent(null, null, DEFAULT_IMPLICIT, value, null, null, style);
    }

    public static enum Feature {
        BOGUS(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

