/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.field.data.FieldDataType;

public class Lucene {
    public static final Version VERSION;
    public static final Version ANALYZER_VERSION;
    public static final Version QUERYPARSER_VERSION;
    public static final NamedAnalyzer STANDARD_ANALYZER;
    public static final NamedAnalyzer KEYWORD_ANALYZER;
    public static final int NO_DOC = -1;
    public static ScoreDoc[] EMPTY_SCORE_DOCS;
    public static final int BATCH_ENUM_DOCS = 32;
    private static final Field segmentReaderSegmentInfoField;

    public static Version parseVersion(@Nullable String version, Version defaultVersion, ESLogger logger) {
        if (version == null) {
            return defaultVersion;
        }
        if ("3.6".equals(version)) {
            return Version.LUCENE_36;
        }
        if ("3.5".equals(version)) {
            return Version.LUCENE_35;
        }
        if ("3.4".equals(version)) {
            return Version.LUCENE_34;
        }
        if ("3.3".equals(version)) {
            return Version.LUCENE_33;
        }
        if ("3.2".equals(version)) {
            return Version.LUCENE_32;
        }
        if ("3.1".equals(version)) {
            return Version.LUCENE_31;
        }
        if ("3.0".equals(version)) {
            return Version.LUCENE_30;
        }
        logger.warn("no version match {}, default to {}", new Object[]{version, defaultVersion});
        return defaultVersion;
    }

    public static long count(IndexSearcher searcher, Query query) throws IOException {
        TotalHitCountCollector countCollector = new TotalHitCountCollector();
        if (!(query instanceof ConstantScoreQuery)) {
            query = new ConstantScoreQuery(query);
        }
        searcher.search(query, countCollector);
        return countCollector.getTotalHits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int docId(IndexReader reader, Term term) throws IOException {
        TermDocs termDocs = reader.termDocs(term);
        try {
            if (termDocs.next()) {
                int n = termDocs.doc();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            termDocs.close();
        }
    }

    public static boolean safeClose(IndexWriter writer) {
        if (writer == null) {
            return true;
        }
        try {
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static TopDocs readTopDocs(StreamInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        if (in.readBoolean()) {
            int totalHits = in.readVInt();
            float maxScore = in.readFloat();
            SortField[] fields = new SortField[in.readVInt()];
            for (int i = 0; i < fields.length; ++i) {
                String field = null;
                if (in.readBoolean()) {
                    field = in.readUTF();
                }
                fields[i] = new SortField(field, in.readVInt(), in.readBoolean());
            }
            ScoreDoc[] fieldDocs = new FieldDoc[in.readVInt()];
            for (int i = 0; i < fieldDocs.length; ++i) {
                Object[] cFields = new Comparable[in.readVInt()];
                for (int j = 0; j < cFields.length; ++j) {
                    byte type = in.readByte();
                    if (type == 0) {
                        cFields[j] = null;
                        continue;
                    }
                    if (type == 1) {
                        cFields[j] = in.readUTF();
                        continue;
                    }
                    if (type == 2) {
                        cFields[j] = in.readInt();
                        continue;
                    }
                    if (type == 3) {
                        cFields[j] = in.readLong();
                        continue;
                    }
                    if (type == 4) {
                        cFields[j] = Float.valueOf(in.readFloat());
                        continue;
                    }
                    if (type == 5) {
                        cFields[j] = in.readDouble();
                        continue;
                    }
                    if (type == 6) {
                        cFields[j] = in.readByte();
                        continue;
                    }
                    if (type == 7) {
                        cFields[j] = in.readShort();
                        continue;
                    }
                    if (type == 8) {
                        cFields[j] = in.readBoolean();
                        continue;
                    }
                    throw new IOException("Can't match type [" + type + "]");
                }
                fieldDocs[i] = new FieldDoc(in.readVInt(), in.readFloat(), cFields);
            }
            return new TopFieldDocs(totalHits, fieldDocs, fields, maxScore);
        }
        int totalHits = in.readVInt();
        float maxScore = in.readFloat();
        ScoreDoc[] scoreDocs = new ScoreDoc[in.readVInt()];
        for (int i = 0; i < scoreDocs.length; ++i) {
            scoreDocs[i] = new ScoreDoc(in.readVInt(), in.readFloat());
        }
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    public static void writeTopDocs(StreamOutput out, TopDocs topDocs, int from) throws IOException {
        if (topDocs.scoreDocs.length - from < 0) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (topDocs instanceof TopFieldDocs) {
            out.writeBoolean(true);
            TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs;
            out.writeVInt(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topFieldDocs.fields.length);
            for (SortField sortField : topFieldDocs.fields) {
                if (sortField.getField() == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(sortField.getField());
                }
                if (sortField.getComparatorSource() != null) {
                    out.writeVInt(((FieldDataType.ExtendedFieldComparatorSource)sortField.getComparatorSource()).reducedType());
                } else {
                    out.writeVInt(sortField.getType());
                }
                out.writeBoolean(sortField.getReverse());
            }
            out.writeVInt(topDocs.scoreDocs.length - from);
            int index = 0;
            for (ScoreDoc doc : topFieldDocs.scoreDocs) {
                if (index++ < from) continue;
                FieldDoc fieldDoc = (FieldDoc)doc;
                out.writeVInt(fieldDoc.fields.length);
                for (Object field : fieldDoc.fields) {
                    if (field == null) {
                        out.writeByte((byte)0);
                        continue;
                    }
                    Class<?> type = field.getClass();
                    if (type == String.class) {
                        out.writeByte((byte)1);
                        out.writeUTF((String)field);
                        continue;
                    }
                    if (type == Integer.class) {
                        out.writeByte((byte)2);
                        out.writeInt((Integer)field);
                        continue;
                    }
                    if (type == Long.class) {
                        out.writeByte((byte)3);
                        out.writeLong((Long)field);
                        continue;
                    }
                    if (type == Float.class) {
                        out.writeByte((byte)4);
                        out.writeFloat(((Float)field).floatValue());
                        continue;
                    }
                    if (type == Double.class) {
                        out.writeByte((byte)5);
                        out.writeDouble((Double)field);
                        continue;
                    }
                    if (type == Byte.class) {
                        out.writeByte((byte)6);
                        out.writeByte((Byte)field);
                        continue;
                    }
                    if (type == Short.class) {
                        out.writeByte((byte)7);
                        out.writeShort((Short)field);
                        continue;
                    }
                    if (type == Boolean.class) {
                        out.writeByte((byte)8);
                        out.writeBoolean((Boolean)field);
                        continue;
                    }
                    throw new IOException("Can't handle sort field value of type [" + type + "]");
                }
                out.writeVInt(doc.doc);
                out.writeFloat(doc.score);
            }
        } else {
            out.writeBoolean(false);
            out.writeVInt(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topDocs.scoreDocs.length - from);
            int index = 0;
            for (ScoreDoc doc : topDocs.scoreDocs) {
                if (index++ < from) continue;
                out.writeVInt(doc.doc);
                out.writeFloat(doc.score);
            }
        }
    }

    public static Explanation readExplanation(StreamInput in) throws IOException {
        float value = in.readFloat();
        String description = in.readUTF();
        Explanation explanation = new Explanation(value, description);
        if (in.readBoolean()) {
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                explanation.addDetail(Lucene.readExplanation(in));
            }
        }
        return explanation;
    }

    public static void writeExplanation(StreamOutput out, Explanation explanation) throws IOException {
        out.writeFloat(explanation.getValue());
        out.writeUTF(explanation.getDescription());
        Explanation[] subExplanations = explanation.getDetails();
        if (subExplanations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(subExplanations.length);
            for (Explanation subExp : subExplanations) {
                Lucene.writeExplanation(out, subExp);
            }
        }
    }

    public static SegmentInfo getSegmentInfo(SegmentReader reader) {
        try {
            return (SegmentInfo)segmentReaderSegmentInfoField.get(reader);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private Lucene() {
    }

    static {
        ANALYZER_VERSION = VERSION = Version.LUCENE_36;
        QUERYPARSER_VERSION = VERSION;
        STANDARD_ANALYZER = new NamedAnalyzer("_standard", AnalyzerScope.GLOBAL, new StandardAnalyzer(ANALYZER_VERSION));
        KEYWORD_ANALYZER = new NamedAnalyzer("_keyword", AnalyzerScope.GLOBAL, new KeywordAnalyzer());
        EMPTY_SCORE_DOCS = new ScoreDoc[0];
        Field segmentReaderSegmentInfoFieldX = null;
        try {
            segmentReaderSegmentInfoFieldX = SegmentReader.class.getDeclaredField("si");
            segmentReaderSegmentInfoFieldX.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        segmentReaderSegmentInfoField = segmentReaderSegmentInfoFieldX;
    }

    public static class ExistsCollector
    extends Collector {
        private boolean exists;

        public void reset() {
            this.exists = false;
        }

        public boolean exists() {
            return this.exists;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.exists = false;
        }

        @Override
        public void collect(int doc) throws IOException {
            this.exists = true;
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

