/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;

public class MultiCollector
extends Collector {
    private final Collector collector;
    private final Collector[] collectors;

    public MultiCollector(Collector collector, Collector[] collectors) {
        this.collector = collector;
        this.collectors = collectors;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (!(scorer instanceof ScoreCachingWrappingScorer)) {
            scorer = new ScoreCachingWrappingScorer(scorer);
        }
        this.collector.setScorer(scorer);
        for (Collector collector : this.collectors) {
            collector.setScorer(scorer);
        }
    }

    @Override
    public void collect(int doc) throws IOException {
        this.collector.collect(doc);
        for (Collector collector : this.collectors) {
            collector.collect(doc);
        }
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.collector.setNextReader(reader, docBase);
        for (Collector collector : this.collectors) {
            collector.setNextReader(reader, docBase);
        }
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        if (!this.collector.acceptsDocsOutOfOrder()) {
            return false;
        }
        for (Collector collector : this.collectors) {
            if (collector.acceptsDocsOutOfOrder()) continue;
            return false;
        }
        return true;
    }
}

