/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.text;

import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.text.Text;

public class BytesText
implements Text {
    private BytesReference bytes;

    public BytesText(BytesReference bytes) {
        this.bytes = bytes;
    }

    @Override
    public boolean hasBytes() {
        return true;
    }

    @Override
    public BytesReference bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasString() {
        return false;
    }

    @Override
    public String string() {
        if (!this.bytes.hasArray()) {
            this.bytes = this.bytes.toBytesArray();
        }
        return new String(this.bytes.array(), this.bytes.arrayOffset(), this.bytes.length(), Charsets.UTF_8);
    }

    @Override
    public String toString() {
        return this.string();
    }
}

