/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.search.geo.GeoDistance;

public class GeoDistanceFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private String distance;
    private double lat;
    private double lon;
    private String geohash;
    private GeoDistance geoDistance;
    private String optimizeBbox;
    private Boolean cache;
    private String cacheKey;
    private String filterName;

    public GeoDistanceFilterBuilder(String name) {
        this.name = name;
    }

    public GeoDistanceFilterBuilder point(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoDistanceFilterBuilder lat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoDistanceFilterBuilder lon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoDistanceFilterBuilder distance(String distance) {
        this.distance = distance;
        return this;
    }

    public GeoDistanceFilterBuilder distance(double distance, DistanceUnit unit) {
        this.distance = unit.toString(distance);
        return this;
    }

    public GeoDistanceFilterBuilder geohash(String geohash) {
        this.geohash = geohash;
        return this;
    }

    public GeoDistanceFilterBuilder geoDistance(GeoDistance geoDistance) {
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistanceFilterBuilder optimizeBbox(String optimizeBbox) {
        this.optimizeBbox = optimizeBbox;
        return this;
    }

    public GeoDistanceFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public GeoDistanceFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public GeoDistanceFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_distance");
        if (this.geohash != null) {
            builder.field(this.name, this.geohash);
        } else {
            builder.startArray(this.name).value(this.lon).value(this.lat).endArray();
        }
        builder.field("distance", this.distance);
        if (this.geoDistance != null) {
            builder.field("distance_type", this.geoDistance.name().toLowerCase());
        }
        if (this.optimizeBbox != null) {
            builder.field("optimize_bbox", this.optimizeBbox);
        }
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        builder.endObject();
    }
}

