/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.longs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.iterator.TLongIntIterator;
import org.elasticsearch.common.trove.map.hash.TLongIntHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.InternalTermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;

public class InternalLongTermsFacet
extends InternalTermsFacet {
    private static final String STREAM_TYPE = "lTerms";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalLongTermsFacet.readTermsFacet(in);
        }
    };
    private String name;
    int requiredSize;
    long missing;
    long total;
    Collection<LongEntry> entries = ImmutableList.of();
    TermsFacet.ComparatorType comparatorType;

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    InternalLongTermsFacet() {
    }

    public InternalLongTermsFacet(String name, TermsFacet.ComparatorType comparatorType, int requiredSize, Collection<LongEntry> entries, long missing, long total) {
        this.name = name;
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries;
        this.missing = missing;
        this.total = total;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String type() {
        return "terms";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<LongEntry> entries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    public List<LongEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<TermsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long missingCount() {
        return this.missing;
    }

    @Override
    public long getMissingCount() {
        return this.missingCount();
    }

    @Override
    public long totalCount() {
        return this.total;
    }

    @Override
    public long getTotalCount() {
        return this.totalCount();
    }

    @Override
    public long otherCount() {
        long other = this.total;
        for (LongEntry entry : this.entries) {
            other -= (long)entry.count();
        }
        return other;
    }

    @Override
    public long getOtherCount() {
        return this.otherCount();
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        InternalLongTermsFacet first = (InternalLongTermsFacet)facets.get(0);
        TLongIntHashMap aggregated = CacheRecycler.popLongIntMap();
        long missing = 0L;
        long total = 0L;
        for (Facet facet : facets) {
            InternalLongTermsFacet mFacet = (InternalLongTermsFacet)facet;
            missing += mFacet.missingCount();
            total += mFacet.totalCount();
            for (LongEntry entry : mFacet.entries) {
                aggregated.adjustOrPutValue(entry.term, entry.count(), entry.count());
            }
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(first.comparatorType.comparator(), first.requiredSize);
        TLongIntIterator it = aggregated.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new LongEntry(it.key(), it.value()));
        }
        first.entries = ordered;
        first.missing = missing;
        first.total = total;
        CacheRecycler.pushLongIntMap(aggregated);
        return first;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "terms");
        builder.field(Fields.MISSING, this.missing);
        builder.field(Fields.TOTAL, this.total);
        builder.field(Fields.OTHER, this.otherCount());
        builder.startArray(Fields.TERMS);
        for (LongEntry entry : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, entry.term);
            builder.field(Fields.COUNT, entry.count());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalLongTermsFacet readTermsFacet(StreamInput in) throws IOException {
        InternalLongTermsFacet facet = new InternalLongTermsFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = TermsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        this.total = in.readVLong();
        int size = in.readVInt();
        this.entries = new ArrayList<LongEntry>(size);
        for (int i = 0; i < size; ++i) {
            this.entries.add(new LongEntry(in.readLong(), in.readVInt()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVLong(this.total);
        out.writeVInt(this.entries.size());
        for (LongEntry entry : this.entries) {
            out.writeLong(entry.term);
            out.writeVInt(entry.count());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString OTHER = new XContentBuilderString("other");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class LongEntry
    implements TermsFacet.Entry {
        long term;
        int count;

        public LongEntry(long term, int count) {
            this.term = term;
            this.count = count;
        }

        @Override
        public String term() {
            return Long.toString(this.term);
        }

        @Override
        public String getTerm() {
            return this.term();
        }

        @Override
        public Number termAsNumber() {
            return this.term;
        }

        @Override
        public Number getTermAsNumber() {
            return this.termAsNumber();
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public int getCount() {
            return this.count();
        }

        @Override
        public int compareTo(TermsFacet.Entry o) {
            long anotherVal = ((LongEntry)o).term;
            if (this.term < anotherVal) {
                return -1;
            }
            if (this.term == anotherVal) {
                int i = this.count - o.count();
                if (i == 0) {
                    i = System.identityHashCode(this) - System.identityHashCode(o);
                }
                return i;
            }
            return 1;
        }
    }
}

