/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.impl;

import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.maven.impl.MavenDownloadProxyServlet;
import io.fabric8.maven.impl.MavenSecureHttpContext;
import io.fabric8.maven.impl.MavenUploadProxyServlet;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Servlet;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.zookeeper.CreateMode;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.maven", description="Fabric Maven Proxy Registration Handler", policy=ConfigurationPolicy.OPTIONAL, immediate=true)
@Service(value={ConnectionStateListener.class})
public final class MavenProxyRegistrationHandler
extends AbstractComponent
implements ConnectionStateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProxyRegistrationHandler.class);
    private static final String LOCAL_REPOSITORY_PROPERTY = "localRepository";
    private static final String REMOTE_REPOSITORIES_PROPERTY = "remoteRepositories";
    private static final String APPEND_SYSTEM_REPOS_PROPERTY = "appendSystemRepos";
    private static final String UPDATE_POLICY_PROPERTY = "updatePolicy";
    private static final String CHECKSUM_POLICY_PROPERTY = "checksumPolicy";
    private static final String PROXY_PROTOCOL_PROPERTY = "proxy.protocol";
    private static final String PROXY_HOST_PROPERTY = "proxy.host";
    private static final String PROXY_PORT_PROPERTY = "proxy.port";
    private static final String PROXY_USERNAME_PROPERTY = "proxy.username";
    private static final String PROXY_PASSWORD_PROPERTY = "proxy.password";
    private static final String NON_PROXY_HOSTS_PROPERTY = "proxy.nonProxyHosts";
    private static final String REQUIRED_ROLE = "role";
    private static final String REQUIRED_REALM = "realm";
    private static final String DEFAULT_ROLE = "admin";
    private static final String DEFAULT_REALM = "karaf";
    private static final String DEFAULT_LOCAL_REPOSITORY = System.getProperty("karaf.data") + File.separator + "maven" + File.separator + "proxy" + File.separator + "downloads";
    private static final String KARAF_NAME = System.getProperty("karaf.name");
    @Reference(referenceInterface=HttpService.class)
    private final ValidatingReference<HttpService> httpService = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    private final Map<String, Set<String>> registeredProxies;
    @GuardedBy(value="volatile")
    private volatile MavenDownloadProxyServlet mavenDownloadProxyServlet;
    @GuardedBy(value="volatile")
    private volatile MavenUploadProxyServlet mavenUploadProxyServlet;
    @GuardedBy(value="volatile")
    private volatile String realm;
    @GuardedBy(value="volatile")
    private volatile String role;
    @GuardedBy(value="AtomicBoolean")
    private final AtomicBoolean connected = new AtomicBoolean(false);

    public MavenProxyRegistrationHandler() {
        HashMap proxies = new HashMap();
        proxies.put("download", new HashSet());
        proxies.put("upload", new HashSet());
        this.registeredProxies = Collections.unmodifiableMap(proxies);
    }

    @Activate
    void activate(Map<String, ?> configuration) throws IOException {
        String localRepository = this.readProperty(configuration, LOCAL_REPOSITORY_PROPERTY, DEFAULT_LOCAL_REPOSITORY);
        String remoteRepositories = this.readProperty(configuration, REMOTE_REPOSITORIES_PROPERTY, "");
        boolean appendSystemRepos = Boolean.parseBoolean(this.readProperty(configuration, APPEND_SYSTEM_REPOS_PROPERTY, "false"));
        String updatePolicy = this.readProperty(configuration, UPDATE_POLICY_PROPERTY, "always");
        String checksumPolicy = this.readProperty(configuration, CHECKSUM_POLICY_PROPERTY, "warn");
        String proxyProtocol = this.readProperty(configuration, PROXY_PROTOCOL_PROPERTY, "");
        String proxyHost = this.readProperty(configuration, PROXY_HOST_PROPERTY, "");
        int proxyPort = Integer.parseInt(this.readProperty(configuration, PROXY_PORT_PROPERTY, "8080"));
        String proxyUsername = this.readProperty(configuration, PROXY_USERNAME_PROPERTY, "");
        String proxyPassword = this.readProperty(configuration, PROXY_PASSWORD_PROPERTY, "");
        String nonProxyHosts = this.readProperty(configuration, NON_PROXY_HOSTS_PROPERTY, "");
        this.role = this.readProperty(configuration, REQUIRED_ROLE, DEFAULT_ROLE);
        this.realm = this.readProperty(configuration, REQUIRED_REALM, DEFAULT_REALM);
        this.mavenDownloadProxyServlet = new MavenDownloadProxyServlet(localRepository, remoteRepositories, appendSystemRepos, updatePolicy, checksumPolicy, proxyProtocol, proxyHost, proxyPort, proxyUsername, proxyPassword, nonProxyHosts);
        this.mavenDownloadProxyServlet.start();
        this.mavenUploadProxyServlet = new MavenUploadProxyServlet(localRepository, remoteRepositories, appendSystemRepos, updatePolicy, checksumPolicy, proxyProtocol, proxyHost, proxyPort, proxyUsername, proxyPassword, nonProxyHosts);
        this.mavenUploadProxyServlet.start();
        try {
            HttpContext base = ((HttpService)this.httpService.get()).createDefaultHttpContext();
            MavenSecureHttpContext secure = new MavenSecureHttpContext(base, this.realm, this.role);
            ((HttpService)this.httpService.get()).registerServlet("/maven/download", (Servlet)this.mavenDownloadProxyServlet, this.createParams("maven-download"), base);
            ((HttpService)this.httpService.get()).registerServlet("/maven/upload", (Servlet)this.mavenUploadProxyServlet, this.createParams("maven-upload"), (HttpContext)secure);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to register fabric maven proxy servlets, due to:" + t.getMessage());
        }
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        if (this.mavenDownloadProxyServlet != null) {
            this.mavenDownloadProxyServlet.stop();
        }
        if (this.mavenUploadProxyServlet != null) {
            this.mavenUploadProxyServlet.stop();
        }
        try {
            ((HttpService)this.httpService.get()).unregister("/maven/download");
            ((HttpService)this.httpService.get()).unregister("/maven/upload");
        }
        catch (Exception ex) {
            LOGGER.warn("Http service returned error on servlet unregister. Possibly the service has already been stopped");
        }
        if (this.connected.get()) {
            this.unregister("download");
            this.unregister("upload");
        }
    }

    private Dictionary<String, String> createParams(String name) {
        Hashtable<String, String> d = new Hashtable<String, String>();
        ((Dictionary)d).put("servlet-name", name);
        return d;
    }

    private void register(String type) {
        this.unregister(type);
        try {
            String mavenProxyUrl = "${zk:" + KARAF_NAME + "/http}/maven/" + type + "/";
            String parentPath = ZkPath.MAVEN_PROXY.getPath(new String[]{type});
            String path = parentPath + "/p_";
            this.registeredProxies.get(type).add(ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)mavenProxyUrl, (CreateMode)CreateMode.EPHEMERAL_SEQUENTIAL));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register maven proxy.");
        }
    }

    private void unregister(String type) {
        Set<String> proxyNodes = this.registeredProxies.get(type);
        if (proxyNodes != null) {
            try {
                for (String entry : this.registeredProxies.get(type)) {
                    ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)entry);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to remove maven proxy from registry.");
            }
            this.registeredProxies.get(type).clear();
        }
    }

    private String readProperty(Map<String, ?> properties, String key, String defaultValue) {
        return properties != null && properties.containsKey(key) ? properties.get(key).toString() : defaultValue;
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        switch (newState) {
            case CONNECTED: 
            case RECONNECTED: {
                this.connected.set(true);
                if (!this.isValid()) break;
                this.register("download");
                this.register("upload");
                break;
            }
            default: {
                this.connected.set(false);
            }
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindHttpService(HttpService service) {
        this.httpService.bind((Object)service);
    }

    void unbindHttpService(HttpService service) {
        this.httpService.unbind((Object)service);
    }
}

