/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.FabricException;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.ZooKeeperClusterBootstrap;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.jmx.ClusterBootstrapManagerMBean;
import io.fabric8.api.jmx.JMXUtils;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.utils.properties.Properties;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(description="Fabric ZooKeeper Cluster Bootstrap Manager JMX MBean")
public final class ClusterBootstrapManager
extends AbstractComponent
implements ClusterBootstrapManagerMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(ClusterBootstrapManager.class);
    private static ObjectName OBJECT_NAME;
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=ZooKeeperClusterBootstrap.class)
    private final ValidatingReference<ZooKeeperClusterBootstrap> bootstrap = new ValidatingReference();
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private final ValidatingReference<MBeanServer> mbeanServer = new ValidatingReference();

    @Activate
    void activate() throws Exception {
        JMXUtils.registerMBean(this, (MBeanServer)this.mbeanServer.get(), OBJECT_NAME);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() throws Exception {
        this.deactivateComponent();
        JMXUtils.unregisterMBean((MBeanServer)this.mbeanServer.get(), OBJECT_NAME);
    }

    static CreateEnsembleOptions getCreateEnsembleOptions(RuntimeProperties sysprops, Map<String, Object> options) {
        String username = (String)options.remove("username");
        String password = (String)options.remove("password");
        String role = (String)options.remove("role");
        if (username == null || password == null || role == null) {
            throw new FabricException("Must specify an administrator username, password and administrative role when creating a fabric");
        }
        Object profileObject = options.remove("profiles");
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        CreateEnsembleOptions.Builder builder = (CreateEnsembleOptions.Builder)mapper.convertValue(options, CreateEnsembleOptions.Builder.class);
        if (profileObject != null) {
            List profiles = (List)mapper.convertValue(profileObject, List.class);
            builder.profiles(profiles);
        }
        Properties userProps = null;
        try {
            userProps = new Properties(new File(sysprops.getProperty("karaf.home") + "/etc/users.properties"));
        }
        catch (IOException e) {
            userProps = new Properties();
        }
        if (userProps.get(username) == null) {
            userProps.put(username, password + "," + role);
        }
        CreateEnsembleOptions answer = builder.users((Map)userProps).withUser(username, password, role).build();
        LOG.debug("Creating ensemble with options: {}", (Object)answer);
        sysprops.setProperty("global.resolver", answer.getGlobalResolver());
        sysprops.setProperty("local.resolver", answer.getResolver());
        sysprops.setProperty("manualip", answer.getManualIp());
        sysprops.setProperty("bind.address", answer.getBindAddress());
        sysprops.setProperty("minimum.port", "" + answer.getMinimumPort());
        sysprops.setProperty("maximum.port", "" + answer.getMaximumPort());
        return answer;
    }

    @Override
    public void createCluster() {
        this.assertValid();
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        ((ZooKeeperClusterBootstrap)this.bootstrap.get()).create(CreateEnsembleOptions.builder().fromRuntimeProperties(sysprops).build());
    }

    @Override
    public void createCluster(Map<String, Object> options) {
        this.assertValid();
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        CreateEnsembleOptions createEnsembleOptions = ClusterBootstrapManager.getCreateEnsembleOptions(sysprops, options);
        ((ZooKeeperClusterBootstrap)this.bootstrap.get()).create(createEnsembleOptions);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer.bind((Object)mbeanServer);
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer.unbind((Object)mbeanServer);
    }

    void bindBootstrap(ZooKeeperClusterBootstrap bootstrap) {
        this.bootstrap.bind((Object)bootstrap);
    }

    void unbindBootstrap(ZooKeeperClusterBootstrap bootstrap) {
        this.bootstrap.unbind((Object)bootstrap);
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=ClusterBootstrapManager");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

