/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import io.fabric8.api.jmx.JMXUtils;
import io.fabric8.api.jmx.MetaTypeFacadeMXBean;
import io.fabric8.api.jmx.MetaTypeInformationDTO;
import io.fabric8.api.jmx.MetaTypeObjectDTO;
import io.fabric8.api.jmx.MetaTypeSummaryDTO;
import io.fabric8.internal.Objects;
import io.fabric8.utils.BundleUtils;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(description="MetaType Facade JMX MBean")
public class MetaTypeFacade
implements MetaTypeFacadeMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(MetaTypeFacade.class);
    private static ObjectName OBJECT_NAME;
    @Reference(referenceInterface=MetaTypeService.class)
    private MetaTypeService metaTypeService;
    @Reference(referenceInterface=MBeanServer.class)
    private MBeanServer mbeanServer;
    private BundleContext bundleContext;
    private BundleUtils bundleUtils;

    @Activate
    void activate(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.bundleUtils = new BundleUtils(bundleContext);
        Objects.notNull(this.metaTypeService, "metaTypeService");
        Objects.notNull(bundleContext, "bundleContext");
        if (this.mbeanServer != null) {
            JMXUtils.registerMBean(this, this.mbeanServer, OBJECT_NAME);
        }
    }

    @Deactivate
    void deactivate() throws Exception {
        if (this.mbeanServer != null) {
            JMXUtils.unregisterMBean(this.mbeanServer, OBJECT_NAME);
        }
    }

    @Override
    public MetaTypeInformationDTO getMetaTypeInformationForBundleId(long bundleId) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        return this.getMetaTypeInformationDTO(bundle);
    }

    @Override
    public MetaTypeInformationDTO getMetaTypeInformation(String bundleSymbolicName) {
        try {
            Bundle bundle = this.bundleUtils.findBundle(bundleSymbolicName);
            return this.getMetaTypeInformationDTO(bundle);
        }
        catch (BundleException e) {
            LOG.info("Could not find bundle '" + bundleSymbolicName + "'");
            return null;
        }
    }

    @Override
    public MetaTypeSummaryDTO metaTypeSummary() {
        Bundle[] bundles;
        MetaTypeSummaryDTO answer = new MetaTypeSummaryDTO();
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            MetaTypeInformation info = this.getMetaTypeInformation(bundle);
            if (info == null) continue;
            answer.addTypeInformation(bundle, info);
        }
        return answer;
    }

    @Override
    public MetaTypeObjectDTO getPidMetaTypeObject(String pid, String locale) {
        Bundle[] bundles = this.bundleContext.getBundles();
        MetaTypeObjectDTO answer = null;
        for (Bundle bundle : bundles) {
            ObjectClassDefinition object;
            MetaTypeInformation info = this.getMetaTypeInformation(bundle);
            if (info == null || (object = MetaTypeFacade.tryGetObjectClassDefinition(info, pid, locale)) == null) continue;
            if (answer == null) {
                answer = new MetaTypeObjectDTO(object);
                continue;
            }
            answer.appendObjectDefinition(object);
        }
        return answer;
    }

    public static ObjectClassDefinition tryGetObjectClassDefinition(MetaTypeInformation info, String pid, String locale) {
        ObjectClassDefinition object = null;
        try {
            object = info.getObjectClassDefinition(pid, locale);
        }
        catch (Exception e) {
            // empty catch block
        }
        return object;
    }

    @Override
    public MetaTypeObjectDTO getMetaTypeObject(long bundleId, String pid, String locale) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        return this.getMetaTypeObject(bundle, pid, locale);
    }

    protected MetaTypeObjectDTO getMetaTypeObject(Bundle bundle, String pid, String locale) {
        ObjectClassDefinition objectClassDefinition;
        MetaTypeInformation info = this.getMetaTypeInformation(bundle);
        if (info != null && (objectClassDefinition = info.getObjectClassDefinition(pid, locale)) != null) {
            return new MetaTypeObjectDTO(objectClassDefinition);
        }
        return null;
    }

    protected MetaTypeInformationDTO getMetaTypeInformationDTO(Bundle bundle) {
        MetaTypeInformation info = this.getMetaTypeInformation(bundle);
        if (info != null) {
            return new MetaTypeInformationDTO(info);
        }
        return null;
    }

    protected MetaTypeInformation getMetaTypeInformation(Bundle bundle) {
        if (bundle != null && this.metaTypeService != null) {
            return this.metaTypeService.getMetaTypeInformation(bundle);
        }
        return null;
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=MetaTypeFacade");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    protected void bindMetaTypeService(MetaTypeService metaTypeService) {
        this.metaTypeService = metaTypeService;
    }

    protected void unbindMetaTypeService(MetaTypeService metaTypeService) {
        if (this.metaTypeService == metaTypeService) {
            this.metaTypeService = null;
        }
    }

    protected void bindMbeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    protected void unbindMbeanServer(MBeanServer mBeanServer) {
        if (this.mbeanServer == mBeanServer) {
            this.mbeanServer = null;
        }
    }
}

