/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.proxy;

import io.fabric8.api.DynamicReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class DelegatingInvocationHandler<T>
implements InvocationHandler {
    public static long DEFAULT_TIMEOUT = 30000L;
    private final DynamicReference<T> dynamicReference;
    private final ServiceTracker<T, T> tracker;

    public DelegatingInvocationHandler(BundleContext context, Class<T> type) {
        this(context, type, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public DelegatingInvocationHandler(BundleContext context, Class<T> type, long timeout, TimeUnit unit) {
        this.dynamicReference = new DynamicReference(type.getSimpleName(), timeout, unit);
        this.tracker = new ServiceTracker<T, T>(context, type, null){

            public T addingService(ServiceReference<T> reference) {
                Object service = super.addingService(reference);
                DelegatingInvocationHandler.this.dynamicReference.bind(service);
                return service;
            }

            public void modifiedService(ServiceReference<T> reference, T service) {
                super.modifiedService(reference, service);
                DelegatingInvocationHandler.this.dynamicReference.bind(service);
            }

            public void removedService(ServiceReference<T> reference, T service) {
                super.removedService(reference, service);
                DelegatingInvocationHandler.this.dynamicReference.unbind(service);
            }
        };
        this.tracker.open();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object service = this.dynamicReference.get();
            return method.invoke(service, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

