/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.Container;
import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.DataStoreRegistrationHandler;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.DynamicReference;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.ZooKeeperClusterBootstrap;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.proxy.ServiceProxy;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.utils.BundleUtils;
import io.fabric8.zookeeper.bootstrap.BootstrapConfiguration;
import io.fabric8.zookeeper.bootstrap.DataStoreBootstrapTemplate;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

@ThreadSafe
@Component(name="io.fabric8.zookeeper.cluster.bootstrap", description="Fabric ZooKeeper Cluster Bootstrap", immediate=true)
@Service(value={ZooKeeperClusterBootstrap.class})
public final class ZooKeeperClusterBootstrapImpl
extends AbstractComponent
implements ZooKeeperClusterBootstrap {
    private static final Long FABRIC_SERVICE_TIMEOUT = 60000L;
    @Reference(referenceInterface=ScrService.class)
    private final ValidatingReference<ScrService> scrService = new ValidatingReference();
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=DataStoreRegistrationHandler.class)
    private final ValidatingReference<DataStoreRegistrationHandler> registrationHandler = new ValidatingReference();
    @Reference(referenceInterface=BootstrapConfiguration.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private final DynamicReference<BootstrapConfiguration> bootstrapConfiguration = new DynamicReference();
    @Reference(referenceInterface=FabricService.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private final DynamicReference<FabricService> fabricService = new DynamicReference("Fabric Service", FABRIC_SERVICE_TIMEOUT.longValue(), TimeUnit.MILLISECONDS);
    private ComponentContext componentContext;
    private BundleUtils bundleUtils;

    @Activate
    void activate(ComponentContext componentContext) throws Exception {
        this.bundleUtils = new BundleUtils(componentContext.getBundleContext());
        this.componentContext = componentContext;
        BootstrapConfiguration bootConfig = (BootstrapConfiguration)this.bootstrapConfiguration.get();
        CreateEnsembleOptions options = bootConfig.getBootstrapOptions();
        if (options.isEnsembleStart()) {
            this.startBundles(options);
        }
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public void create(CreateEnsembleOptions options) {
        this.assertValid();
        try {
            this.stopBundles();
            RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
            BootstrapConfiguration bootConfig = (BootstrapConfiguration)this.bootstrapConfiguration.get();
            String connectionUrl = bootConfig.getConnectionUrl(options);
            ((DataStoreRegistrationHandler)this.registrationHandler.get()).setRegistrationCallback((DataStoreTemplate)new DataStoreBootstrapTemplate(sysprops, connectionUrl, options));
            bootConfig.createOrUpdateDataStoreConfig(options);
            bootConfig.createZooKeeeperServerConfig(options);
            bootConfig.createZooKeeeperClientConfig(connectionUrl, options);
            this.startBundles(options);
            if (options.isWaitForProvision() && options.isAgentEnabled()) {
                String karafName = sysprops.getProperty("karaf.name");
                this.waitForSuccessfulDeploymentOf(karafName, options.getProvisionTimeout());
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new FabricException("Unable to create zookeeper server configuration", (Throwable)ex);
        }
    }

    private void waitForSuccessfulDeploymentOf(String containerName, long timeout) throws InterruptedException {
        System.out.println(String.format("Waiting for container %s to provision.", containerName));
        BundleContext sysContext = this.componentContext.getBundleContext().getBundle(0L).getBundleContext();
        FabricService fabricServiceProxy = ServiceProxy.getOsgiServiceProxy(sysContext, FabricService.class);
        long startedAt = System.currentTimeMillis();
        while (!Thread.interrupted() && startedAt + timeout > System.currentTimeMillis()) {
            try {
                Container container;
                Container container2 = container = fabricServiceProxy != null ? fabricServiceProxy.getContainer(containerName) : null;
                if (container != null && container.isAlive() && "success".equals(container.getProvisionStatus())) {
                    return;
                }
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                throw FabricException.launderThrowable((Throwable)t);
            }
        }
    }

    public void clean() {
        this.assertValid();
        try {
            org.apache.felix.scr.Component[] components;
            for (org.apache.felix.scr.Component component : components = ((ScrService)this.scrService.get()).getComponents("io.fabric8.zookeeper.configuration")) {
                component.disable();
            }
            this.cleanConfigurations();
            this.cleanZookeeperDirectory();
            this.cleanGitDirectory();
            for (org.apache.felix.scr.Component component : components) {
                component.enable();
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new FabricException("Unable to delete zookeeper configuration", (Throwable)e);
        }
    }

    private void cleanConfigurations() throws IOException, InvalidSyntaxException {
        Configuration[] configs = ((ConfigurationAdmin)this.configAdmin.get()).listConfigurations("(|(service.factoryPid=io.fabric8.zookeeper.server)(service.pid=io.fabric8.zookeeper))");
        if (configs != null && configs.length > 0) {
            for (Configuration config : configs) {
                config.delete();
            }
        }
    }

    private void cleanZookeeperDirectory() throws IOException, InvalidSyntaxException {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        File karafData = new File(sysprops.getProperty("karaf.data"));
        File zkDir = new File(karafData, "zookeeper");
        if (zkDir.isDirectory()) {
            File newZkDir = new File(karafData, "zookeeper." + System.currentTimeMillis());
            if (!zkDir.renameTo(newZkDir)) {
                newZkDir = zkDir;
            }
            ZooKeeperClusterBootstrapImpl.delete(newZkDir);
        }
    }

    private void cleanGitDirectory() {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        File karafData = new File(sysprops.getProperty("karaf.data"));
        File gitDir = new File(karafData, "git");
        if (gitDir.isDirectory()) {
            ZooKeeperClusterBootstrapImpl.delete(gitDir);
        }
    }

    private void stopBundles() throws BundleException {
        this.bundleUtils.findAndStopBundle("io.fabric8.fabric-agent");
    }

    private void startBundles(CreateEnsembleOptions options) throws BundleException {
        Bundle agentBundle = this.bundleUtils.findBundle("io.fabric8.fabric-agent");
        if (agentBundle != null && options.isAgentEnabled()) {
            agentBundle.start();
        }
    }

    private static void delete(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                ZooKeeperClusterBootstrapImpl.delete(child);
            }
        }
        if (dir.exists()) {
            dir.delete();
        }
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindScrService(ScrService service) {
        this.scrService.bind((Object)service);
    }

    void unbindScrService(ScrService service) {
        this.scrService.unbind((Object)service);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.bind((Object)service);
    }

    void unbindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.unbind((Object)service);
    }

    void bindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.bind((Object)service);
    }

    void unbindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.unbind((Object)service);
    }

    void bindFabricService(FabricService service) {
        this.fabricService.bind((Object)service);
    }

    void unbindFabricService(FabricService service) {
        this.fabricService.unbind((Object)service);
    }
}

