/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.utils.ChecksumUtils;
import io.fabric8.utils.Closeables;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.checksum", description="Fabric Checksum Placholder Resolver")
@Service(value={PlaceholderResolver.class})
public final class ChecksumPlaceholderResolver
extends AbstractComponent
implements PlaceholderResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChecksumPlaceholderResolver.class);
    private static final String CHECKSUM_SCHEME = "checksum";

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return CHECKSUM_SCHEME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolve(Map<String, Map<String, String>> configs, String pid, String key, String value) {
        this.assertValid();
        InputStream is = null;
        try {
            URL url = new URL(value.substring("checksum:".length()));
            is = url.openStream();
            String string = String.valueOf(ChecksumUtils.checksum(is));
            Closeables.closeQuitely(is);
            return string;
        }
        catch (Exception ex) {
            LOGGER.debug("Could not ");
            String string = "0";
            return string;
        }
        finally {
            Closeables.closeQuitely(is);
        }
    }
}

