/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricException;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.crypt", description="Fabric Encrypted Property Placeholder Resolver")
@Service(value={PlaceholderResolver.class})
public final class EncryptedPropertyResolver
extends AbstractComponent
implements PlaceholderResolver {
    private static final String CRYPT_SCHEME = "crypt";
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return CRYPT_SCHEME;
    }

    public String resolve(Map<String, Map<String, String>> configs, String pid, String key, String value) {
        this.assertValid();
        return this.getEncryptor().decrypt(value.substring(CRYPT_SCHEME.length() + 1));
    }

    private PBEStringEncryptor getEncryptor() {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setAlgorithm(this.getAlgorithm());
        encryptor.setPassword(this.getPassword());
        return encryptor;
    }

    private String getAlgorithm() {
        try {
            return ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.AUTHENTICATION_CRYPT_ALGORITHM.getPath(new String[0]));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    private String getPassword() {
        try {
            return ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.AUTHENTICATION_CRYPT_PASSWORD.getPath(new String[0]));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }
}

