/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.env", description="Environment Placeholder Resolver")
@Service(value={PlaceholderResolver.class})
public final class EnvPlaceholderResolver
extends AbstractComponent
implements PlaceholderResolver {
    private static final String ENV_SCHEME = "env";

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return ENV_SCHEME;
    }

    public String resolve(Map<String, Map<String, String>> configs, String pid, String key, String value) {
        this.assertValid();
        if (value != null && value.length() > ENV_SCHEME.length()) {
            String name = value.substring(ENV_SCHEME.length() + 1);
            return System.getenv(name);
        }
        return value;
    }
}

