/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.profileprop", description="Fabric Profile Property Placeholder Resolver", immediate=true)
@Service(value={PlaceholderResolver.class})
public final class ProfilePropertyPointerResolver
extends AbstractComponent
implements PlaceholderResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfilePropertyPointerResolver.class);
    private static final String SCHEME = "profile";
    private static final Pattern OVERLAY_PROFILE_PROPERTY_URL_PATTERN = Pattern.compile("profile:([^ /]+)/([^ =/]+)");
    private static final String EMPTY = "";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=DataStore.class)
    private final ValidatingReference<DataStore> dataStore = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return SCHEME;
    }

    public String resolve(Map<String, Map<String, String>> configs, String pid, String key, String value) {
        this.assertValid();
        try {
            Matcher overlayMatcher;
            if (value != null && (overlayMatcher = OVERLAY_PROFILE_PROPERTY_URL_PATTERN.matcher(value)).matches()) {
                String targetPid = overlayMatcher.group(1);
                String targetProperty = overlayMatcher.group(2);
                return this.substituteFromProfile(configs, targetPid, targetProperty);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not load property value: {}. Returning empty String.", (Object)value, (Object)e);
        }
        return EMPTY;
    }

    private String substituteFromProfile(Map<String, Map<String, String>> configs, String pid, String key) {
        Map<String, String> configuration = configs.get(pid);
        if (configuration != null && configuration.containsKey(key)) {
            return configuration.get(key);
        }
        return EMPTY;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindDataStore(DataStore dataStore) {
        this.dataStore.bind((Object)dataStore);
    }

    void unbindDataStore(DataStore dataStore) {
        this.dataStore.unbind((Object)dataStore);
    }
}

