/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.utils.Strings;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.versionprop", description="Fabric Version Property Placeholder Resolver", immediate=true)
@Service(value={PlaceholderResolver.class})
public final class VersionPropertyPointerResolver
extends AbstractComponent
implements PlaceholderResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionPropertyPointerResolver.class);
    private static final String SCHEME = "version";
    private static final String EMPTY = "";
    public static final String VERSIONS_PID = "io.fabric8.version";
    public static final String VERSION_PREFIX = "${version:";
    public static final String VERSION_POSTFIX = "}";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=DataStore.class)
    private final ValidatingReference<DataStore> dataStore = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return SCHEME;
    }

    public String resolve(Map<String, Map<String, String>> configs, String pid, String key, String value) {
        this.assertValid();
        try {
            if (Strings.isNotBlank(value)) {
                String pidPey = value.substring(SCHEME.length() + 1);
                String answer = VersionPropertyPointerResolver.substituteFromProfile(configs, VERSIONS_PID, pidPey);
                if (answer != null) {
                    answer = VersionPropertyPointerResolver.replaceVersions(configs, answer);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Replaced value " + value + " with answer: " + answer);
                }
                return answer;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not load property value: {} in version pid. Returning empty String.", (Object)value, (Object)e);
        }
        return EMPTY;
    }

    public static String replaceVersions(Map<String, Map<String, String>> configs, String value) {
        boolean replaced;
        do {
            int keyIdx;
            int endIdx;
            replaced = false;
            int startIdx = value.indexOf(VERSION_PREFIX);
            if (startIdx < 0 || (endIdx = value.indexOf(VERSION_POSTFIX, keyIdx = startIdx + VERSION_PREFIX.length())) <= 0) continue;
            String newKey = value.substring(keyIdx, endIdx);
            String newValue = VersionPropertyPointerResolver.substituteFromProfile(configs, VERSIONS_PID, newKey);
            if (newValue != null) {
                value = value.substring(0, startIdx) + newValue + value.substring(endIdx + 1);
            }
            replaced = true;
        } while (replaced);
        return value;
    }

    private static String substituteFromProfile(Map<String, Map<String, String>> configs, String pid, String key) {
        Map<String, String> configuration = configs.get(pid);
        if (configuration != null && configuration.containsKey(key)) {
            return configuration.get(key);
        }
        return EMPTY;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindDataStore(DataStore dataStore) {
        this.dataStore.bind((Object)dataStore);
    }

    void unbindDataStore(DataStore dataStore) {
        this.dataStore.unbind((Object)dataStore);
    }
}

