/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.extender.listener;

import io.fabric8.api.ModuleStatus;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.extender.listener.AbstractExtenderListener;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;

@ThreadSafe
@Component(name="io.fabric8.extender.listener.blueprint", description="Fabric Blueprint Listener", immediate=true)
@Service(value={BlueprintListener.class})
@References(value={@Reference(referenceInterface=CuratorFramework.class, bind="bindCurator", unbind="unbindCurator")})
public final class FabricBlueprintBundleListener
extends AbstractExtenderListener
implements BlueprintListener {
    private static final String EXTENDER_TYPE = "blueprint";

    @Override
    @Activate
    void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
    }

    @Override
    protected String getExtenderType() {
        return EXTENDER_TYPE;
    }

    public void blueprintEvent(BlueprintEvent event) {
        long bundleId = event.getBundle().getBundleId();
        ModuleStatus moduleStatus = this.toModuleStatus(event.getType());
        this.updateBundle(bundleId, moduleStatus);
    }

    private ModuleStatus toModuleStatus(int type) {
        switch (type) {
            case 1: {
                return ModuleStatus.STARTING;
            }
            case 2: {
                return ModuleStatus.STARTED;
            }
            case 3: {
                return ModuleStatus.STOPPING;
            }
            case 4: {
                return ModuleStatus.STOPPED;
            }
            case 5: {
                return ModuleStatus.FAILED;
            }
            case 6: {
                return ModuleStatus.WAITING;
            }
            case 7: {
                return ModuleStatus.WAITING;
            }
        }
        return ModuleStatus.UNKNOWN;
    }
}

