/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.extender.listener;

import io.fabric8.api.ModuleStatus;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.extender.listener.AbstractExtenderListener;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.References;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEvent;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.context.event.OsgiBundleContextClosedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextFailedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextRefreshedEvent;
import org.springframework.osgi.extender.event.BootstrappingDependencyEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitStartingEvent;

@ThreadSafe
@Component(name="io.fabric8.extender.listener.spring", description="Fabric Spring Application Listener", immediate=true)
@References(value={@Reference(referenceInterface=CuratorFramework.class, bind="bindCurator", unbind="unbindCurator")})
public final class FabricSpringApplicationListener
extends AbstractExtenderListener {
    private static final String EXTENDER_TYPE = "spring";
    private ServiceRegistration<?> registration;

    @Override
    @Activate
    void activate(BundleContext bundleContext) {
        Object listener = this.createListener(bundleContext);
        if (listener != null) {
            this.registration = bundleContext.registerService(OsgiBundleApplicationContextListener.class.getName(), listener, null);
        }
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    @Override
    protected String getExtenderType() {
        return EXTENDER_TYPE;
    }

    private Object createListener(BundleContext bundleContext) {
        try {
            return new SpringApplicationListener();
        }
        catch (Throwable t) {
            return null;
        }
    }

    class SpringApplicationListener
    implements OsgiBundleApplicationContextListener {
        SpringApplicationListener() {
        }

        public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
            long bundleId = event.getBundle().getBundleId();
            ModuleStatus moduleStatus = this.toModuleStatus(event);
            FabricSpringApplicationListener.this.updateBundle(bundleId, moduleStatus);
        }

        private ModuleStatus toModuleStatus(OsgiBundleApplicationContextEvent event) {
            if (event instanceof BootstrappingDependencyEvent) {
                OsgiServiceDependencyEvent de = ((BootstrappingDependencyEvent)event).getDependencyEvent();
                if (de instanceof OsgiServiceDependencyWaitStartingEvent) {
                    return ModuleStatus.WAITING;
                }
            } else {
                if (event instanceof OsgiBundleContextFailedEvent) {
                    return ModuleStatus.FAILED;
                }
                if (event instanceof OsgiBundleContextRefreshedEvent) {
                    return ModuleStatus.STARTED;
                }
                if (event instanceof OsgiBundleContextClosedEvent) {
                    return ModuleStatus.STOPPED;
                }
            }
            return ModuleStatus.UNKNOWN;
        }
    }
}

